const char uuid_lua[] =
"(function(box)\n"
"    local ffi = require(\"ffi\")\n"
"    ffi.cdef[[\n"
"        /* from <uuid/uuid.h> */\n"
"        typedef unsigned char uuid_t[16];\n"
"        void uuid_generate(uuid_t out);\n"
"\n"
"        /* from libc */\n"
"        int snprintf(char *str, size_t size, const char *format, ...);\n"
"    ]]\n"
"\n"
"    local libuuid = nil\n"
"    local builtin = ffi.C\n"
"    function check_libs()\n"
"        if libuuid then return end\n"
"        libuuid = ffi.load('uuid.so.1')\n"
"    end\n"
"    box.uuid = function()\n"
"        check_libs()\n"
"        local uuid = ffi.new('uuid_t')\n"
"        libuuid.uuid_generate(uuid)\n"
"        return ffi.string(uuid, 16)\n"
"    end\n"
"    box.uuid_hex = function()\n"
"        check_libs()\n"
"        local uuid = ffi.new('uuid_t')\n"
"        libuuid.uuid_generate(uuid)\n"
"        local uuid_hex = ffi.new('char[33]')\n"
"        for i = 0,ffi.sizeof('uuid_t'),1 do\n"
"            builtin.snprintf(uuid_hex + i * 2, 3, \"%02x\",\n"
"                ffi.cast('unsigned int',uuid[i]))\n"
"        end\n"
"        return ffi.string(uuid_hex, 32)\n"
"    end\n"
"end)(box)\n"
""
;
