C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=MOBROT,SSI=0
C
                     SUBROUTINE MOBROT
C                    *****************
C
C     -----------------------------------
     *( NDIM,NPOINS,NBMOBS,NMOBIL,COORDS)
C     -----------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     SOLIDE MOBILE : CALCULE DES NOUVELLES             *
C                    COORDONNEES DES NOEUDS                            *
C                    CAS DES SOLIDES EN ROTATIONS SUR EUX-MEMES        *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   NDIM    !   E  ! D  ! DIMENSION DU PROBLEME                    !
C   !   NPOINS  !   E  ! D  ! NOMBRE DE NOEUDS DU MAILLAGE             !
C   !   NBMOBS  !   E  ! D  ! NOMBRE DE NOEUDS MOBILES                 !
C   !   NMOBIL  !   E  ! D  ! NUM GLOB ET NUM DE SOLIDE DES NOEUDS MOB !
C   !   COORDS  !  TR  ! M  ! COORDONNEES DES NOEUDS DU MAILLAGE       !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ROTATS
C                                     
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : RESSOL
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "mobil.h"
#include "optct.h"
#include "nlofes.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NDIM,NBMOBS,NMOBIL(NBMOBS,2)
      DOUBLE PRECISION COORDS(NPOINS,NDIM)
C
C..Variables internes
      INTEGER N,NUMSOL,NG
      DOUBLE PRECISION X,Y,Z,XT,YT,ZT,TX,TY,TZ,ARX,ARY,ARZ
      DOUBLE PRECISION AROTX,AROTY,AROTZ
C
C***********************************************************************
C
C     0- Impression
C     =============
      WRITE(NFECRA,1000)
C
C     1- CALCUL DES NOUVELLES COORDONNEES APRES ROTATION
C     ==================================================
C
      DO 100 N=1,NBMOBS
C
        NUMSOL = NMOBIL(N,2)
C
        TX = DEFMOB(NUMSOL,2)
        TY = DEFMOB(NUMSOL,3)
        TZ = DEFMOB(NUMSOL,4)
        ARX = DEFMOB(NUMSOL,5)
        ARY = DEFMOB(NUMSOL,6)
        ARZ = DEFMOB(NUMSOL,7)
        AROTX = DEFMOB(NUMSOL,8)  * RDTTS
        AROTY = DEFMOB(NUMSOL,9)  * RDTTS
        AROTZ = DEFMOB(NUMSOL,10) * RDTTS
C
        NG = NMOBIL(N,1)
C
        X = COORDS(NG,1)
        Y = COORDS(NG,2)
        Z = 0.
        IF (NDIM.EQ.3) Z = COORDS(NG,3)
C
        CALL ROTATS(X,Y,Z,XT,YT,ZT,TX,TY,TZ,ARX,ARY,ARZ,
     *              AROTX,AROTY,AROTZ)
C
        COORDS(NG,1) = XT
        COORDS(NG,2) = YT
        IF (NDIM.EQ.3) COORDS(NG,3) = ZT
C
  100 CONTINUE
C
C--------
C FORMATS
C--------
 1000 FORMAT(' *** MOBROT : Calcul des nouvelles coordonnees')
C
      RETURN
      END

