C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE DICORA
C                       *****************
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   VERIFICATION ORTHOGRAPHIQUE DU FICHIER DE DONNEES       *
C              On verifie la reconnaissance des mots-cles)             *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/OPTCT/ !      ! R  !                                             !
C   !/NLOFCT/!      ! D  !                                             !
C   !/NLOFES/!      ! D  !                                             !
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : POSCOT
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISO1
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "nlofes.h"
#include "syrth.h"
#include "nlofct.h"
C
C**********************************************************************
C
C
      INTEGER I1,I2,LCH
      LOGICAL ERR
      CHARACTER*200 CHAINE
C
C**********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
      REWIND(NFCLRA)
      ERR = .FALSE.
C
C     1- LECTURE DU FICHIER
C     =====================
C
C
   10 CONTINUE
C
      CHAINE = ' '
      READ(NFCLRA,1000,END=999) CHAINE
C
      IF (CHAINE(1:1) .EQ. '/') GOTO 10
C
      CALL POSCOT(CHAINE,I1,I2,LCH)
C
      IF (I1 .EQ. 0) GOTO 10
C
C
C     2- COMPARAISON AVEC LES MOTS-CLES AUTORISES
C     -------------------------------------------
C
      IF (CHAINE(I1:I2).EQ.
     *           'PAS DES SORTIES CHRONO RAYONNEMENT=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'STOCKAGE DES FACTEURS DE FORME SUR FICHIER=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'LECTURE DES FACTEURS DE FORME SUR FICHIER=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'STOCKAGE DES CORRESPONDANTS POUR RAYONNEMENT=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'LECTURE DES CORRESPONDANTS POUR RAYONNEMENT=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'NOMBRE DE PLANS DE SYMETRIE POUR LE RAYONNEMENT=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'NOMBRE DE BANDES SPECTRALES POUR LE RAYONNEMENT=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'PERIODICITE DE ROTATION POUR LE RAYONNEMENT=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'NOMBRE DE REDECOUPAGES POUR CALCUL DES FACTEURS DE FORME=')
     *  THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'NIVEAU DES IMPRESSIONS POUR LE RAYONNEMENT=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 
     *  'DOMAINE DE RAYONNEMENT CONFINE OUVERT SUR L EXTERIEUR=') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 'HISTORIQUES RAYONNEMENT=') THEN
        GOTO 10
C
C     3- COMPARAISON AVEC LES TYPES DE REFERENCES AUTORISEES
C     ------------------------------------------------------
C
      ELSEIF (CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS FLUIDES PAROI EQUIVALENTE')
     &  THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS OU FACES SOLIDES AVEC RAYONNEMENT CONFINE')
     & THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.
     &  'RAYONNEMENT : REFERENCES FACES COUPLEES AU SOLIDE') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.
     &   'RAYONNEMENT : REFERENCES FACES PAROI EQUIVALENTE '//
     &   'COUPLEES AU FLUIDE') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.
     &   'RAYONNEMENT : REFERENCES FACES TEMPERATURE IMPOSEE') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.
     &   'RAYONNEMENT : REFERENCES FACES FLUX IMPOSE') THEN
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2).EQ.
     &   'RAYONNEMENT : REFERENCES FACES PAROI EQUIVALENTE') THEN
        GOTO 10
C
C
C     3- COMPARAISON AVEC LES TYPES CONDITIONS AUTORISEES
C     ---------------------------------------------------
C
      ELSEIF (CHAINE(I1:I2) .EQ. 'RAYT') THEN  
        GOTO 10
C
      ELSEIF (CHAINE(I1:I2) .EQ. 'HISTORIQUES') THEN  
        GOTO 10
C
C
      ELSEIF (CHAINE(I1:I2) .EQ. 'MSTS') THEN  
        GOTO 10
C
C     5- MOT-CLE NON RECONNU
C     ----------------------
C
      ELSE
        ERR = .TRUE.
        WRITE (NFECRA,5000) CHAINE
        GOTO 10
C
      ENDIF
C
 999  CONTINUE
C
      IF (ERR) STOP
C   
C
C--------
C FORMATS
C--------
 1000 FORMAT(A200)
 5000 FORMAT(/,' %% ERREUR DICORA : MOT-CLE NON RECONNU ',/,
     &       '--> "',A,'"')
C----
C FIN
C----
C
      RETURN
      END
