
import swiginac
from swiginac import *
pi = acos(-1)

def laplace(f):
    return sum(diff(diff(u, x[i]), x[i]) for i in range(3))

def subs(f, s, v):
    repmap = exmap()
    repmap[s] = v
    return f.subs(repmap)

# --- Derivation of manufactured analytical solution:

# Some useful symbols
x = matrix(3,1, [symbol("x[%d]" % i) for i in range(3)])

a = symbol("a")
b = symbol("b")
k = symbol("k")

# Testing now:
kpix = k*pi*x[0]
kpiy = k*pi*x[1]
kpiz = k*pi*x[2]
u = a * sin(kpix)*sin(kpiy)*sin(kpiz) + b * cos(kpix)*cos(kpiy)*cos(kpiz)

# Compute volume source term
f = -laplace(u)

# Compute boundary source terms
gx0 = subs( -diff(u, x[0]), x[0], 0 )
gx1 = subs( +diff(u, x[0]), x[0], 1 )
gy0 = subs( -diff(u, x[1]), x[1], 0 )
gy1 = subs( +diff(u, x[1]), x[1], 1 )
gz0 = subs( -diff(u, x[2]), x[2], 0 )
gz1 = subs( +diff(u, x[2]), x[2], 1 )

# Print solutions
def p(x):
    #x = swiginac.normal(x)
    #x = x.evalf()
    return x.printc()
print
print "u:"
print "        values[0] = %s;" % p(u)
print 
print "f:"
print "        values[0] = %s;" % p(f)
print
print "g:"
print "        if(gx0) values[0] = %s;" % p(gx0)
print "        if(gx1) values[0] = %s;" % p(gx1)
print "        if(gy0) values[0] = %s;" % p(gy0)
print "        if(gy1) values[0] = %s;" % p(gy1)
print "        if(gz0) values[0] = %s;" % p(gz0)
print "        if(gz1) values[0] = %s;" % p(gz1)
print

