/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SCPARAM_H
#define _SC_SCPARAM_H

// sc
#include "util/Id.h"
#include "util/Error.h"
#include "ScParamVisitor.h"
#include "ScParamTypes.h"


/**
 * base class for ScCmd parameter objects.
 */
class ScParam
{
public:
  ScParam();
  virtual ~ScParam();

  /**
   * get the unique id of this object. 
   */
  ID getId();

  /**
   * visitor method.
   */
  virtual void accept( ScParamVisitor* v ) = 0;

  /**
   * set error object. takes ownership of \b err, ie. it is deleted on
   * destruction of the parameter object.
   */
  void setError( const sc::Error* err );

  /**
   * get the error object if any (i.e. returns sc::Success if there is
   * no error.
   */
  const sc::Error* getError() const;

  /**
   * check if there is an error.
   */
  bool hasError() const;

private:
  ID               _id;
  const sc::Error* _error;
};

#define ScParamAccept(T) void accept( ScParamVisitor* v )  \
{                                                          \
  ParamVisitor<T>* pv = dynamic_cast<ParamVisitor<T>*>(v); \
  if( pv )                                                 \
  {                                                        \
    pv->visit(this);                                       \
  }                                                        \
}

#endif // _SC_SCPARAM_H
