/* ====================================================================
 * Copyright (c) 2003-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MAIN_WINDOW_H
#define _SC_MAIN_WINDOW_H

// sc
#include "sublib/TargetId.h"
class Error;
class ListWidget;
class ScModel;
class DialogHandler;
class ConfigManager;
class ActionStorage;
class IconStorage;
class Project;
class Controller;
class QAssistantClient;

namespace sc
{
  class Condition;
}

// qt
#include <QtGui/QMainWindow>
class QLabel;
class Q3ListView;
class Q3ListViewItem;
class Q3PopupMenu;


class MainWindow : public QMainWindow, public TargetId
{
  typedef QMainWindow super;
  Q_OBJECT 

public:
  MainWindow( ScModel* model, ConfigManager*, QWidget *parent=0 );
  virtual ~MainWindow();

  // MainWindow overwrite
  bool showDockMenu( const QPoint& globalPos );
  void customEvent( QEvent* ce );
  void showEvent( QShowEvent* e );
  void closeEvent( QCloseEvent* e );
  bool eventFilter( QObject* t, QEvent* e );

  void keyPressEvent( QKeyEvent* e );
  void keyReleaseEvent( QKeyEvent* e );

public slots:
  void about();
  void manual();
  void manualError( const QString& msg ); 
  void settings();
  void settings( const QString& selected );
  void prjSettings( Project* prj );
  void showBookMenu();
  void showItemMenu();
  void showAdminMenu();
  void onBookmarkItem( const QString& );
  void runWcAutoUpdate();

public:
  ScModel* getModel();

private:
  void createActions();

  QStatusBar*       _sbar;
  QLabel*           _sbar1;
  QLabel*           _sbar2;
  QLabel*           _sbar3;
  QLabel*           _sbar4;
  QLabel*           _status1;

  Q3PopupMenu*      _fileMenu;
  Q3PopupMenu*      _bookMenu;
  Q3PopupMenu*      _itemMenu;
  Q3PopupMenu*      _adminMenu;

  ListWidget*       _list;

  ConfigManager*    _config;
  ScModel*          _model;
  QAssistantClient* _assistant;

  ActionStorage*    _actions;
  Controller*       _controller;
};


#endif // _SC_MAIN_WINDOW_H
