/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.constraint.ADQLConstraint;
import adql.query.operand.ADQLColumn;
import java.util.NoSuchElementException;

public class IsNull
implements ADQLConstraint {
    public static final LanguageFeature FEATURE = new LanguageFeature(null, "IS_NULL", false, "An IS NULL constraint (which tests whether an expression is NULL or not).");
    private ADQLColumn column;
    private boolean isNotNull = false;
    private TextPosition position = null;

    public IsNull(ADQLColumn column) throws NullPointerException {
        this(column, false);
    }

    public IsNull(ADQLColumn column, boolean isNot) throws NullPointerException {
        this.setColumn(column);
        this.isNotNull = isNot;
    }

    public IsNull(IsNull toCopy) throws Exception {
        this.column = (ADQLColumn)toCopy.column.getCopy();
        this.isNotNull = toCopy.isNotNull;
        this.position = toCopy.position == null ? null : new TextPosition(toCopy.position);
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    public final ADQLColumn getColumn() {
        return this.column;
    }

    public final void setColumn(ADQLColumn column) throws NullPointerException {
        if (column == null) {
            throw new NullPointerException("Impossible to compare nothing to NULL: no column has been given to build a IsNull constraint!");
        }
        this.column = column;
        this.position = null;
    }

    public final boolean isNotNull() {
        return this.isNotNull;
    }

    public final void setNotNull(boolean notNull) {
        this.isNotNull = notNull;
        this.position = null;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new IsNull(this);
    }

    @Override
    public String getName() {
        return "IS" + (this.isNotNull ? " NOT " : " ") + "NULL";
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean columnGot;
            {
                this.columnGot = IsNull.this.column == null;
            }

            @Override
            public ADQLObject next() {
                if (this.columnGot) {
                    throw new NoSuchElementException();
                }
                this.columnGot = true;
                return IsNull.this.column;
            }

            @Override
            public boolean hasNext() {
                return !this.columnGot;
            }

            @Override
            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (!this.columnGot) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called!");
                }
                if (replacer == null) {
                    this.remove();
                } else if (replacer instanceof ADQLColumn) {
                    IsNull.this.column = (ADQLColumn)replacer;
                    IsNull.this.position = null;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace a column (" + IsNull.this.column.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") in a IsNull constraint (" + IsNull.this.toADQL() + ")!");
                }
            }

            @Override
            public void remove() {
                if (!this.columnGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called!");
                }
                throw new UnsupportedOperationException("Impossible to remove the only column (" + IsNull.this.column.toADQL() + ") of a constraint IsNull (" + IsNull.this.toADQL() + ")!");
            }
        };
    }

    @Override
    public String toADQL() {
        return this.column.toADQL() + " " + this.getName();
    }
}

