/*
	SRG - Squid Report Generator
	Location Report Header
	Copyright 2005 University of Waikato

	This file is part of SRG.

	SRG is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	SRG is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with SRG; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef LOCATIONREPORT_H
#define LOCATIONREPORT_H

#include "srg.h"
#include "Report.h"

class LocationReport : public Report {

 public:
  
  LocationReport(char * location) : Report(location) {}

  void generate_report(const char *, const char *, const char *);

  void process_line(const log_line *line);
	summary_info getStats();

 private:
  list<time_t> times;
  list<bool> denied;
  list<char *> host;

};

#endif // LOCATIONSTATS_H
