-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with CommandLineData;
separate (Dictionary)
function Attribute_Is_Visible
  (Name      : LexTokenManager.Lex_String;
   Prefix    : PrefixSort;
   Type_Mark : RawDict.Type_Info_Ref;
   Scope     : Scopes)
  return      Boolean
is
   Result : Boolean;

   --------------------------------------------------------------------------------

   function Type_Attribute_Is_Visible (Name      : LexTokenManager.Lex_String;
                                       Type_Mark : RawDict.Type_Info_Ref) return Boolean
   --# global in CommandLineData.Content;
   --#        in Dict;
   --#        in LexTokenManager.State;
   is
      Result : Boolean;

      --------------------------------------------------------------------------------

      function Type_Attribute_Is_Visible_83
        (Name      : LexTokenManager.Lex_String;
         Type_Mark : RawDict.Type_Info_Ref)
        return      Boolean
      --# global in Dict;
      --#        in LexTokenManager.State;
      is
         Result : Boolean;
      begin
         if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Aft_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Delta_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Fore_Token) =
           LexTokenManager.Str_Eq then
            Result := Type_Is_Fixed_Point (Type_Mark => Type_Mark) or else Type_Mark = Get_Unknown_Type_Mark;
         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Size_Token) =
           LexTokenManager.Str_Eq then
            Result := True;
         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Digits_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Emax_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Epsilon_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Machine_Emax_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Machine_Emin_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Machine_Mantissa_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Machine_Radix_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Safe_Emax_Token) =
           LexTokenManager.Str_Eq then
            Result := Type_Is_Floating_Point (Type_Mark => Type_Mark) or else Type_Mark = Get_Unknown_Type_Mark;
         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.First_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Last_Token) =
           LexTokenManager.Str_Eq then
            if Type_Is_Scalar (Type_Mark => Type_Mark) then
               Result := True;
            elsif Type_Is_Array (Type_Mark => Type_Mark) then
               Result := RawDict.Get_Type_Constrained (Type_Mark => Type_Mark);
            else
               Result := Type_Mark = Get_Unknown_Type_Mark;
            end if;
         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Large_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Machine_Overflows_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Machine_Rounds_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Mantissa_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Safe_Large_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Safe_Small_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Small_Token) =
           LexTokenManager.Str_Eq then
            Result := Type_Is_Real (Type_Mark => Type_Mark) or else Type_Mark = Get_Unknown_Type_Mark;
         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Length_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Range_Token) =
           LexTokenManager.Str_Eq then
            if Type_Is_Array (Type_Mark => Type_Mark) then
               Result := RawDict.Get_Type_Constrained (Type_Mark => Type_Mark);
            else
               Result := Type_Mark = Get_Unknown_Type_Mark;
            end if;
         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Pos_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Pred_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Succ_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Val_Token) =
           LexTokenManager.Str_Eq then
            if Type_Is_Discrete (Type_Mark => Type_Mark) then
               Result := not Type_Is_Boolean (Type_Mark => Type_Mark);
            else
               Result := Type_Mark = Get_Unknown_Type_Mark;
            end if;
         else
            Result := False;
         end if;
         return Result;
      end Type_Attribute_Is_Visible_83;

      --------------------------------------------------------------------------------

      function Type_Attribute_Is_Visible_95
        (Name      : LexTokenManager.Lex_String;
         Type_Mark : RawDict.Type_Info_Ref)
        return      Boolean
      --# global in Dict;
      --#        in LexTokenManager.State;
      is
         Result : Boolean;
      begin
         if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Aft_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Delta_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Fore_Token) =
           LexTokenManager.Str_Eq then
            Result := Type_Is_Fixed_Point (Type_Mark => Type_Mark) or else Type_Mark = Get_Unknown_Type_Mark;
         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Size_Token) =
           LexTokenManager.Str_Eq then
            Result := True;

         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Digits_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Machine_Emax_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Machine_Emin_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Machine_Mantissa_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Denorm_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Model_Emin_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Model_Epsilon_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Model_Mantissa_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Model_Small_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Safe_First_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Safe_Last_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Signed_Zeros_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Floor_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Ceiling_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Safe_Emax_Token) =
           LexTokenManager.Str_Eq
           or else -- Obsolete but implementation-defined in SPARK95
           LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                Lex_Str2 => LexTokenManager.Emax_Token) =
           LexTokenManager.Str_Eq
           or else -- Ditto
           LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                Lex_Str2 => LexTokenManager.Epsilon_Token) =
           LexTokenManager.Str_Eq then -- Ditto
            Result := Type_Is_Floating_Point (Type_Mark => Type_Mark) or else Type_Mark = Get_Unknown_Type_Mark;

         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.First_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Last_Token) =
           LexTokenManager.Str_Eq then
            if Type_Is_Scalar (Type_Mark => Type_Mark) then
               Result := True;
            elsif Type_Is_Array (Type_Mark => Type_Mark) then
               Result := RawDict.Get_Type_Constrained (Type_Mark => Type_Mark);
            else
               Result := Type_Mark = Get_Unknown_Type_Mark;
            end if;

         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Machine_Overflows_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Machine_Rounds_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Machine_Radix_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Large_Token) =
           LexTokenManager.Str_Eq
           or else -- Obsolete but implementation-defined in SPARK95
           LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                Lex_Str2 => LexTokenManager.Mantissa_Token) =
           LexTokenManager.Str_Eq
           or else -- Ditto
           LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Safe_Large_Token) =
           LexTokenManager.Str_Eq
           or else -- Ditto
           LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Safe_Small_Token) =
           LexTokenManager.Str_Eq
           or else -- Ditto
           LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                Lex_Str2 => LexTokenManager.Small_Token) =
           LexTokenManager.Str_Eq then
            -- Obsolete but implementation-defined
            -- for floating-point types in SPARK95.
            -- OK for fixed-point types.
            Result := Type_Is_Real (Type_Mark => Type_Mark) or else Type_Mark = Get_Unknown_Type_Mark;
         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Length_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Range_Token) =
           LexTokenManager.Str_Eq then
            if Type_Is_Array (Type_Mark => Type_Mark) then
               Result := RawDict.Get_Type_Constrained (Type_Mark => Type_Mark);
            else
               Result := Type_Mark = Get_Unknown_Type_Mark;
            end if;

         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Pos_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Pred_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Succ_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Val_Token) =
           LexTokenManager.Str_Eq then
            if Type_Is_Discrete (Type_Mark) then
               Result := not Type_Is_Boolean (Type_Mark => Type_Mark);
            else
               Result := Type_Mark = Get_Unknown_Type_Mark;
            end if;

         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Name,
            Lex_Str2 => LexTokenManager.Component_Size_Token) =
           LexTokenManager.Str_Eq then
            Result := Type_Is_Array (Type_Mark => Type_Mark);

         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Min_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Max_Token) =
           LexTokenManager.Str_Eq then
            Result := (Type_Is_Scalar (Type_Mark => Type_Mark) and then not Type_Is_Boolean (Type_Mark => Type_Mark))
              or else Type_Mark = Get_Unknown_Type_Mark;

         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Modulus_Token) =
           LexTokenManager.Str_Eq then
            Result := Type_Is_Modular (Type_Mark => Type_Mark) or else Type_Mark = Get_Unknown_Type_Mark;
         else
            Result := False;
         end if;
         return Result;
      end Type_Attribute_Is_Visible_95;

      --------------------------------------------------------------------------------

      function Type_Attribute_Is_Visible_2005
        (Name      : LexTokenManager.Lex_String;
         Type_Mark : RawDict.Type_Info_Ref)
        return      Boolean
      --# global in Dict;
      --#        in LexTokenManager.State;
      is
         Result : Boolean;
      begin
         if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Mod_Token) =
           LexTokenManager.Str_Eq then
            Result := Type_Is_Modular (Type_Mark => Type_Mark);
         else
            Result := False;
         end if;
         return Result;
      end Type_Attribute_Is_Visible_2005;

   begin -- Type_Attribute_Is_Visible
      case CommandLineData.Content.Language_Profile is
         when CommandLineData.SPARK83 =>
            Result := Type_Attribute_Is_Visible_83 (Name      => Name,
                                                    Type_Mark => Type_Mark);
         when CommandLineData.SPARK95 =>
            Result := Type_Attribute_Is_Visible_95 (Name      => Name,
                                                    Type_Mark => Type_Mark);
         when CommandLineData.SPARK2005_Profiles =>
            Result := Type_Attribute_Is_Visible_95 (Name      => Name,
                                                    Type_Mark => Type_Mark)
              or else Type_Attribute_Is_Visible_2005 (Name      => Name,
                                                      Type_Mark => Type_Mark);
      end case;
      return Result;
   end Type_Attribute_Is_Visible;

   -------------------------------------------------------------------------------

   function Base_Attribute_Is_Visible (Name      : LexTokenManager.Lex_String;
                                       Type_Mark : RawDict.Type_Info_Ref) return Boolean
   --# global in CommandLineData.Content;
   --#        in Dict;
   --#        in LexTokenManager.State;
   is
      Result : Boolean;
   begin
      if Type_Attribute_Is_Visible (Name      => Name,
                                    Type_Mark => Type_Mark) then
         if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.First_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Last_Token) =
           LexTokenManager.Str_Eq then
            Result := not Type_Is_Array (Type_Mark => Type_Mark);
         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Length_Token) =
           LexTokenManager.Str_Eq
           or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                        Lex_Str2 => LexTokenManager.Range_Token) =
           LexTokenManager.Str_Eq then
            Result := False;
         else
            Result := True;
         end if;
      else
         Result := False;
      end if;
      return Result;
   end Base_Attribute_Is_Visible;

   --------------------------------------------------------------------------------

   function Object_Attribute_Is_Visible_83 (Name      : LexTokenManager.Lex_String;
                                            Type_Mark : RawDict.Type_Info_Ref) return Boolean
   --# global in Dict;
   --#        in LexTokenManager.State;
   is
      Result : Boolean;
   begin
      if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                              Lex_Str2 => LexTokenManager.Size_Token) =
        LexTokenManager.Str_Eq then
         Result := True;
      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.First_Token) =
        LexTokenManager.Str_Eq
        or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                     Lex_Str2 => LexTokenManager.Last_Token) =
        LexTokenManager.Str_Eq
        or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                     Lex_Str2 => LexTokenManager.Length_Token) =
        LexTokenManager.Str_Eq
        or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                     Lex_Str2 => LexTokenManager.Range_Token) =
        LexTokenManager.Str_Eq then
         Result := Type_Is_Array (Type_Mark => Type_Mark);
      else
         Result := False;
      end if;
      return Result;
   end Object_Attribute_Is_Visible_83;

   --------------------------------------------------------------------------------

   function Object_Attribute_Is_Visible_95 (Name      : LexTokenManager.Lex_String;
                                            Type_Mark : RawDict.Type_Info_Ref) return Boolean
   --# global in CommandLineData.Content;
   --#        in Dict;
   --#        in LexTokenManager.State;
   is
      Result : Boolean;
   begin

      if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                              Lex_Str2 => LexTokenManager.Size_Token) =
        LexTokenManager.Str_Eq then
         Result := True;

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.First_Token) =
        LexTokenManager.Str_Eq
        or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                     Lex_Str2 => LexTokenManager.Last_Token) =
        LexTokenManager.Str_Eq
        or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                     Lex_Str2 => LexTokenManager.Length_Token) =
        LexTokenManager.Str_Eq
        or else LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                     Lex_Str2 => LexTokenManager.Range_Token) =
        LexTokenManager.Str_Eq
        or else LexTokenManager.Lex_String_Case_Insensitive_Compare
        (Lex_Str1 => Name,
         Lex_Str2 => LexTokenManager.Component_Size_Token) =
        LexTokenManager.Str_Eq then
         Result := Type_Is_Array (Type_Mark => Type_Mark);
         -- Support for 'Valid in SPARK95
      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Valid_Token) =
        LexTokenManager.Str_Eq then
         -- LRM 13.9.2 (2) says 'Valid is only allowed for a prefix that
         -- denotes a scalar type.
         Result := Type_Is_Scalar (Type_Mark => Type_Mark);
      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Access_Token) =
        LexTokenManager.Str_Eq then
         Result := RawDict.Get_Type_Discriminant (Type_Mark => Type_Mark) = Protected_Type_Item
           and then CommandLineData.Ravenscar_Selected;
      else
         Result := False;
      end if;
      return Result;
   end Object_Attribute_Is_Visible_95;

begin -- Attribute_Is_Visible
   if Type_Is_Private_Here (Type_Mark => Type_Mark,
                            Scope     => Scope) then
      Result := False;
   else
      case Prefix is
         when AType =>
            Result := Type_Attribute_Is_Visible (Name      => Name,
                                                 Type_Mark => Type_Mark);
         when ABaseType =>
            Result := Base_Attribute_Is_Visible (Name      => Name,
                                                 Type_Mark => Type_Mark);
         when AnObject =>
            case CommandLineData.Content.Language_Profile is
               when CommandLineData.SPARK83 =>
                  Result := Object_Attribute_Is_Visible_83 (Name      => Name,
                                                            Type_Mark => Type_Mark);
               when CommandLineData.SPARK95_Onwards =>
                  -- Object attributes in SPARK2005/KCG are currently the same
                  -- as those of SPARK95, so...
                  Result := Object_Attribute_Is_Visible_95 (Name      => Name,
                                                            Type_Mark => Type_Mark);
            end case;
      end case;
   end if;
   return Result;
end Attribute_Is_Visible;
