# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** hub

** Author: Ralph Amissah
  [ralph@amissah.com]
  [ralph.amissah@gmail.com]

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see [http://www.gnu.org/licenses/].

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  [http://www.fsf.org/licensing/licenses/gpl.html]
  [http://www.gnu.org/licenses/gpl.html]

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  [http://www.jus.uio.no/sisu]
  [http://www.sisudoc.org]

** Git
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary]
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/hub.rb;hb=HEAD]

=end
module SiSU
  require_relative 'constants'                         # constants.rb
  require_relative 'se'                                # se.rb
    include SiSU_Env
    include SiSU_Screen
  require_relative 'hub_actions'                       # hub_actions.rb
  require_relative 'hub_loop_markup_files'             # hub_loop_markup_files.rb
  require_relative 'hub_options'                       # hub_options.rb
  require_relative 'dp'                                # dp.rb
    include SiSU_Param
  require_relative 'utils'                             # utils.rb
  begin
    require 'uri'
  rescue LoadError
    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
      error('uri NOT FOUND (LoadError)')
  end
  class HubMaster
    def initialize(argv,sisu_runtime)
      begin
        opt=SiSU_Commandline::Options.new(argv,sisu_runtime)
        SiSU::Processing.new(opt).actions_without_files
        SiSU::Processing.new(opt).actions_on_files
        SiSU::Processing.new(opt).actions_without_files_post
      rescue
        selection=(opt ? opt.selections.src : argv)
        SiSU_Screen::Ansi.new(selection,$!,$@).rescue do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
        Dir.chdir(sisu_runtime[:call_path])
      end
    end
  end
  class Processing
    begin
      require 'fileutils'
        include FileUtils
    rescue LoadError
      SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
        error('fileutils NOT FOUND (LoadError)')
    end
    @@env=nil
    attr_accessor :op
    def initialize(opt)
      @opt=opt
      @@env=@env=SiSU_Env::InfoEnv.new
      @msg,@msgs='',nil
      @tell=lambda {
        SiSU_Screen::Ansi.new(
          @opt.selections.str,
          @msg,
          "#{@msgs.inspect if @msgs}"
        )
      }
    end
    def remove_skipped_files_if_any_from_processing_files_array
      if @remove_faulty_markup_files_array.length > 0
        @opt.files = (@opt.files - @remove_faulty_markup_files_array)
      end
    end
    def print_error_message_if_files_skipped
      if @remove_faulty_markup_files_array.length > 0
        puts '---'
        STDERR.puts 'ERROR with file(s), did not process: ' +
          @remove_faulty_markup_files_array.join(',')
      end
    end
    def do_each_file_loop_check_and_perform_selected_actions(opt)
      actions=SiSU_Hub_Actions::HubActions.new(opt)
      actions.outputs.each_file.abstract_objects?
      actions.outputs.each_file.qrcode?
      actions.outputs.each_file.hash_digests?
      actions.outputs.each_file.text?
      actions.outputs.each_file.html?
      actions.outputs.each_file.xhtml?
      actions.outputs.each_file.xml?
      actions.outputs.each_file.json?
      actions.outputs.each_file.pdf?
      actions.outputs.each_file.man_or_info?
      actions.outputs.each_file.po4a_make?
      actions.outputs.each_file.sqlite_discrete?
      actions.outputs.each_file.manifest?
    end
    def do_each_file_loop_options
      if @opt.files.length > 0
        @opt.files.each_with_index do |fno,i|
          @opt.fno=fno
          @opt.fns=fno.
            gsub(/(?:https?|file):\/\/\S+\/(\S+)\.sst$/,'\1.-sst').
            gsub(/\.ssm$/,'.ssm.sst')
          @opt.f_pth=@opt.f_pths[i]
          if @opt.fns !~/\.-sst$/
            @opt.pth=@opt.f_pths[i][:pth]
            @opt.lng=@opt.f_pths[i][:lng]
          else
            @opt.pth=Dir.pwd
            @opt.lng='en'
          end
          unless @opt.pth.nil?
            @@pwd=@opt.pth
            Dir.chdir(@opt.pth) #watch
          end
          #@env=SiSU_Env::InfoEnv.new(@opt.fns)
          do_each_file_loop_check_and_perform_selected_actions(@opt)
        end
      else
        do_each_file_loop_check_and_perform_selected_actions(@opt)
      end
    end
    def do_loop_files_on_given_option_pre
      begin
        if @opt.act[:zap][:set]==:on                   #% --zap, -Z
          SiSU_Hub_Loops::OptionLoopFiles.new(@opt).loop_files_on_given_option do
            require_relative 'zap'
            SiSU_Zap::Source.new(@opt).read            # -Z     zap.rb
          end
        end
      ensure
      end
    end
    def do_loop_files_on_given_option_post
      actions=SiSU_Hub_Actions::HubActions.new(@opt)
      if defined? actions.outputs.loop_files.share_source?
        actions.outputs.loop_files.share_source?
      end
      if defined? actions.outputs.loop_files.run_termsheet?
        actions.outputs.loop_files.run_termsheet?
      end
      if defined? actions.outputs.loop_files.po4a_setup?
        actions.outputs.loop_files.po4a_setup?
      end
      if defined? actions.outputs.loop_files.sql?
        actions.outputs.loop_files.sql?
      end
      SiSU_Hub_Actions::Operations.new.counter
      if defined? actions.outputs.loop_files.manifest?
        actions.outputs.loop_files.manifest?
      end
      if defined? actions.outputs.loop_files.sitemaps?
        actions.outputs.loop_files.sitemaps?
      end
      if defined? actions.outputs.loop_files.urls?
        actions.outputs.loop_files.urls?
      end
    end
    def actions_without_files
      actions=SiSU_Hub_Actions::HubActions.new(@opt)
      actions.report.version_info?
      actions.report.version_info_extra?
      actions.prepare.site?
      actions.prepare.sql?
    end
    def actions_without_files_post
      actions=SiSU_Hub_Actions::HubActions.new(@opt)
      actions.prepare.remote_site?
      actions.prepare.search_form?
      actions.prepare.webrick?
    end
    def actions_on_files
      if @opt.act[:profile][:set]==:on
        begin
          require 'profile'
        rescue LoadError
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
            error('profile NOT FOUND (LoadError)')
        end
      end
      actions=SiSU_Hub_Actions::HubActions.new(@opt)
      actions.outputs.each_file.harvest?
      actions.outputs.init?
      do_loop_files_on_given_option_pre
      do_each_file_loop_options
      #remove_skipped_files_if_any_from_processing_files_array # NEEDS WORK
      do_loop_files_on_given_option_post
      #print_error_message_if_files_skipped
      if (@opt.act[:verbose][:set]==:on \
      || @opt.act[:verbose_plus][:set]==:on \
      || @opt.act[:maintenance][:set]==:on)
        @msg,@msgs="\tsisu -W [to start ruby web-server on output directory]\n",nil
      end
      if (@opt.act[:verbose][:set]==:on \
      || @opt.act[:verbose_plus][:set]==:on \
      || @opt.act[:maintenance][:set]==:on \
      || @opt.act[:urls_selected][:set]==:on \
      || @opt.act[:urls_all][:set]==:on)
        @tell.call.print_brown unless @opt.files.join.empty?
      end
      if defined? @@env.processing_path.processing \
      and @@env.user \
      and FileTest.directory?(@@env.processing_path.processing) \
      and @@env.processing_path.processing =~/#{@@env.user}$/
        #clean tmp processing dir of content as is located in public area
        if @@env.processing_path.processing_base_tmp =~/^\/tmp\/\S+/
          FileUtils::cd(@@env.processing_path.processing_base_tmp) do
            FileUtils::rm_rf('.') unless @opt.act[:maintenance][:set] ==:on
          end
        end
      end
    end
  end
  class HubClose
    def initialize(call_path,argv)
      begin
        env=SiSU_Env::InfoEnv.new
      rescue
      ensure
        if FileTest.directory?(env.processing_path.processing) \
        and FileTest.directory?(env.processing_path.processing_base_tmp) \
        and env.processing_path.processing_base_tmp =~ /#{env.processing_path.processing}/ \
        and env.processing_path.processing_base_tmp =~/^\/tmp\/\S+/ \
        and not argv.inspect =~/"--maintenance"|"-M"/
          FileUtils::cd(env.processing_path.processing_base_tmp) do
            FileUtils::rm_rf('.')
          end
        end
        Dir.chdir(call_path)
      end
    end
  end
end
__END__
