/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.sikuli.script.Region;

public class Bracket
extends Component {
    public static final int SIDE_LEFT = 1;
    public static final int SIDE_RIGHT = 2;
    public static final int SIDE_TOP = 3;
    public static final int SIDE_BOTTOM = 4;
    int side;
    Region region;
    int thickness = 10;
    int margin = 5;

    public Bracket(Region region) {
        this.region = region;
        this.setSide(1);
    }

    public void setSide(int n) {
        this.side = n;
        if (n == 2) {
            this.setBounds(this.region.x + this.region.w, this.region.y, this.thickness, this.region.h);
        } else if (n == 1) {
            this.setBounds(this.region.x - 10, this.region.y, this.thickness, this.region.h);
        } else if (n == 3) {
            this.setBounds(this.region.x, this.region.y - 10, this.region.w, this.thickness);
        } else if (n == 4) {
            this.setBounds(this.region.x, this.region.y + this.region.h, this.region.w, this.thickness);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        BasicStroke basicStroke = new BasicStroke(3.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(Color.red);
        int n = this.side == 1 || this.side == 2 ? this.region.h : this.region.w;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(5.0f, 5.0f);
        generalPath.lineTo(5.0f, n / 2 - 6);
        generalPath.lineTo(8.0f, n / 2);
        generalPath.lineTo(5.0f, n / 2 + 6);
        generalPath.lineTo(5.0f, n - 5);
        generalPath.lineTo(0.0f, n);
        AffineTransform affineTransform = new AffineTransform();
        if (this.side == 1) {
            affineTransform.translate(10.0, this.region.h);
            affineTransform.rotate(Math.PI);
            graphics2D.transform(affineTransform);
        } else if (this.side == 3) {
            affineTransform.translate(0.0, 10.0);
            affineTransform.rotate(-1.5707963267948966);
            graphics2D.transform(affineTransform);
        } else if (this.side == 4) {
            affineTransform.translate(this.region.w, 0.0);
            affineTransform.rotate(1.5707963267948966);
            graphics2D.transform(affineTransform);
        }
        graphics2D.draw(generalPath);
    }
}

