#include <iostream>
#include <sigxconfig.h>
#include <glibmm/thread.h>
#include <gtkmm/main.h>
#include "thegui.h"


#ifdef SIGC_MSC

// windows and msvc++
#  if (_WIN32_WINNT >= 0x0501)
#  include <winsock2.h>
#  else
// must include for versions earlier than win xp
#  include <Wspiapi.h>
#  endif

int main(int argc, char** argv)
{
	// initialization
	Glib::thread_init();
	WSADATA wsad = {};
	// require socket library min version 1.1
	WSAStartup(MAKEWORD(1, 1), &wsad);

	// scope for application
	{
		Gtk::Main theApp(argc, argv);
		
		TheGUI gui;
		theApp.run(gui);
	}

	WSACleanup();
	return 0;
}

#else

int main(int argc, char** argv)
{
	// initialization
	Glib::thread_init();

	// scope for application
	{
		Gtk::Main theApp(argc, argv);
		
		TheGUI gui;
		theApp.run(gui);
	}

	return 0;
}

#endif
