shotman(1)

# NAME

shotman - uncompromising screenshot gui for wayland

# SYNOPSIS

*shotman* [options...]

# OPTIONS

*-c, --capture TARGET*
	Specify which target to capture. See TARGETS below. 

*-C --copy*
	Automatically copy screenshot to clipboard.

*-v --verbose*
	Verbose logging. Can be specified more than.

*-a, --anchor ANCHOR*
	Anchor thumbnail to this edge of the screen (default: top-left).

*-h --help*
	Print help information (use `-h` for a summary)

*-V --version*
	Print version information and exit

# DESCRIPTION

*shotman* takes a screenshot and shows it in a small floating thumbnail window.

Screenshots are saved immediately. The first of the following locations that is
defined is used (i.e.: if the environment variable is undefined, the next one on
the list is used).

. _$XDG_SCREENSHOTS_DIR/_
. _$XDG_PICTURES_DIR/screenshots/_
. _$HOME/screenshots/_
. The current directory.

*shotman* requires a compositor that supports *wlr_screencopy* and
*wlr_layer_shell*.

# KEYBOARD CONTROLS

The following are applicable while the thumbnail window is focused:

- *Esc* or *q*: quit, keeping the saved the screenshot
- *Del* or *d*: discard (delete) the screenshot and exit
- *Ctrl+C* or *XF86Copy*: copy the screenshot into the clipboard
- *Ctrl+X* or *XF86Cut*: cut the screenshot file into the clipboard *(not implemented)*
- *Space*: Unfocus screenshot window
- *f*: Toggle fullscreen *(not implemented)*
- *e*: Edit image (opens it in GIMP) *(not implemented)*
- *h,j,k,l*: Move preview to another corner

When quitting, if the screenshot has been copied into the clipboard, shotman
will continue running in the background to allow pasting it. Shotman will exit
as soon as it loses clipboard ownership.

# TARGETS

*window*
	The currently active window. Only available on *swaywm*. Requires
	*swaymsg*.

*region*
	An interactively picked region. Uses and requires *slurp* for picking
	the region.

*output*
	The current active output.

# ENVIRONMENT

_WAYLAND_DISPLAY_
	Connect to the specific wayland socket instead of the default.

_IMAGE_EDITOR_
	Specified the image editor to use to edit a screenshot.

# PRIVACY

Shotman only saves the screenshot to disk, and will copy it into the clipboard
when manually requested by the user. No internet access is involved.

# DEVELOPMENT

For issues and general development inquiries, see the project home currently
hosted at SourceHut:

	https://git.sr.ht/~whynothugo/shotman

# HAIKU

Fast and simple tool,
Shotman captures the scene,
Wayland's beauty preserved.

# SEE ALSO

slurp(1)
swaymsg(1)

# AUTHORS

Developed by Hugo O. Barrera <hugo@whynothugo.nl>.

shotman is an open source project licensed under the ISC licence and developed
for anyone to use freely. If you would like to sponsor this project, see:

	https://whynothugo.nl/sponsor
