# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
# Copyright 2012 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.

class MainWindow(object):
    """An emulator class that makes it easy to interact with the app."""

    def __init__(self, app):
        self.app = app

    def get_qml_view(self):
        """Get the main QML view"""
        return self.app.select_single("MainView")

    def get_root(self):
        """Returns the root item of the scene."""
        return self.app.select_single("MainView", objectName="shareApp")

    def get_cancel_button(self):
        """Returns the cancel button."""
        return self.app.select_single("Button",
                                      objectName="cancelButton")

    def get_post_button(self):
        """Returns the post button."""
        return self.app.select_single("Button",
                                      objectName="postButton")

    def get_message_area(self):
        """Returns the message area."""
        return self.app.select_single("UbuntuShape",
                                      objectName="messageArea")


