/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

// The following builtin palettes are extracted from the resource forks
// in the Director for Windows 4 projector executable.

static byte macPalette[768] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0xff, 0xff, 0x99, 0xff, 0xff, 0x66,  //   0 (0x00)
	0xff, 0xff, 0x33, 0xff, 0xff, 0x00, 0xff, 0xcc, 0xff, 0xff, 0xcc, 0xcc,  //   4 (0x04)
	0xff, 0xcc, 0x99, 0xff, 0xcc, 0x66, 0xff, 0xcc, 0x33, 0xff, 0xcc, 0x00,  //   8 (0x08)
	0xff, 0x99, 0xff, 0xff, 0x99, 0xcc, 0xff, 0x99, 0x99, 0xff, 0x99, 0x66,  //  12 (0x0c)
	0xff, 0x99, 0x33, 0xff, 0x99, 0x00, 0xff, 0x66, 0xff, 0xff, 0x66, 0xcc,  //  16 (0x10)
	0xff, 0x66, 0x99, 0xff, 0x66, 0x66, 0xff, 0x66, 0x33, 0xff, 0x66, 0x00,  //  20 (0x14)
	0xff, 0x33, 0xff, 0xff, 0x33, 0xcc, 0xff, 0x33, 0x99, 0xff, 0x33, 0x66,  //  24 (0x18)
	0xff, 0x33, 0x33, 0xff, 0x33, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0xcc,  //  28 (0x1c)
	0xff, 0x00, 0x99, 0xff, 0x00, 0x66, 0xff, 0x00, 0x33, 0xff, 0x00, 0x00,  //  32 (0x20)
	0xcc, 0xff, 0xff, 0xcc, 0xff, 0xcc, 0xcc, 0xff, 0x99, 0xcc, 0xff, 0x66,  //  36 (0x24)
	0xcc, 0xff, 0x33, 0xcc, 0xff, 0x00, 0xcc, 0xcc, 0xff, 0xcc, 0xcc, 0xcc,  //  40 (0x28)
	0xcc, 0xcc, 0x99, 0xcc, 0xcc, 0x66, 0xcc, 0xcc, 0x33, 0xcc, 0xcc, 0x00,  //  44 (0x2c)
	0xcc, 0x99, 0xff, 0xcc, 0x99, 0xcc, 0xcc, 0x99, 0x99, 0xcc, 0x99, 0x66,  //  48 (0x30)
	0xcc, 0x99, 0x33, 0xcc, 0x99, 0x00, 0xcc, 0x66, 0xff, 0xcc, 0x66, 0xcc,  //  52 (0x34)
	0xcc, 0x66, 0x99, 0xcc, 0x66, 0x66, 0xcc, 0x66, 0x33, 0xcc, 0x66, 0x00,  //  56 (0x38)
	0xcc, 0x33, 0xff, 0xcc, 0x33, 0xcc, 0xcc, 0x33, 0x99, 0xcc, 0x33, 0x66,  //  60 (0x3c)
	0xcc, 0x33, 0x33, 0xcc, 0x33, 0x00, 0xcc, 0x00, 0xff, 0xcc, 0x00, 0xcc,  //  64 (0x40)
	0xcc, 0x00, 0x99, 0xcc, 0x00, 0x66, 0xcc, 0x00, 0x33, 0xcc, 0x00, 0x00,  //  68 (0x44)
	0x99, 0xff, 0xff, 0x99, 0xff, 0xcc, 0x99, 0xff, 0x99, 0x99, 0xff, 0x66,  //  72 (0x48)
	0x99, 0xff, 0x33, 0x99, 0xff, 0x00, 0x99, 0xcc, 0xff, 0x99, 0xcc, 0xcc,  //  76 (0x4c)
	0x99, 0xcc, 0x99, 0x99, 0xcc, 0x66, 0x99, 0xcc, 0x33, 0x99, 0xcc, 0x00,  //  80 (0x50)
	0x99, 0x99, 0xff, 0x99, 0x99, 0xcc, 0x99, 0x99, 0x99, 0x99, 0x99, 0x66,  //  84 (0x54)
	0x99, 0x99, 0x33, 0x99, 0x99, 0x00, 0x99, 0x66, 0xff, 0x99, 0x66, 0xcc,  //  88 (0x58)
	0x99, 0x66, 0x99, 0x99, 0x66, 0x66, 0x99, 0x66, 0x33, 0x99, 0x66, 0x00,  //  92 (0x5c)
	0x99, 0x33, 0xff, 0x99, 0x33, 0xcc, 0x99, 0x33, 0x99, 0x99, 0x33, 0x66,  //  96 (0x60)
	0x99, 0x33, 0x33, 0x99, 0x33, 0x00, 0x99, 0x00, 0xff, 0x99, 0x00, 0xcc,  // 100 (0x64)
	0x99, 0x00, 0x99, 0x99, 0x00, 0x66, 0x99, 0x00, 0x33, 0x99, 0x00, 0x00,  // 104 (0x68)
	0x66, 0xff, 0xff, 0x66, 0xff, 0xcc, 0x66, 0xff, 0x99, 0x66, 0xff, 0x66,  // 108 (0x6c)
	0x66, 0xff, 0x33, 0x66, 0xff, 0x00, 0x66, 0xcc, 0xff, 0x66, 0xcc, 0xcc,  // 112 (0x70)
	0x66, 0xcc, 0x99, 0x66, 0xcc, 0x66, 0x66, 0xcc, 0x33, 0x66, 0xcc, 0x00,  // 116 (0x74)
	0x66, 0x99, 0xff, 0x66, 0x99, 0xcc, 0x66, 0x99, 0x99, 0x66, 0x99, 0x66,  // 120 (0x78)
	0x66, 0x99, 0x33, 0x66, 0x99, 0x00, 0x66, 0x66, 0xff, 0x66, 0x66, 0xcc,  // 124 (0x7c)
	0x66, 0x66, 0x99, 0x66, 0x66, 0x66, 0x66, 0x66, 0x33, 0x66, 0x66, 0x00,  // 128 (0x80)
	0x66, 0x33, 0xff, 0x66, 0x33, 0xcc, 0x66, 0x33, 0x99, 0x66, 0x33, 0x66,  // 132 (0x84)
	0x66, 0x33, 0x33, 0x66, 0x33, 0x00, 0x66, 0x00, 0xff, 0x66, 0x00, 0xcc,  // 136 (0x88)
	0x66, 0x00, 0x99, 0x66, 0x00, 0x66, 0x66, 0x00, 0x33, 0x66, 0x00, 0x00,  // 140 (0x8c)
	0x33, 0xff, 0xff, 0x33, 0xff, 0xcc, 0x33, 0xff, 0x99, 0x33, 0xff, 0x66,  // 144 (0x90)
	0x33, 0xff, 0x33, 0x33, 0xff, 0x00, 0x33, 0xcc, 0xff, 0x33, 0xcc, 0xcc,  // 148 (0x94)
	0x33, 0xcc, 0x99, 0x33, 0xcc, 0x66, 0x33, 0xcc, 0x33, 0x33, 0xcc, 0x00,  // 152 (0x98)
	0x33, 0x99, 0xff, 0x33, 0x99, 0xcc, 0x33, 0x99, 0x99, 0x33, 0x99, 0x66,  // 156 (0x9c)
	0x33, 0x99, 0x33, 0x33, 0x99, 0x00, 0x33, 0x66, 0xff, 0x33, 0x66, 0xcc,  // 160 (0xa0)
	0x33, 0x66, 0x99, 0x33, 0x66, 0x66, 0x33, 0x66, 0x33, 0x33, 0x66, 0x00,  // 164 (0xa4)
	0x33, 0x33, 0xff, 0x33, 0x33, 0xcc, 0x33, 0x33, 0x99, 0x33, 0x33, 0x66,  // 168 (0xa8)
	0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x33, 0x00, 0xff, 0x33, 0x00, 0xcc,  // 172 (0xac)
	0x33, 0x00, 0x99, 0x33, 0x00, 0x66, 0x33, 0x00, 0x33, 0x33, 0x00, 0x00,  // 176 (0xb0)
	0x00, 0xff, 0xff, 0x00, 0xff, 0xcc, 0x00, 0xff, 0x99, 0x00, 0xff, 0x66,  // 180 (0xb4)
	0x00, 0xff, 0x33, 0x00, 0xff, 0x00, 0x00, 0xcc, 0xff, 0x00, 0xcc, 0xcc,  // 184 (0xb8)
	0x00, 0xcc, 0x99, 0x00, 0xcc, 0x66, 0x00, 0xcc, 0x33, 0x00, 0xcc, 0x00,  // 188 (0xbc)
	0x00, 0x99, 0xff, 0x00, 0x99, 0xcc, 0x00, 0x99, 0x99, 0x00, 0x99, 0x66,  // 192 (0xc0)
	0x00, 0x99, 0x33, 0x00, 0x99, 0x00, 0x00, 0x66, 0xff, 0x00, 0x66, 0xcc,  // 196 (0xc4)
	0x00, 0x66, 0x99, 0x00, 0x66, 0x66, 0x00, 0x66, 0x33, 0x00, 0x66, 0x00,  // 200 (0xc8)
	0x00, 0x33, 0xff, 0x00, 0x33, 0xcc, 0x00, 0x33, 0x99, 0x00, 0x33, 0x66,  // 204 (0xcc)
	0x00, 0x33, 0x33, 0x00, 0x33, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xcc,  // 208 (0xd0)
	0x00, 0x00, 0x99, 0x00, 0x00, 0x66, 0x00, 0x00, 0x33, 0xee, 0x00, 0x00,  // 212 (0xd4)
	0xdd, 0x00, 0x00, 0xbb, 0x00, 0x00, 0xaa, 0x00, 0x00, 0x88, 0x00, 0x00,  // 216 (0xd8)
	0x77, 0x00, 0x00, 0x55, 0x00, 0x00, 0x44, 0x00, 0x00, 0x22, 0x00, 0x00,  // 220 (0xdc)
	0x11, 0x00, 0x00, 0x00, 0xee, 0x00, 0x00, 0xdd, 0x00, 0x00, 0xbb, 0x00,  // 224 (0xe0)
	0x00, 0xaa, 0x00, 0x00, 0x88, 0x00, 0x00, 0x77, 0x00, 0x00, 0x55, 0x00,  // 228 (0xe4)
	0x00, 0x44, 0x00, 0x00, 0x22, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0xee,  // 232 (0xe8)
	0x00, 0x00, 0xdd, 0x00, 0x00, 0xbb, 0x00, 0x00, 0xaa, 0x00, 0x00, 0x88,  // 236 (0xec)
	0x00, 0x00, 0x77, 0x00, 0x00, 0x55, 0x00, 0x00, 0x44, 0x00, 0x00, 0x22,  // 240 (0xf0)
	0x00, 0x00, 0x11, 0xee, 0xee, 0xee, 0xdd, 0xdd, 0xdd, 0xbb, 0xbb, 0xbb,  // 244 (0xf4)
	0xaa, 0xaa, 0xaa, 0x88, 0x88, 0x88, 0x77, 0x77, 0x77, 0x55, 0x55, 0x55,  // 248 (0xf8)
	0x44, 0x44, 0x44, 0x22, 0x22, 0x22, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00,  // 252 (0xfc)
};


// Below is how the 16-color Mac palette is stored in the Director 4 for Windows resource fork 1:
/* static byte mac16Palette[48] = {
	0xff, 0xff, 0xff, 0xfc, 0xf3, 0x05, 0xff, 0x64, 0x02, 0xdd, 0x08, 0x06,  //   0 (0x00)
	0xf2, 0x08, 0x84, 0x46, 0x00, 0xa5, 0x00, 0x00, 0xd4, 0x02, 0xab, 0xea,  //   4 (0x04)
	0x1f, 0xb7, 0x14, 0x00, 0x64, 0x11, 0x56, 0x2c, 0x05, 0x90, 0x71, 0x3a,  //   8 (0x08)
	0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00,  //  12 (0x0c)
}; */

// Below is the palette that is actually expected to decode 4-bit images.
// This was achieved by screenshot sampling; the actual storage is unknown.
static byte mac16Palette[48] = {
	0xff, 0xff, 0xff, 0xba, 0xba, 0xba, 0xff, 0xff, 0x00, 0x8a, 0x8a, 0x8a,  //   0 (0x00)
	0x9a, 0xce, 0xff, 0x9a, 0x65, 0x31, 0x00, 0x9a, 0x00, 0x9a, 0xce, 0x00,  //   4 (0x04)
	0xce, 0x00, 0xce, 0x9a, 0x00, 0x9a, 0xff, 0x00, 0x31, 0xff, 0x9a, 0x31,  //   8 (0x08)
	0x00, 0x00, 0xef, 0x00, 0xff, 0xce, 0x65, 0x65, 0x65, 0x00, 0x00, 0x00,  //  12 (0x0c)
};


static byte rainbow16Palette[48] = {
	0xff, 0xff, 0xff, 0x00, 0x0a, 0xff, 0x5f, 0x00, 0xff, 0xc5, 0x00, 0xff,  //   0 (0x00)
	0xff, 0x00, 0xd2, 0xff, 0x00, 0x6c, 0xff, 0x00, 0x06, 0xff, 0x5f, 0x00,  //   4 (0x04)
	0xff, 0xc5, 0x00, 0xd2, 0xff, 0x00, 0x6c, 0xff, 0x00, 0x06, 0xff, 0x00,  //   8 (0x08)
	0x00, 0xff, 0x5f, 0x00, 0xff, 0xc5, 0x00, 0xd2, 0xff, 0x00, 0x00, 0x00,  //  12 (0x0c)
};

static byte grayscale16Palette[48] = {
	0xff, 0xff, 0xff, 0xee, 0xee, 0xee, 0xdd, 0xdd, 0xdd, 0xcc, 0xcc, 0xcc,  //   0 (0x00)
	0xba, 0xba, 0xba, 0xa9, 0xa9, 0xa9, 0x98, 0x98, 0x98, 0x87, 0x87, 0x87,  //   4 (0x04)
	0x76, 0x76, 0x76, 0x65, 0x65, 0x65, 0x54, 0x54, 0x54, 0x43, 0x43, 0x43,  //   8 (0x08)
	0x31, 0x31, 0x31, 0x20, 0x20, 0x20, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00,  //  12 (0x0c)
};

static byte pastels16Palette[48] = {
	0xff, 0xff, 0xff, 0xfd, 0xbe, 0x47, 0xef, 0x65, 0x48, 0xc8, 0x37, 0x44,  //   0 (0x00)
	0xe6, 0x43, 0x8b, 0x91, 0x46, 0xb8, 0x4b, 0x44, 0xdb, 0x46, 0xb9, 0xee,  //   4 (0x04)
	0x5c, 0xcb, 0x53, 0x48, 0x8c, 0x50, 0x94, 0x78, 0x48, 0xf8, 0xd3, 0x49,  //   8 (0x08)
	0xe9, 0x4b, 0x62, 0xba, 0x48, 0xb9, 0x88, 0x88, 0xe6, 0x00, 0x00, 0x00,  //  12 (0x0c)
};

static byte vivid16Palette[48] = {
	0xff, 0xff, 0xff, 0xfc, 0xcc, 0x03, 0xf3, 0x44, 0x02, 0xc8, 0x04, 0x0d,  //   0 (0x00)
	0xcb, 0x03, 0x4a, 0x96, 0x03, 0x95, 0x1b, 0x00, 0xc1, 0x01, 0x72, 0xe2,  //   4 (0x04)
	0x17, 0xb3, 0x4d, 0x06, 0x74, 0x11, 0x4a, 0x33, 0x06, 0xf0, 0xe5, 0x04,  //   8 (0x08)
	0xdc, 0x07, 0x06, 0xe1, 0x07, 0x89, 0x20, 0x20, 0xd7, 0x00, 0x00, 0x00,  //  12 (0x0c)
};

static byte ntsc16Palette[48] = {
	0xff, 0xff, 0xff, 0xbe, 0xbe, 0xbe, 0xff, 0xe6, 0x00, 0x80, 0x80, 0x80,  //   0 (0x00)
	0x56, 0x2c, 0x05, 0x7c, 0x60, 0x1b, 0x00, 0x9e, 0x00, 0x00, 0x64, 0x11,  //   4 (0x04)
	0xde, 0x00, 0xbf, 0x46, 0x00, 0xa5, 0xfa, 0x00, 0x39, 0xff, 0x8c, 0x32,  //   8 (0x08)
	0x00, 0x00, 0xea, 0x02, 0xab, 0xea, 0x64, 0x64, 0x64, 0x00, 0x00, 0x00,  //  12 (0x0c)
};

static byte metallic16Palette[48] = {
	0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff,  //   0 (0x00)
	0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x7f, 0x7f, 0x7f,  //   4 (0x04)
	0xbf, 0xbf, 0xbf, 0x00, 0x7f, 0x7f, 0x7f, 0x00, 0x7f, 0x00, 0x00, 0x7f,  //   8 (0x08)
	0x7f, 0x7f, 0x00, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00,  //  12 (0x0c)
};

static byte rainbowPalette[768] = {
	0xff, 0xff, 0xff, 0x00, 0x69, 0xff, 0x00, 0x63, 0xff, 0x00, 0x5d, 0xff,  //   0 (0x00)
	0x00, 0x56, 0xff, 0x00, 0x50, 0xff, 0x00, 0x4a, 0xff, 0x00, 0x43, 0xff,  //   4 (0x04)
	0x00, 0x3d, 0xff, 0x00, 0x36, 0xff, 0x00, 0x30, 0xff, 0x00, 0x2a, 0xff,  //   8 (0x08)
	0x00, 0x23, 0xff, 0x00, 0x1d, 0xff, 0x00, 0x17, 0xff, 0x00, 0x10, 0xff,  //  12 (0x0c)
	0x00, 0x0a, 0xff, 0x00, 0x03, 0xff, 0x06, 0x00, 0xff, 0x0c, 0x00, 0xff,  //  16 (0x10)
	0x13, 0x00, 0xff, 0x19, 0x00, 0xff, 0x1f, 0x00, 0xff, 0x26, 0x00, 0xff,  //  20 (0x14)
	0x2c, 0x00, 0xff, 0x33, 0x00, 0xff, 0x39, 0x00, 0xff, 0x3f, 0x00, 0xff,  //  24 (0x18)
	0x46, 0x00, 0xff, 0x4c, 0x00, 0xff, 0x52, 0x00, 0xff, 0x59, 0x00, 0xff,  //  28 (0x1c)
	0x5f, 0x00, 0xff, 0x66, 0x00, 0xff, 0x6c, 0x00, 0xff, 0x72, 0x00, 0xff,  //  32 (0x20)
	0x79, 0x00, 0xff, 0x7f, 0x00, 0xff, 0x85, 0x00, 0xff, 0x8c, 0x00, 0xff,  //  36 (0x24)
	0x92, 0x00, 0xff, 0x99, 0x00, 0xff, 0x9f, 0x00, 0xff, 0xa5, 0x00, 0xff,  //  40 (0x28)
	0xac, 0x00, 0xff, 0xb2, 0x00, 0xff, 0xb8, 0x00, 0xff, 0xbf, 0x00, 0xff,  //  44 (0x2c)
	0xc5, 0x00, 0xff, 0xcc, 0x00, 0xff, 0xd2, 0x00, 0xff, 0xd8, 0x00, 0xff,  //  48 (0x30)
	0xdf, 0x00, 0xff, 0xe5, 0x00, 0xff, 0xeb, 0x00, 0xff, 0xf2, 0x00, 0xff,  //  52 (0x34)
	0xf8, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0xf8, 0xff, 0x00, 0xf2,  //  56 (0x38)
	0xff, 0x00, 0xeb, 0xff, 0x00, 0xe5, 0xff, 0x00, 0xdf, 0xff, 0x00, 0xd8,  //  60 (0x3c)
	0xff, 0x00, 0xd2, 0xff, 0x00, 0xcc, 0xff, 0x00, 0xc5, 0xff, 0x00, 0xbf,  //  64 (0x40)
	0xff, 0x00, 0xb8, 0xff, 0x00, 0xb2, 0xff, 0x00, 0xac, 0xff, 0x00, 0xa5,  //  68 (0x44)
	0xff, 0x00, 0x9f, 0xff, 0x00, 0x99, 0xff, 0x00, 0x92, 0xff, 0x00, 0x8c,  //  72 (0x48)
	0xff, 0x00, 0x85, 0xff, 0x00, 0x7f, 0xff, 0x00, 0x79, 0xff, 0x00, 0x72,  //  76 (0x4c)
	0xff, 0x00, 0x6c, 0xff, 0x00, 0x66, 0xff, 0x00, 0x5f, 0xff, 0x00, 0x59,  //  80 (0x50)
	0xff, 0x00, 0x52, 0xff, 0x00, 0x4c, 0xff, 0x00, 0x46, 0xff, 0x00, 0x3f,  //  84 (0x54)
	0xff, 0x00, 0x39, 0xff, 0x00, 0x33, 0xff, 0x00, 0x2c, 0xff, 0x00, 0x26,  //  88 (0x58)
	0xff, 0x00, 0x1f, 0xff, 0x00, 0x19, 0xff, 0x00, 0x13, 0xff, 0x00, 0x0c,  //  92 (0x5c)
	0xff, 0x00, 0x06, 0xff, 0x00, 0x00, 0xff, 0x06, 0x00, 0xff, 0x0c, 0x00,  //  96 (0x60)
	0xff, 0x13, 0x00, 0xff, 0x19, 0x00, 0xff, 0x1f, 0x00, 0xff, 0x26, 0x00,  // 100 (0x64)
	0xff, 0x2c, 0x00, 0xff, 0x33, 0x00, 0xff, 0x39, 0x00, 0xff, 0x3f, 0x00,  // 104 (0x68)
	0xff, 0x46, 0x00, 0xff, 0x4c, 0x00, 0xff, 0x52, 0x00, 0xff, 0x59, 0x00,  // 108 (0x6c)
	0xff, 0x5f, 0x00, 0xff, 0x66, 0x00, 0xff, 0x6c, 0x00, 0xff, 0x72, 0x00,  // 112 (0x70)
	0xff, 0x79, 0x00, 0xff, 0x7f, 0x00, 0xff, 0x85, 0x00, 0xff, 0x8c, 0x00,  // 116 (0x74)
	0xff, 0x92, 0x00, 0xff, 0x99, 0x00, 0xff, 0x9f, 0x00, 0xff, 0xa5, 0x00,  // 120 (0x78)
	0xff, 0xac, 0x00, 0xff, 0xb2, 0x00, 0xff, 0xb8, 0x00, 0xff, 0xbf, 0x00,  // 124 (0x7c)
	0xff, 0xc5, 0x00, 0xff, 0xcc, 0x00, 0xff, 0xd2, 0x00, 0xff, 0xd8, 0x00,  // 128 (0x80)
	0xff, 0xdf, 0x00, 0xff, 0xe5, 0x00, 0xff, 0xeb, 0x00, 0xff, 0xf2, 0x00,  // 132 (0x84)
	0xff, 0xf8, 0x00, 0xff, 0xff, 0x00, 0xf8, 0xff, 0x00, 0xf2, 0xff, 0x00,  // 136 (0x88)
	0xeb, 0xff, 0x00, 0xe5, 0xff, 0x00, 0xdf, 0xff, 0x00, 0xd8, 0xff, 0x00,  // 140 (0x8c)
	0xd2, 0xff, 0x00, 0xcc, 0xff, 0x00, 0xc5, 0xff, 0x00, 0xbf, 0xff, 0x00,  // 144 (0x90)
	0xb8, 0xff, 0x00, 0xb2, 0xff, 0x00, 0xac, 0xff, 0x00, 0xa5, 0xff, 0x00,  // 148 (0x94)
	0x9f, 0xff, 0x00, 0x99, 0xff, 0x00, 0x92, 0xff, 0x00, 0x8c, 0xff, 0x00,  // 152 (0x98)
	0x85, 0xff, 0x00, 0x7f, 0xff, 0x00, 0x79, 0xff, 0x00, 0x72, 0xff, 0x00,  // 156 (0x9c)
	0x6c, 0xff, 0x00, 0x66, 0xff, 0x00, 0x5f, 0xff, 0x00, 0x59, 0xff, 0x00,  // 160 (0xa0)
	0x52, 0xff, 0x00, 0x4c, 0xff, 0x00, 0x46, 0xff, 0x00, 0x3f, 0xff, 0x00,  // 164 (0xa4)
	0x39, 0xff, 0x00, 0x33, 0xff, 0x00, 0x2c, 0xff, 0x00, 0x26, 0xff, 0x00,  // 168 (0xa8)
	0x1f, 0xff, 0x00, 0x19, 0xff, 0x00, 0x13, 0xff, 0x00, 0x0c, 0xff, 0x00,  // 172 (0xac)
	0x06, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x06, 0x00, 0xff, 0x0c,  // 176 (0xb0)
	0x00, 0xff, 0x13, 0x00, 0xff, 0x19, 0x00, 0xff, 0x1f, 0x00, 0xff, 0x26,  // 180 (0xb4)
	0x00, 0xff, 0x2c, 0x00, 0xff, 0x33, 0x00, 0xff, 0x39, 0x00, 0xff, 0x3f,  // 184 (0xb8)
	0x00, 0xff, 0x46, 0x00, 0xff, 0x4c, 0x00, 0xff, 0x52, 0x00, 0xff, 0x59,  // 188 (0xbc)
	0x00, 0xff, 0x5f, 0x00, 0xff, 0x66, 0x00, 0xff, 0x6c, 0x00, 0xff, 0x72,  // 192 (0xc0)
	0x00, 0xff, 0x79, 0x00, 0xff, 0x7f, 0x00, 0xff, 0x85, 0x00, 0xff, 0x8c,  // 196 (0xc4)
	0x00, 0xff, 0x92, 0x00, 0xff, 0x99, 0x00, 0xff, 0x9f, 0x00, 0xff, 0xa5,  // 200 (0xc8)
	0x00, 0xff, 0xac, 0x00, 0xff, 0xb2, 0x00, 0xff, 0xb8, 0x00, 0xff, 0xbf,  // 204 (0xcc)
	0x00, 0xff, 0xc5, 0x00, 0xff, 0xcc, 0x00, 0xff, 0xd2, 0x00, 0xff, 0xd8,  // 208 (0xd0)
	0x00, 0xff, 0xdf, 0x00, 0xff, 0xe5, 0x00, 0xff, 0xeb, 0x00, 0xff, 0xf2,  // 212 (0xd4)
	0x00, 0xff, 0xf8, 0x00, 0xff, 0xff, 0x00, 0xf8, 0xff, 0x00, 0xf2, 0xff,  // 216 (0xd8)
	0x00, 0xeb, 0xff, 0x00, 0xe5, 0xff, 0x00, 0xdf, 0xff, 0x00, 0xd8, 0xff,  // 220 (0xdc)
	0x00, 0xd2, 0xff, 0x00, 0xcc, 0xff, 0x00, 0xc5, 0xff, 0x00, 0xbf, 0xff,  // 224 (0xe0)
	0x00, 0xb8, 0xff, 0x00, 0xb2, 0xff, 0x00, 0xac, 0xff, 0x00, 0xa5, 0xff,  // 228 (0xe4)
	0x00, 0x9f, 0xff, 0x00, 0x99, 0xff, 0x00, 0x92, 0xff, 0x00, 0x8c, 0xff,  // 232 (0xe8)
	0x00, 0x85, 0xff, 0x00, 0x7f, 0xff, 0x00, 0x79, 0xff, 0x00, 0x72, 0xff,  // 236 (0xec)
	0xf0, 0xf0, 0xf0, 0xe0, 0xe0, 0xe0, 0xd0, 0xd0, 0xd0, 0xc0, 0xc0, 0xc0,  // 240 (0xf0)
	0xb0, 0xb0, 0xb0, 0xa0, 0xa0, 0xa0, 0x90, 0x90, 0x90, 0x80, 0x80, 0x80,  // 244 (0xf4)
	0x70, 0x70, 0x70, 0x60, 0x60, 0x60, 0x50, 0x50, 0x50, 0x40, 0x40, 0x40,  // 248 (0xf8)
	0x30, 0x30, 0x30, 0x20, 0x20, 0x20, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,  // 252 (0xfc)
};

static byte grayscalePalette[768] = {
	0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfe, 0xfd, 0xfd, 0xfd, 0xfc, 0xfc, 0xfc,  //   0 (0x00)
	0xfb, 0xfb, 0xfb, 0xfa, 0xfa, 0xfa, 0xf9, 0xf9, 0xf9, 0xf8, 0xf8, 0xf8,  //   4 (0x04)
	0xf7, 0xf7, 0xf7, 0xf6, 0xf6, 0xf6, 0xf5, 0xf5, 0xf5, 0xf4, 0xf4, 0xf4,  //   8 (0x08)
	0xf3, 0xf3, 0xf3, 0xf2, 0xf2, 0xf2, 0xf1, 0xf1, 0xf1, 0xf0, 0xf0, 0xf0,  //  12 (0x0c)
	0xef, 0xef, 0xef, 0xee, 0xee, 0xee, 0xed, 0xed, 0xed, 0xec, 0xec, 0xec,  //  16 (0x10)
	0xeb, 0xeb, 0xeb, 0xea, 0xea, 0xea, 0xe9, 0xe9, 0xe9, 0xe8, 0xe8, 0xe8,  //  20 (0x14)
	0xe7, 0xe7, 0xe7, 0xe6, 0xe6, 0xe6, 0xe5, 0xe5, 0xe5, 0xe4, 0xe4, 0xe4,  //  24 (0x18)
	0xe3, 0xe3, 0xe3, 0xe2, 0xe2, 0xe2, 0xe1, 0xe1, 0xe1, 0xe0, 0xe0, 0xe0,  //  28 (0x1c)
	0xdf, 0xdf, 0xdf, 0xde, 0xde, 0xde, 0xdd, 0xdd, 0xdd, 0xdc, 0xdc, 0xdc,  //  32 (0x20)
	0xdb, 0xdb, 0xdb, 0xda, 0xda, 0xda, 0xd9, 0xd9, 0xd9, 0xd8, 0xd8, 0xd8,  //  36 (0x24)
	0xd7, 0xd7, 0xd7, 0xd6, 0xd6, 0xd6, 0xd5, 0xd5, 0xd5, 0xd4, 0xd4, 0xd4,  //  40 (0x28)
	0xd3, 0xd3, 0xd3, 0xd2, 0xd2, 0xd2, 0xd1, 0xd1, 0xd1, 0xd0, 0xd0, 0xd0,  //  44 (0x2c)
	0xcf, 0xcf, 0xcf, 0xce, 0xce, 0xce, 0xcd, 0xcd, 0xcd, 0xcc, 0xcc, 0xcc,  //  48 (0x30)
	0xcb, 0xcb, 0xcb, 0xca, 0xca, 0xca, 0xc9, 0xc9, 0xc9, 0xc8, 0xc8, 0xc8,  //  52 (0x34)
	0xc7, 0xc7, 0xc7, 0xc6, 0xc6, 0xc6, 0xc5, 0xc5, 0xc5, 0xc4, 0xc4, 0xc4,  //  56 (0x38)
	0xc3, 0xc3, 0xc3, 0xc2, 0xc2, 0xc2, 0xc1, 0xc1, 0xc1, 0xc0, 0xc0, 0xc0,  //  60 (0x3c)
	0xbf, 0xbf, 0xbf, 0xbe, 0xbe, 0xbe, 0xbd, 0xbd, 0xbd, 0xbc, 0xbc, 0xbc,  //  64 (0x40)
	0xbb, 0xbb, 0xbb, 0xba, 0xba, 0xba, 0xb9, 0xb9, 0xb9, 0xb8, 0xb8, 0xb8,  //  68 (0x44)
	0xb7, 0xb7, 0xb7, 0xb6, 0xb6, 0xb6, 0xb5, 0xb5, 0xb5, 0xb4, 0xb4, 0xb4,  //  72 (0x48)
	0xb3, 0xb3, 0xb3, 0xb2, 0xb2, 0xb2, 0xb1, 0xb1, 0xb1, 0xb0, 0xb0, 0xb0,  //  76 (0x4c)
	0xaf, 0xaf, 0xaf, 0xae, 0xae, 0xae, 0xad, 0xad, 0xad, 0xac, 0xac, 0xac,  //  80 (0x50)
	0xab, 0xab, 0xab, 0xaa, 0xaa, 0xaa, 0xa9, 0xa9, 0xa9, 0xa8, 0xa8, 0xa8,  //  84 (0x54)
	0xa7, 0xa7, 0xa7, 0xa6, 0xa6, 0xa6, 0xa5, 0xa5, 0xa5, 0xa4, 0xa4, 0xa4,  //  88 (0x58)
	0xa3, 0xa3, 0xa3, 0xa2, 0xa2, 0xa2, 0xa1, 0xa1, 0xa1, 0xa0, 0xa0, 0xa0,  //  92 (0x5c)
	0x9f, 0x9f, 0x9f, 0x9e, 0x9e, 0x9e, 0x9d, 0x9d, 0x9d, 0x9c, 0x9c, 0x9c,  //  96 (0x60)
	0x9b, 0x9b, 0x9b, 0x9a, 0x9a, 0x9a, 0x99, 0x99, 0x99, 0x98, 0x98, 0x98,  // 100 (0x64)
	0x97, 0x97, 0x97, 0x96, 0x96, 0x96, 0x95, 0x95, 0x95, 0x94, 0x94, 0x94,  // 104 (0x68)
	0x93, 0x93, 0x93, 0x92, 0x92, 0x92, 0x91, 0x91, 0x91, 0x90, 0x90, 0x90,  // 108 (0x6c)
	0x8f, 0x8f, 0x8f, 0x8e, 0x8e, 0x8e, 0x8d, 0x8d, 0x8d, 0x8c, 0x8c, 0x8c,  // 112 (0x70)
	0x8b, 0x8b, 0x8b, 0x8a, 0x8a, 0x8a, 0x89, 0x89, 0x89, 0x88, 0x88, 0x88,  // 116 (0x74)
	0x87, 0x87, 0x87, 0x86, 0x86, 0x86, 0x85, 0x85, 0x85, 0x84, 0x84, 0x84,  // 120 (0x78)
	0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80,  // 124 (0x7c)
	0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7c, 0x7c, 0x7c,  // 128 (0x80)
	0x7b, 0x7b, 0x7b, 0x7a, 0x7a, 0x7a, 0x79, 0x79, 0x79, 0x78, 0x78, 0x78,  // 132 (0x84)
	0x77, 0x77, 0x77, 0x76, 0x76, 0x76, 0x75, 0x75, 0x75, 0x74, 0x74, 0x74,  // 136 (0x88)
	0x73, 0x73, 0x73, 0x72, 0x72, 0x72, 0x71, 0x71, 0x71, 0x70, 0x70, 0x70,  // 140 (0x8c)
	0x6f, 0x6f, 0x6f, 0x6e, 0x6e, 0x6e, 0x6d, 0x6d, 0x6d, 0x6c, 0x6c, 0x6c,  // 144 (0x90)
	0x6b, 0x6b, 0x6b, 0x6a, 0x6a, 0x6a, 0x69, 0x69, 0x69, 0x68, 0x68, 0x68,  // 148 (0x94)
	0x67, 0x67, 0x67, 0x66, 0x66, 0x66, 0x65, 0x65, 0x65, 0x64, 0x64, 0x64,  // 152 (0x98)
	0x63, 0x63, 0x63, 0x62, 0x62, 0x62, 0x61, 0x61, 0x61, 0x60, 0x60, 0x60,  // 156 (0x9c)
	0x5f, 0x5f, 0x5f, 0x5e, 0x5e, 0x5e, 0x5d, 0x5d, 0x5d, 0x5c, 0x5c, 0x5c,  // 160 (0xa0)
	0x5b, 0x5b, 0x5b, 0x5a, 0x5a, 0x5a, 0x59, 0x59, 0x59, 0x58, 0x58, 0x58,  // 164 (0xa4)
	0x57, 0x57, 0x57, 0x56, 0x56, 0x56, 0x55, 0x55, 0x55, 0x54, 0x54, 0x54,  // 168 (0xa8)
	0x53, 0x53, 0x53, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0x50, 0x50, 0x50,  // 172 (0xac)
	0x4f, 0x4f, 0x4f, 0x4e, 0x4e, 0x4e, 0x4d, 0x4d, 0x4d, 0x4c, 0x4c, 0x4c,  // 176 (0xb0)
	0x4b, 0x4b, 0x4b, 0x4a, 0x4a, 0x4a, 0x49, 0x49, 0x49, 0x48, 0x48, 0x48,  // 180 (0xb4)
	0x47, 0x47, 0x47, 0x46, 0x46, 0x46, 0x45, 0x45, 0x45, 0x44, 0x44, 0x44,  // 184 (0xb8)
	0x43, 0x43, 0x43, 0x42, 0x42, 0x42, 0x41, 0x41, 0x41, 0x40, 0x40, 0x40,  // 188 (0xbc)
	0x3f, 0x3f, 0x3f, 0x3e, 0x3e, 0x3e, 0x3d, 0x3d, 0x3d, 0x3c, 0x3c, 0x3c,  // 192 (0xc0)
	0x3b, 0x3b, 0x3b, 0x3a, 0x3a, 0x3a, 0x39, 0x39, 0x39, 0x38, 0x38, 0x38,  // 196 (0xc4)
	0x37, 0x37, 0x37, 0x36, 0x36, 0x36, 0x35, 0x35, 0x35, 0x34, 0x34, 0x34,  // 200 (0xc8)
	0x33, 0x33, 0x33, 0x32, 0x32, 0x32, 0x31, 0x31, 0x31, 0x30, 0x30, 0x30,  // 204 (0xcc)
	0x2f, 0x2f, 0x2f, 0x2e, 0x2e, 0x2e, 0x2d, 0x2d, 0x2d, 0x2c, 0x2c, 0x2c,  // 208 (0xd0)
	0x2b, 0x2b, 0x2b, 0x2a, 0x2a, 0x2a, 0x29, 0x29, 0x29, 0x28, 0x28, 0x28,  // 212 (0xd4)
	0x27, 0x27, 0x27, 0x26, 0x26, 0x26, 0x25, 0x25, 0x25, 0x24, 0x24, 0x24,  // 216 (0xd8)
	0x23, 0x23, 0x23, 0x22, 0x22, 0x22, 0x21, 0x21, 0x21, 0x20, 0x20, 0x20,  // 220 (0xdc)
	0x1f, 0x1f, 0x1f, 0x1e, 0x1e, 0x1e, 0x1d, 0x1d, 0x1d, 0x1c, 0x1c, 0x1c,  // 224 (0xe0)
	0x1b, 0x1b, 0x1b, 0x1a, 0x1a, 0x1a, 0x19, 0x19, 0x19, 0x18, 0x18, 0x18,  // 228 (0xe4)
	0x17, 0x17, 0x17, 0x16, 0x16, 0x16, 0x15, 0x15, 0x15, 0x14, 0x14, 0x14,  // 232 (0xe8)
	0x13, 0x13, 0x13, 0x12, 0x12, 0x12, 0x11, 0x11, 0x11, 0x10, 0x10, 0x10,  // 236 (0xec)
	0x0f, 0x0f, 0x0f, 0x0e, 0x0e, 0x0e, 0x0d, 0x0d, 0x0d, 0x0c, 0x0c, 0x0c,  // 240 (0xf0)
	0x0b, 0x0b, 0x0b, 0x0a, 0x0a, 0x0a, 0x09, 0x09, 0x09, 0x08, 0x08, 0x08,  // 244 (0xf4)
	0x07, 0x07, 0x07, 0x06, 0x06, 0x06, 0x05, 0x05, 0x05, 0x04, 0x04, 0x04,  // 248 (0xf8)
	0x03, 0x03, 0x03, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,  // 252 (0xfc)
};

static byte pastelsPalette[768] = {
	0xff, 0xff, 0xff, 0xfe, 0xfe, 0xf2, 0xfe, 0xfd, 0xe6, 0xfe, 0xfd, 0xda,  //   0 (0x00)
	0xfe, 0xfc, 0xce, 0xfe, 0xfb, 0xc2, 0xfe, 0xfb, 0xb6, 0xfe, 0xfa, 0xaa,  //   4 (0x04)
	0xfd, 0xfa, 0x9d, 0xfd, 0xf9, 0x91, 0xfd, 0xf8, 0x85, 0xfd, 0xf8, 0x79,  //   8 (0x08)
	0xfd, 0xf7, 0x6d, 0xfd, 0xf7, 0x61, 0xfd, 0xf6, 0x55, 0xfc, 0xf5, 0x48,  //  12 (0x0c)
	0xfc, 0xee, 0x47, 0xfc, 0xe7, 0x47, 0xfc, 0xe0, 0x47, 0xfc, 0xd9, 0x47,  //  16 (0x10)
	0xfd, 0xd2, 0x47, 0xfd, 0xcb, 0x47, 0xfd, 0xc4, 0x47, 0xfd, 0xbe, 0x47,  //  20 (0x14)
	0xfd, 0xb7, 0x47, 0xfe, 0xb0, 0x47, 0xfe, 0xa9, 0x47, 0xfe, 0xa2, 0x47,  //  24 (0x18)
	0xfe, 0x9b, 0x47, 0xfe, 0x94, 0x47, 0xff, 0x8d, 0x46, 0xfd, 0x88, 0x46,  //  28 (0x1c)
	0xfb, 0x84, 0x46, 0xf9, 0x7f, 0x46, 0xf8, 0x7b, 0x47, 0xf6, 0x77, 0x47,  //  32 (0x20)
	0xf4, 0x72, 0x47, 0xf3, 0x6e, 0x47, 0xf1, 0x6a, 0x48, 0xef, 0x65, 0x48,  //  36 (0x24)
	0xee, 0x61, 0x48, 0xec, 0x5d, 0x48, 0xea, 0x58, 0x49, 0xe9, 0x54, 0x49,  //  40 (0x28)
	0xe7, 0x50, 0x49, 0xe5, 0x4b, 0x4a, 0xe2, 0x49, 0x49, 0xdf, 0x47, 0x48,  //  44 (0x2c)
	0xdc, 0x45, 0x48, 0xd9, 0x43, 0x47, 0xd6, 0x41, 0x47, 0xd4, 0x3f, 0x46,  //  48 (0x30)
	0xd1, 0x3d, 0x46, 0xce, 0x3b, 0x45, 0xcb, 0x39, 0x45, 0xc8, 0x37, 0x44,  //  52 (0x34)
	0xc6, 0x35, 0x44, 0xc3, 0x33, 0x43, 0xc0, 0x31, 0x43, 0xbd, 0x2f, 0x42,  //  56 (0x38)
	0xba, 0x2d, 0x41, 0xbe, 0x2f, 0x47, 0xc2, 0x31, 0x4e, 0xc6, 0x33, 0x55,  //  60 (0x3c)
	0xca, 0x35, 0x5b, 0xce, 0x37, 0x62, 0xd2, 0x39, 0x69, 0xd6, 0x3b, 0x70,  //  64 (0x40)
	0xda, 0x3d, 0x76, 0xde, 0x3f, 0x7d, 0xe2, 0x41, 0x84, 0xe6, 0x43, 0x8b,  //  68 (0x44)
	0xea, 0x45, 0x91, 0xee, 0x47, 0x98, 0xf2, 0x49, 0x9f, 0xf6, 0x4b, 0xa6,  //  72 (0x48)
	0xed, 0x4a, 0xa7, 0xe5, 0x4a, 0xa9, 0xdc, 0x49, 0xaa, 0xd4, 0x49, 0xac,  //  76 (0x4c)
	0xcc, 0x48, 0xad, 0xc3, 0x48, 0xaf, 0xbb, 0x48, 0xb0, 0xb3, 0x47, 0xb2,  //  80 (0x50)
	0xaa, 0x47, 0xb3, 0xa2, 0x46, 0xb5, 0x9a, 0x46, 0xb6, 0x91, 0x46, 0xb8,  //  84 (0x54)
	0x89, 0x45, 0xb9, 0x81, 0x45, 0xbb, 0x78, 0x44, 0xbd, 0x74, 0x44, 0xbf,  //  88 (0x58)
	0x71, 0x44, 0xc1, 0x6d, 0x44, 0xc4, 0x6a, 0x44, 0xc6, 0x66, 0x44, 0xc8,  //  92 (0x5c)
	0x63, 0x44, 0xcb, 0x60, 0x44, 0xcd, 0x5c, 0x44, 0xcf, 0x59, 0x44, 0xd2,  //  96 (0x60)
	0x55, 0x44, 0xd4, 0x52, 0x44, 0xd6, 0x4f, 0x44, 0xd9, 0x4b, 0x44, 0xdb,  // 100 (0x64)
	0x48, 0x44, 0xdd, 0x44, 0x45, 0xe0, 0x44, 0x4d, 0xe1, 0x44, 0x55, 0xe2,  // 104 (0x68)
	0x44, 0x5e, 0xe3, 0x44, 0x66, 0xe4, 0x45, 0x6e, 0xe5, 0x45, 0x77, 0xe6,  // 108 (0x6c)
	0x45, 0x7f, 0xe7, 0x45, 0x87, 0xe8, 0x45, 0x90, 0xe9, 0x46, 0x98, 0xea,  // 112 (0x70)
	0x46, 0xa0, 0xeb, 0x46, 0xa9, 0xec, 0x46, 0xb1, 0xed, 0x46, 0xb9, 0xee,  // 116 (0x74)
	0x47, 0xc2, 0xf0, 0x48, 0xc2, 0xe5, 0x49, 0xc3, 0xdb, 0x4b, 0xc3, 0xd0,  // 120 (0x78)
	0x4c, 0xc4, 0xc6, 0x4e, 0xc5, 0xbb, 0x4f, 0xc5, 0xb1, 0x50, 0xc6, 0xa7,  // 124 (0x7c)
	0x52, 0xc6, 0x9c, 0x53, 0xc7, 0x92, 0x55, 0xc8, 0x87, 0x56, 0xc8, 0x7d,  // 128 (0x80)
	0x57, 0xc9, 0x73, 0x59, 0xc9, 0x68, 0x5a, 0xca, 0x5e, 0x5c, 0xcb, 0x53,  // 132 (0x84)
	0x5a, 0xc7, 0x52, 0x58, 0xc3, 0x52, 0x57, 0xbf, 0x52, 0x55, 0xbb, 0x52,  // 136 (0x88)
	0x54, 0xb7, 0x52, 0x52, 0xb3, 0x52, 0x51, 0xaf, 0x52, 0x4f, 0xab, 0x52,  // 140 (0x8c)
	0x4e, 0xa7, 0x52, 0x4c, 0xa3, 0x52, 0x4b, 0x9f, 0x52, 0x49, 0x9b, 0x52,  // 144 (0x90)
	0x48, 0x97, 0x52, 0x46, 0x93, 0x52, 0x44, 0x8f, 0x51, 0x48, 0x8c, 0x50,  // 148 (0x94)
	0x4c, 0x89, 0x4f, 0x50, 0x86, 0x4f, 0x55, 0x84, 0x4e, 0x59, 0x81, 0x4e,  // 152 (0x98)
	0x5d, 0x7e, 0x4d, 0x61, 0x7b, 0x4d, 0x66, 0x79, 0x4c, 0x6a, 0x76, 0x4c,  // 156 (0x9c)
	0x6e, 0x73, 0x4b, 0x72, 0x70, 0x4b, 0x77, 0x6e, 0x4a, 0x7b, 0x6b, 0x4a,  // 160 (0xa0)
	0x7f, 0x68, 0x49, 0x84, 0x65, 0x48, 0x8c, 0x6e, 0x48, 0x94, 0x78, 0x48,  // 164 (0xa4)
	0x9c, 0x82, 0x48, 0xa4, 0x8b, 0x48, 0xac, 0x95, 0x48, 0xb4, 0x9f, 0x48,  // 168 (0xa8)
	0xbc, 0xa8, 0x48, 0xc4, 0xb2, 0x48, 0xcc, 0xbc, 0x48, 0xd4, 0xc5, 0x48,  // 172 (0xac)
	0xdc, 0xcf, 0x48, 0xe4, 0xd9, 0x48, 0xec, 0xe2, 0x48, 0xf4, 0xec, 0x48,  // 176 (0xb0)
	0xfd, 0xf6, 0x49, 0xfb, 0xea, 0x49, 0xf9, 0xdf, 0x49, 0xf8, 0xd3, 0x49,  // 180 (0xb4)
	0xf6, 0xc8, 0x49, 0xf5, 0xbd, 0x49, 0xf3, 0xb1, 0x49, 0xf2, 0xa6, 0x49,  // 184 (0xb8)
	0xf0, 0x9b, 0x49, 0xef, 0x8f, 0x49, 0xed, 0x84, 0x49, 0xec, 0x79, 0x49,  // 188 (0xbc)
	0xea, 0x6d, 0x49, 0xe9, 0x62, 0x49, 0xe7, 0x57, 0x49, 0xe5, 0x4b, 0x4a,  // 192 (0xc0)
	0xe6, 0x4b, 0x50, 0xe7, 0x4b, 0x56, 0xe8, 0x4b, 0x5c, 0xe9, 0x4b, 0x62,  // 196 (0xc4)
	0xea, 0x4b, 0x68, 0xeb, 0x4b, 0x6e, 0xec, 0x4b, 0x74, 0xee, 0x4b, 0x7b,  // 200 (0xc8)
	0xef, 0x4b, 0x81, 0xf0, 0x4b, 0x87, 0xf1, 0x4b, 0x8d, 0xf2, 0x4b, 0x93,  // 204 (0xcc)
	0xf3, 0x4b, 0x99, 0xf4, 0x4b, 0x9f, 0xf6, 0x4b, 0xa6, 0xea, 0x4a, 0xa9,  // 208 (0xd0)
	0xde, 0x4a, 0xad, 0xd2, 0x49, 0xb1, 0xc6, 0x49, 0xb5, 0xba, 0x48, 0xb9,  // 212 (0xd4)
	0xaf, 0x48, 0xbd, 0xa3, 0x48, 0xc1, 0x97, 0x47, 0xc4, 0x8b, 0x47, 0xc8,  // 216 (0xd8)
	0x7f, 0x46, 0xcc, 0x74, 0x46, 0xd0, 0x68, 0x46, 0xd4, 0x5c, 0x45, 0xd8,  // 220 (0xdc)
	0x50, 0x45, 0xdc, 0x44, 0x44, 0xe0, 0x4f, 0x4f, 0xe1, 0x5a, 0x5a, 0xe2,  // 224 (0xe0)
	0x66, 0x66, 0xe3, 0x71, 0x71, 0xe4, 0x7d, 0x7d, 0xe5, 0x88, 0x88, 0xe6,  // 228 (0xe4)
	0x94, 0x94, 0xe7, 0x9f, 0x9f, 0xe8, 0xab, 0xab, 0xe9, 0xb6, 0xb6, 0xea,  // 232 (0xe8)
	0xc2, 0xc2, 0xeb, 0xcd, 0xcd, 0xec, 0xd9, 0xd9, 0xed, 0xe4, 0xe4, 0xee,  // 236 (0xec)
	0xf0, 0xf0, 0xf0, 0xe0, 0xe0, 0xe0, 0xd0, 0xd0, 0xd0, 0xc0, 0xc0, 0xc0,  // 240 (0xf0)
	0xb0, 0xb0, 0xb0, 0xa0, 0xa0, 0xa0, 0x90, 0x90, 0x90, 0x80, 0x80, 0x80,  // 244 (0xf4)
	0x70, 0x70, 0x70, 0x60, 0x60, 0x60, 0x50, 0x50, 0x50, 0x40, 0x40, 0x40,  // 248 (0xf8)
	0x30, 0x30, 0x30, 0x20, 0x20, 0x20, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,  // 252 (0xfc)
};

static byte vividPalette[768] = {
	0xff, 0xff, 0xff, 0xfe, 0xfe, 0xee, 0xfe, 0xfd, 0xdd, 0xfe, 0xfc, 0xcc,  //   0 (0x00)
	0xfe, 0xfb, 0xbc, 0xfd, 0xfa, 0xab, 0xfd, 0xfa, 0x9a, 0xfd, 0xf9, 0x8a,  //   4 (0x04)
	0xfd, 0xf8, 0x79, 0xfd, 0xf7, 0x68, 0xfc, 0xf6, 0x58, 0xfc, 0xf6, 0x47,  //   8 (0x08)
	0xfc, 0xf5, 0x36, 0xfc, 0xf4, 0x26, 0xfc, 0xf3, 0x15, 0xfb, 0xf2, 0x04,  //  12 (0x0c)
	0xfb, 0xe8, 0x03, 0xfb, 0xdf, 0x03, 0xfb, 0xd5, 0x03, 0xfc, 0xcc, 0x03,  //  16 (0x10)
	0xfc, 0xc2, 0x03, 0xfc, 0xb9, 0x03, 0xfc, 0xaf, 0x03, 0xfd, 0xa6, 0x02,  //  20 (0x14)
	0xfd, 0x9c, 0x02, 0xfd, 0x93, 0x02, 0xfd, 0x89, 0x02, 0xfe, 0x80, 0x02,  //  24 (0x18)
	0xfe, 0x76, 0x02, 0xfe, 0x6d, 0x02, 0xff, 0x63, 0x01, 0xfc, 0x5c, 0x01,  //  28 (0x1c)
	0xfa, 0x56, 0x01, 0xf8, 0x50, 0x02, 0xf5, 0x4a, 0x02, 0xf3, 0x44, 0x02,  //  32 (0x20)
	0xf1, 0x3e, 0x03, 0xef, 0x38, 0x03, 0xec, 0x32, 0x03, 0xea, 0x2c, 0x04,  //  36 (0x24)
	0xe8, 0x26, 0x04, 0xe6, 0x20, 0x04, 0xe3, 0x1a, 0x05, 0xe1, 0x14, 0x05,  //  40 (0x28)
	0xdf, 0x0e, 0x05, 0xdc, 0x07, 0x06, 0xd8, 0x06, 0x07, 0xd5, 0x06, 0x08,  //  44 (0x2c)
	0xd2, 0x05, 0x09, 0xce, 0x05, 0x0a, 0xcb, 0x04, 0x0c, 0xc8, 0x04, 0x0d,  //  48 (0x30)
	0xc5, 0x03, 0x0e, 0xc1, 0x03, 0x0f, 0xbe, 0x02, 0x10, 0xbb, 0x02, 0x12,  //  52 (0x34)
	0xb8, 0x01, 0x13, 0xb4, 0x01, 0x14, 0xb1, 0x00, 0x15, 0xae, 0x00, 0x16,  //  56 (0x38)
	0xaa, 0x00, 0x18, 0xae, 0x00, 0x1f, 0xb3, 0x01, 0x26, 0xb8, 0x01, 0x2d,  //  60 (0x3c)
	0xbd, 0x02, 0x34, 0xc2, 0x02, 0x3c, 0xc6, 0x03, 0x43, 0xcb, 0x03, 0x4a,  //  64 (0x40)
	0xd0, 0x04, 0x51, 0xd5, 0x04, 0x58, 0xda, 0x05, 0x60, 0xde, 0x05, 0x67,  //  68 (0x44)
	0xe3, 0x06, 0x6e, 0xe8, 0x06, 0x75, 0xed, 0x07, 0x7c, 0xf2, 0x08, 0x84,  //  72 (0x48)
	0xe6, 0x07, 0x86, 0xdb, 0x06, 0x88, 0xcf, 0x06, 0x8a, 0xc4, 0x05, 0x8c,  //  76 (0x4c)
	0xb8, 0x05, 0x8f, 0xad, 0x04, 0x91, 0xa1, 0x04, 0x93, 0x96, 0x03, 0x95,  //  80 (0x50)
	0x8a, 0x03, 0x97, 0x7f, 0x02, 0x9a, 0x73, 0x02, 0x9c, 0x68, 0x01, 0x9e,  //  84 (0x54)
	0x5c, 0x01, 0xa0, 0x51, 0x00, 0xa2, 0x45, 0x00, 0xa5, 0x40, 0x00, 0xa8,  //  88 (0x58)
	0x3b, 0x00, 0xab, 0x37, 0x00, 0xae, 0x32, 0x00, 0xb1, 0x2d, 0x00, 0xb4,  //  92 (0x5c)
	0x29, 0x00, 0xb7, 0x24, 0x00, 0xba, 0x20, 0x00, 0xbe, 0x1b, 0x00, 0xc1,  //  96 (0x60)
	0x16, 0x00, 0xc4, 0x12, 0x00, 0xc7, 0x0d, 0x00, 0xca, 0x09, 0x00, 0xcd,  // 100 (0x64)
	0x04, 0x00, 0xd0, 0x00, 0x00, 0xd4, 0x00, 0x0b, 0xd5, 0x00, 0x16, 0xd6,  // 104 (0x68)
	0x00, 0x22, 0xd8, 0x00, 0x2d, 0xd9, 0x00, 0x39, 0xdb, 0x00, 0x44, 0xdc,  // 108 (0x6c)
	0x00, 0x4f, 0xde, 0x01, 0x5b, 0xdf, 0x01, 0x66, 0xe1, 0x01, 0x72, 0xe2,  // 112 (0x70)
	0x01, 0x7d, 0xe4, 0x01, 0x88, 0xe5, 0x01, 0x94, 0xe7, 0x01, 0x9f, 0xe8,  // 116 (0x74)
	0x02, 0xab, 0xea, 0x03, 0xab, 0xdb, 0x05, 0xac, 0xcd, 0x07, 0xad, 0xbf,  // 120 (0x78)
	0x09, 0xae, 0xb0, 0x0b, 0xaf, 0xa2, 0x0d, 0xaf, 0x94, 0x0f, 0xb0, 0x86,  // 124 (0x7c)
	0x11, 0xb1, 0x77, 0x13, 0xb2, 0x69, 0x15, 0xb3, 0x5b, 0x17, 0xb3, 0x4d,  // 128 (0x80)
	0x19, 0xb4, 0x3e, 0x1b, 0xb5, 0x30, 0x1d, 0xb6, 0x22, 0x1f, 0xb7, 0x13,  // 132 (0x84)
	0x1c, 0xb1, 0x12, 0x1a, 0xab, 0x12, 0x18, 0xa6, 0x12, 0x16, 0xa0, 0x12,  // 136 (0x88)
	0x14, 0x9b, 0x12, 0x12, 0x95, 0x12, 0x10, 0x90, 0x12, 0x0e, 0x8a, 0x11,  // 140 (0x8c)
	0x0c, 0x85, 0x11, 0x0a, 0x7f, 0x11, 0x08, 0x7a, 0x11, 0x06, 0x74, 0x11,  // 144 (0x90)
	0x04, 0x6f, 0x11, 0x02, 0x69, 0x11, 0x00, 0x63, 0x10, 0x05, 0x5f, 0x0f,  // 148 (0x94)
	0x0b, 0x5b, 0x0e, 0x11, 0x57, 0x0d, 0x16, 0x54, 0x0d, 0x1c, 0x50, 0x0c,  // 152 (0x98)
	0x22, 0x4c, 0x0b, 0x28, 0x49, 0x0a, 0x2d, 0x45, 0x0a, 0x33, 0x41, 0x09,  // 156 (0x9c)
	0x39, 0x3e, 0x08, 0x3f, 0x3a, 0x07, 0x44, 0x36, 0x07, 0x4a, 0x33, 0x06,  // 160 (0xa0)
	0x50, 0x2f, 0x05, 0x56, 0x2b, 0x04, 0x61, 0x38, 0x04, 0x6c, 0x45, 0x04,  // 164 (0xa4)
	0x77, 0x53, 0x04, 0x82, 0x60, 0x04, 0x8d, 0x6d, 0x04, 0x98, 0x7b, 0x04,  // 168 (0xa8)
	0xa3, 0x88, 0x04, 0xae, 0x95, 0x04, 0xb9, 0xa3, 0x04, 0xc4, 0xb0, 0x04,  // 172 (0xac)
	0xcf, 0xbd, 0x04, 0xda, 0xcb, 0x04, 0xe5, 0xd8, 0x04, 0xf0, 0xe5, 0x04,  // 176 (0xb0)
	0xfc, 0xf3, 0x05, 0xf9, 0xe3, 0x05, 0xf7, 0xd3, 0x05, 0xf5, 0xc3, 0x05,  // 180 (0xb4)
	0xf3, 0xb4, 0x05, 0xf1, 0xa4, 0x05, 0xef, 0x94, 0x05, 0xed, 0x85, 0x05,  // 184 (0xb8)
	0xeb, 0x75, 0x05, 0xe9, 0x65, 0x05, 0xe7, 0x56, 0x05, 0xe5, 0x46, 0x05,  // 188 (0xbc)
	0xe3, 0x36, 0x05, 0xe1, 0x27, 0x05, 0xdf, 0x17, 0x05, 0xdc, 0x07, 0x06,  // 192 (0xc0)
	0xdd, 0x07, 0x0e, 0xde, 0x07, 0x16, 0xe0, 0x07, 0x1f, 0xe1, 0x07, 0x27,  // 196 (0xc4)
	0xe3, 0x07, 0x30, 0xe4, 0x07, 0x38, 0xe6, 0x07, 0x40, 0xe7, 0x07, 0x49,  // 200 (0xc8)
	0xe9, 0x07, 0x51, 0xea, 0x07, 0x5a, 0xec, 0x07, 0x62, 0xed, 0x07, 0x6a,  // 204 (0xcc)
	0xef, 0x07, 0x73, 0xf0, 0x07, 0x7b, 0xf2, 0x08, 0x84, 0xe1, 0x07, 0x89,  // 208 (0xd0)
	0xd1, 0x06, 0x8e, 0xc1, 0x06, 0x94, 0xb1, 0x05, 0x99, 0xa1, 0x05, 0x9e,  // 212 (0xd4)
	0x91, 0x04, 0xa4, 0x81, 0x04, 0xa9, 0x70, 0x03, 0xae, 0x60, 0x03, 0xb4,  // 216 (0xd8)
	0x50, 0x02, 0xb9, 0x40, 0x02, 0xbe, 0x30, 0x01, 0xc4, 0x20, 0x01, 0xc9,  // 220 (0xdc)
	0x10, 0x00, 0xce, 0x00, 0x00, 0xd4, 0x10, 0x10, 0xd5, 0x20, 0x20, 0xd7,  // 224 (0xe0)
	0x30, 0x30, 0xd9, 0x40, 0x40, 0xdb, 0x50, 0x50, 0xdd, 0x60, 0x60, 0xdf,  // 228 (0xe4)
	0x70, 0x70, 0xe1, 0x80, 0x80, 0xe2, 0x90, 0x90, 0xe4, 0xa0, 0xa0, 0xe6,  // 232 (0xe8)
	0xb0, 0xb0, 0xe8, 0xc0, 0xc0, 0xea, 0xd0, 0xd0, 0xec, 0xe0, 0xe0, 0xee,  // 236 (0xec)
	0xf0, 0xf0, 0xf0, 0xe0, 0xe0, 0xe0, 0xd0, 0xd0, 0xd0, 0xc0, 0xc0, 0xc0,  // 240 (0xf0)
	0xb0, 0xb0, 0xb0, 0xa0, 0xa0, 0xa0, 0x90, 0x90, 0x90, 0x80, 0x80, 0x80,  // 244 (0xf4)
	0x70, 0x70, 0x70, 0x60, 0x60, 0x60, 0x50, 0x50, 0x50, 0x40, 0x40, 0x40,  // 248 (0xf8)
	0x30, 0x30, 0x30, 0x20, 0x20, 0x20, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,  // 252 (0xfc)
};

static byte ntscPalette[768] = {
	0xff, 0xff, 0xff, 0x59, 0x2b, 0x85, 0x5d, 0x21, 0x5f, 0x7b, 0x28, 0x52,  //   0 (0x00)
	0x9a, 0x30, 0x44, 0xa1, 0x3d, 0x42, 0xa5, 0x43, 0x41, 0xa9, 0x47, 0x3e,  //   4 (0x04)
	0xac, 0x4b, 0x3a, 0xb0, 0x4f, 0x37, 0xb4, 0x53, 0x33, 0xba, 0x66, 0x35,  //   8 (0x08)
	0xc1, 0x7a, 0x36, 0xc8, 0x8d, 0x37, 0xcf, 0xa1, 0x39, 0xd5, 0xb5, 0x3a,  //  12 (0x0c)
	0xdc, 0xc9, 0x3b, 0xe3, 0xdd, 0x3c, 0xc6, 0xd4, 0x38, 0xac, 0xce, 0x37,  //  16 (0x10)
	0x93, 0xc8, 0x35, 0x79, 0xc3, 0x33, 0x60, 0xbd, 0x31, 0x46, 0xb7, 0x2f,  //  20 (0x14)
	0x2d, 0xb1, 0x2d, 0x27, 0x9a, 0x3c, 0x21, 0x83, 0x49, 0x1b, 0x6c, 0x55,  //  24 (0x18)
	0x19, 0x5b, 0x65, 0x21, 0x58, 0x84, 0x29, 0x52, 0xa3, 0x30, 0x4b, 0xc2,  //  28 (0x1c)
	0x1c, 0xc2, 0xd5, 0x26, 0xc3, 0xd5, 0x30, 0xc4, 0xd5, 0x3b, 0xc5, 0xd5,  //  32 (0x20)
	0x45, 0xc6, 0xd5, 0x4f, 0xc7, 0xd5, 0x59, 0xc8, 0xd5, 0x63, 0xc9, 0xd5,  //  36 (0x24)
	0x6d, 0xca, 0xd5, 0x77, 0xcb, 0xd5, 0x81, 0xcc, 0xd5, 0x8b, 0xcd, 0xd5,  //  40 (0x28)
	0x95, 0xce, 0xd5, 0x9f, 0xcf, 0xd5, 0xa9, 0xd0, 0xd5, 0xb3, 0xd1, 0xd5,  //  44 (0x2c)
	0xb1, 0xf2, 0xb9, 0xa5, 0xf0, 0xad, 0x9a, 0xef, 0xa1, 0x8e, 0xed, 0x94,  //  48 (0x30)
	0x82, 0xec, 0x88, 0x76, 0xea, 0x7c, 0x6b, 0xe8, 0x70, 0x5f, 0xe7, 0x63,  //  52 (0x34)
	0x53, 0xe5, 0x57, 0x47, 0xe4, 0x4b, 0x3b, 0xe2, 0x3f, 0x30, 0xe0, 0x32,  //  56 (0x38)
	0x24, 0xdf, 0x26, 0x18, 0xdd, 0x1a, 0x0c, 0xdc, 0x0e, 0x01, 0xda, 0x01,  //  60 (0x3c)
	0x01, 0xc8, 0x01, 0x00, 0xbb, 0x01, 0x00, 0xae, 0x01, 0x00, 0xa0, 0x01,  //  64 (0x40)
	0x00, 0x93, 0x01, 0x00, 0x85, 0x01, 0x00, 0x78, 0x00, 0x00, 0x6b, 0x00,  //  68 (0x44)
	0x00, 0x5d, 0x00, 0x00, 0x50, 0x00, 0x00, 0x42, 0x00, 0x00, 0x35, 0x00,  //  72 (0x48)
	0x00, 0x28, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,  //  76 (0x4c)
	0x0a, 0x09, 0x00, 0x16, 0x15, 0x01, 0x22, 0x21, 0x02, 0x2e, 0x2d, 0x02,  //  80 (0x50)
	0x3a, 0x39, 0x03, 0x46, 0x44, 0x04, 0x52, 0x50, 0x05, 0x5e, 0x5c, 0x05,  //  84 (0x54)
	0x6a, 0x68, 0x06, 0x77, 0x74, 0x07, 0x83, 0x80, 0x08, 0x8f, 0x8b, 0x08,  //  88 (0x58)
	0x9b, 0x97, 0x09, 0xa7, 0xa3, 0x0a, 0xb3, 0xaf, 0x0b, 0xbf, 0xbb, 0x0b,  //  92 (0x5c)
	0xc5, 0xc0, 0x0c, 0xc8, 0xc4, 0x15, 0xcb, 0xc7, 0x1d, 0xcf, 0xca, 0x26,  //  96 (0x60)
	0xd2, 0xcd, 0x2f, 0xd5, 0xd0, 0x38, 0xd8, 0xd3, 0x41, 0xdb, 0xd6, 0x4a,  // 100 (0x64)
	0xdf, 0xd9, 0x52, 0xe2, 0xdc, 0x5b, 0xe5, 0xdf, 0x64, 0xe8, 0xe2, 0x6d,  // 104 (0x68)
	0xeb, 0xe5, 0x76, 0xef, 0xe8, 0x7f, 0xf2, 0xeb, 0x87, 0xf5, 0xee, 0x90,  // 108 (0x6c)
	0xd9, 0xaf, 0xa1, 0xd9, 0xa9, 0x98, 0xd9, 0xa2, 0x8f, 0xd9, 0x9c, 0x87,  // 112 (0x70)
	0xd9, 0x95, 0x7e, 0xd9, 0x8f, 0x76, 0xd9, 0x88, 0x6d, 0xd9, 0x82, 0x65,  // 116 (0x74)
	0xd9, 0x7b, 0x5c, 0xd9, 0x75, 0x53, 0xd9, 0x6e, 0x4b, 0xd9, 0x68, 0x42,  // 120 (0x78)
	0xd9, 0x61, 0x3a, 0xd9, 0x5b, 0x31, 0xd9, 0x54, 0x29, 0xd9, 0x4e, 0x20,  // 124 (0x7c)
	0xd9, 0x4a, 0x1b, 0xcb, 0x45, 0x19, 0xbc, 0x40, 0x17, 0xae, 0x3b, 0x16,  // 128 (0x80)
	0x9f, 0x36, 0x14, 0x91, 0x31, 0x12, 0x82, 0x2c, 0x10, 0x74, 0x27, 0x0e,  // 132 (0x84)
	0x65, 0x22, 0x0c, 0x57, 0x1d, 0x0b, 0x48, 0x18, 0x09, 0x3a, 0x13, 0x07,  // 136 (0x88)
	0x2b, 0x0e, 0x05, 0x1d, 0x09, 0x03, 0x0e, 0x05, 0x01, 0x00, 0x00, 0x00,  // 140 (0x8c)
	0x00, 0x00, 0x00, 0x0b, 0x00, 0x02, 0x17, 0x00, 0x04, 0x17, 0x03, 0x06,  // 144 (0x90)
	0x22, 0x04, 0x0a, 0x2e, 0x06, 0x0d, 0x39, 0x07, 0x10, 0x45, 0x09, 0x14,  // 148 (0x94)
	0x51, 0x0b, 0x17, 0x5c, 0x0c, 0x1a, 0x68, 0x0e, 0x1e, 0x73, 0x0f, 0x21,  // 152 (0x98)
	0x7f, 0x11, 0x25, 0x8b, 0x13, 0x28, 0x96, 0x14, 0x2b, 0xa2, 0x16, 0x2f,  // 156 (0x9c)
	0xa2, 0x16, 0x2f, 0xb1, 0x0b, 0x2a, 0xb5, 0x17, 0x35, 0xb9, 0x22, 0x3f,  // 160 (0xa0)
	0xbd, 0x2e, 0x4a, 0xc1, 0x39, 0x55, 0xc4, 0x45, 0x60, 0xc8, 0x50, 0x6b,  // 164 (0xa4)
	0xcc, 0x5c, 0x76, 0xd0, 0x67, 0x81, 0xd4, 0x73, 0x8c, 0xd7, 0x7e, 0x97,  // 168 (0xa8)
	0xdb, 0x8a, 0xa2, 0xdf, 0x95, 0xad, 0xe3, 0xa1, 0xb8, 0xe7, 0xad, 0xc3,  // 172 (0xac)
	0xc9, 0xaa, 0xf0, 0xc3, 0xa1, 0xef, 0xbe, 0x97, 0xed, 0xb9, 0x8d, 0xeb,  // 176 (0xb0)
	0xb3, 0x84, 0xe9, 0xae, 0x7a, 0xe8, 0xa8, 0x70, 0xe6, 0xa3, 0x67, 0xe4,  // 180 (0xb4)
	0x9e, 0x5d, 0xe3, 0x98, 0x53, 0xe1, 0x93, 0x4a, 0xdf, 0x8d, 0x40, 0xdd,  // 184 (0xb8)
	0x88, 0x36, 0xdc, 0x83, 0x2d, 0xda, 0x7d, 0x23, 0xd8, 0x78, 0x19, 0xd7,  // 188 (0xbc)
	0x75, 0x0f, 0xd7, 0x6d, 0x0e, 0xc9, 0x66, 0x0d, 0xbc, 0x5f, 0x0c, 0xae,  // 192 (0xc0)
	0x57, 0x0b, 0xa1, 0x50, 0x0a, 0x93, 0x49, 0x09, 0x86, 0x41, 0x08, 0x78,  // 196 (0xc4)
	0x3a, 0x07, 0x6b, 0x32, 0x06, 0x5d, 0x2b, 0x05, 0x50, 0x24, 0x04, 0x42,  // 200 (0xc8)
	0x1c, 0x03, 0x35, 0x15, 0x02, 0x27, 0x0e, 0x01, 0x1a, 0x06, 0x00, 0x0c,  // 204 (0xcc)
	0x00, 0x04, 0x16, 0x00, 0x06, 0x23, 0x00, 0x08, 0x30, 0x00, 0x0b, 0x3d,  // 208 (0xd0)
	0x00, 0x0d, 0x4a, 0x00, 0x10, 0x57, 0x00, 0x12, 0x64, 0x00, 0x14, 0x71,  // 212 (0xd4)
	0x00, 0x17, 0x7e, 0x00, 0x19, 0x8b, 0x00, 0x1c, 0x98, 0x00, 0x1e, 0xa5,  // 216 (0xd8)
	0x00, 0x20, 0xb2, 0x00, 0x23, 0xbf, 0x00, 0x25, 0xcc, 0x00, 0x27, 0xd9,  // 220 (0xdc)
	0x00, 0x29, 0xe3, 0x0f, 0x36, 0xe4, 0x1d, 0x42, 0xe5, 0x2c, 0x4f, 0xe6,  // 224 (0xe0)
	0x3b, 0x5b, 0xe6, 0x4a, 0x67, 0xe7, 0x59, 0x74, 0xe8, 0x68, 0x80, 0xe9,  // 228 (0xe4)
	0x77, 0x8c, 0xe9, 0x86, 0x99, 0xea, 0x95, 0xa5, 0xeb, 0xa4, 0xb2, 0xec,  // 232 (0xe8)
	0xb3, 0xbe, 0xec, 0xc2, 0xca, 0xed, 0xd1, 0xd7, 0xee, 0xe0, 0xe3, 0xef,  // 236 (0xec)
	0xf0, 0xf0, 0xf0, 0xe0, 0xe0, 0xe0, 0xd0, 0xd0, 0xd0, 0xc0, 0xc0, 0xc0,  // 240 (0xf0)
	0xb0, 0xb0, 0xb0, 0xa0, 0xa0, 0xa0, 0x90, 0x90, 0x90, 0x80, 0x80, 0x80,  // 244 (0xf4)
	0x70, 0x70, 0x70, 0x60, 0x60, 0x60, 0x50, 0x50, 0x50, 0x40, 0x40, 0x40,  // 248 (0xf8)
	0x30, 0x30, 0x30, 0x20, 0x20, 0x20, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,  // 252 (0xfc)
};

static byte metallicPalette[768] = {
	0xff, 0xff, 0xff, 0x66, 0x4c, 0x80, 0x5f, 0x42, 0x6c, 0x58, 0x37, 0x59,  //   0 (0x00)
	0x75, 0x47, 0x5e, 0x94, 0x58, 0x63, 0x9b, 0x66, 0x69, 0x9f, 0x6c, 0x6a,  //   4 (0x04)
	0xa3, 0x6d, 0x68, 0xa6, 0x6f, 0x66, 0xaa, 0x73, 0x65, 0xae, 0x79, 0x67,  //   8 (0x08)
	0xb4, 0x86, 0x6b, 0xbb, 0x94, 0x6f, 0xc2, 0xa2, 0x73, 0xc9, 0xb0, 0x77,  //  12 (0x0c)
	0xd0, 0xbe, 0x7b, 0xdd, 0xda, 0x83, 0xc7, 0xce, 0x7b, 0xb6, 0xc8, 0x77,  //  16 (0x10)
	0xa6, 0xc3, 0x74, 0x96, 0xbd, 0x70, 0x85, 0xb7, 0x6d, 0x76, 0xb1, 0x69,  //  20 (0x14)
	0x66, 0xab, 0x66, 0x58, 0x94, 0x63, 0x4a, 0x7d, 0x5f, 0x38, 0x5a, 0x5f,  //  24 (0x18)
	0x43, 0x61, 0x76, 0x4e, 0x67, 0x8e, 0x58, 0x6d, 0xa5, 0x63, 0x73, 0xbc,  //  28 (0x1c)
	0x44, 0x2a, 0x5c, 0x4e, 0x35, 0x66, 0x58, 0x3f, 0x6f, 0x62, 0x4a, 0x79,  //  32 (0x20)
	0x6c, 0x55, 0x82, 0x76, 0x5f, 0x8c, 0x80, 0x6a, 0x95, 0x8a, 0x75, 0x9f,  //  36 (0x24)
	0x94, 0x7f, 0xa8, 0x9e, 0x8a, 0xb2, 0xa8, 0x94, 0xbb, 0xb2, 0x9f, 0xc4,  //  40 (0x28)
	0xbc, 0xaa, 0xce, 0xc6, 0xb4, 0xd7, 0xd0, 0xbf, 0xe1, 0xda, 0xca, 0xea,  //  44 (0x2c)
	0xe4, 0xd4, 0xf4, 0xda, 0xc9, 0xea, 0xcf, 0xbe, 0xe0, 0xc4, 0xb2, 0xd6,  //  48 (0x30)
	0xb9, 0xa7, 0xcb, 0xaf, 0x9c, 0xc1, 0xa4, 0x90, 0xb7, 0x99, 0x85, 0xad,  //  52 (0x34)
	0x8f, 0x7a, 0xa3, 0x84, 0x6e, 0x99, 0x79, 0x63, 0x8f, 0x6f, 0x58, 0x85,  //  56 (0x38)
	0x64, 0x4c, 0x7b, 0x59, 0x41, 0x71, 0x4e, 0x36, 0x67, 0x44, 0x2a, 0x5c,  //  60 (0x3c)
	0x51, 0x20, 0x1f, 0x5c, 0x2b, 0x2b, 0x67, 0x37, 0x37, 0x72, 0x42, 0x42,  //  64 (0x40)
	0x7d, 0x4d, 0x4e, 0x87, 0x58, 0x59, 0x92, 0x63, 0x65, 0x9d, 0x6e, 0x71,  //  68 (0x44)
	0xa8, 0x79, 0x7c, 0xb3, 0x84, 0x88, 0xbe, 0x90, 0x94, 0xc9, 0x9b, 0x9f,  //  72 (0x48)
	0xd4, 0xa6, 0xab, 0xdf, 0xb1, 0xb7, 0xea, 0xbc, 0xc2, 0xf5, 0xc7, 0xce,  //  76 (0x4c)
	0xff, 0xd2, 0xda, 0xf4, 0xc6, 0xcd, 0xe8, 0xbb, 0xc1, 0xdd, 0xaf, 0xb4,  //  80 (0x50)
	0xd1, 0xa3, 0xa8, 0xc5, 0x97, 0x9b, 0xba, 0x8b, 0x8f, 0xae, 0x7f, 0x83,  //  84 (0x54)
	0xa2, 0x73, 0x76, 0x97, 0x67, 0x6a, 0x8b, 0x5c, 0x5d, 0x7f, 0x50, 0x51,  //  88 (0x58)
	0x74, 0x44, 0x45, 0x68, 0x38, 0x38, 0x5d, 0x2c, 0x2c, 0x51, 0x20, 0x1f,  //  92 (0x5c)
	0x44, 0x26, 0x19, 0x4f, 0x31, 0x22, 0x59, 0x3b, 0x2c, 0x64, 0x46, 0x36,  //  96 (0x60)
	0x6f, 0x51, 0x40, 0x79, 0x5b, 0x49, 0x84, 0x66, 0x53, 0x8e, 0x71, 0x5d,  // 100 (0x64)
	0x99, 0x7b, 0x66, 0xa4, 0x86, 0x70, 0xae, 0x91, 0x7a, 0xb9, 0x9b, 0x83,  // 104 (0x68)
	0xc3, 0xa6, 0x8d, 0xce, 0xb1, 0x97, 0xd9, 0xbb, 0xa1, 0xe3, 0xc6, 0xaa,  // 108 (0x6c)
	0xee, 0xd1, 0xb4, 0xe3, 0xc3, 0xa5, 0xd7, 0xb8, 0x9b, 0xcc, 0xac, 0x91,  // 112 (0x70)
	0xc1, 0xa1, 0x87, 0xb5, 0x96, 0x7d, 0xaa, 0x8b, 0x73, 0x9f, 0x80, 0x69,  // 116 (0x74)
	0x93, 0x74, 0x5f, 0x88, 0x69, 0x55, 0x7d, 0x5e, 0x4b, 0x71, 0x53, 0x41,  // 120 (0x78)
	0x66, 0x48, 0x37, 0x5b, 0x3c, 0x2d, 0x4f, 0x31, 0x23, 0x44, 0x26, 0x19,  // 124 (0x7c)
	0x76, 0x55, 0x12, 0x80, 0x5d, 0x1c, 0x8a, 0x66, 0x26, 0x93, 0x6e, 0x2f,  // 128 (0x80)
	0x9d, 0x77, 0x39, 0xa7, 0x7f, 0x43, 0xb1, 0x88, 0x4c, 0xbb, 0x91, 0x56,  // 132 (0x84)
	0xc5, 0x99, 0x5f, 0xce, 0xa2, 0x69, 0xd8, 0xaa, 0x73, 0xe2, 0xb3, 0x7c,  // 136 (0x88)
	0xec, 0xbb, 0x86, 0xf6, 0xc4, 0x8f, 0xff, 0xcc, 0x99, 0xff, 0xd5, 0xab,  // 140 (0x8c)
	0xff, 0xe1, 0xc2, 0xff, 0xd8, 0xb1, 0xf6, 0xc4, 0x8f, 0xec, 0xbb, 0x86,  // 144 (0x90)
	0xe2, 0xb3, 0x7c, 0xd8, 0xaa, 0x73, 0xce, 0xa2, 0x69, 0xc5, 0x99, 0x5f,  // 148 (0x94)
	0xbb, 0x91, 0x56, 0xb1, 0x88, 0x4c, 0xa7, 0x7f, 0x43, 0x9d, 0x77, 0x39,  // 152 (0x98)
	0x93, 0x6e, 0x2f, 0x8a, 0x66, 0x26, 0x80, 0x5d, 0x1c, 0x76, 0x55, 0x12,  // 156 (0x9c)
	0x03, 0x30, 0x03, 0x0f, 0x3d, 0x0f, 0x1a, 0x4a, 0x1a, 0x26, 0x57, 0x26,  // 160 (0xa0)
	0x31, 0x64, 0x31, 0x3d, 0x71, 0x3d, 0x49, 0x7e, 0x49, 0x54, 0x8b, 0x54,  // 164 (0xa4)
	0x60, 0x98, 0x60, 0x6b, 0xa5, 0x6b, 0x77, 0xb2, 0x77, 0x82, 0xbf, 0x83,  // 168 (0xa8)
	0x8e, 0xcc, 0x8e, 0x9a, 0xd9, 0x9a, 0xa5, 0xe6, 0xa5, 0xb1, 0xf2, 0xb1,  // 172 (0xac)
	0xbc, 0xff, 0xbc, 0xb0, 0xf2, 0xb0, 0xa4, 0xe4, 0xa4, 0x97, 0xd6, 0x97,  // 176 (0xb0)
	0x8b, 0xc8, 0x8b, 0x7f, 0xba, 0x7f, 0x72, 0xad, 0x72, 0x66, 0x9f, 0x66,  // 180 (0xb4)
	0x5a, 0x91, 0x5a, 0x4d, 0x83, 0x4d, 0x41, 0x75, 0x41, 0x34, 0x67, 0x35,  // 184 (0xb8)
	0x28, 0x5a, 0x28, 0x1c, 0x4c, 0x1c, 0x0f, 0x3e, 0x10, 0x03, 0x30, 0x03,  // 188 (0xbc)
	0x00, 0x0f, 0x55, 0x0d, 0x1d, 0x60, 0x1b, 0x2a, 0x6a, 0x29, 0x37, 0x75,  // 192 (0xc0)
	0x37, 0x45, 0x80, 0x45, 0x52, 0x8a, 0x53, 0x5f, 0x95, 0x61, 0x6d, 0xa0,  // 196 (0xc4)
	0x6f, 0x7a, 0xaa, 0x7d, 0x87, 0xb5, 0x8a, 0x95, 0xc0, 0x98, 0xa2, 0xca,  // 200 (0xc8)
	0xa6, 0xaf, 0xd5, 0xb4, 0xbd, 0xe0, 0xc2, 0xca, 0xea, 0xd0, 0xd7, 0xf5,  // 204 (0xcc)
	0xde, 0xe5, 0xff, 0xcf, 0xd6, 0xf4, 0xc0, 0xc8, 0xe9, 0xb1, 0xba, 0xdd,  // 208 (0xd0)
	0xa3, 0xac, 0xd2, 0x94, 0x9d, 0xc7, 0x85, 0x8f, 0xbb, 0x76, 0x81, 0xb0,  // 212 (0xd4)
	0x67, 0x73, 0xa5, 0x58, 0x65, 0x99, 0x4a, 0x56, 0x8e, 0x3b, 0x48, 0x83,  // 216 (0xd8)
	0x2c, 0x3a, 0x77, 0x1d, 0x2c, 0x6c, 0x0e, 0x1e, 0x61, 0x00, 0x0f, 0x55,  // 220 (0xdc)
	0x11, 0x11, 0x11, 0x20, 0x20, 0x20, 0x2f, 0x2f, 0x2f, 0x3e, 0x3e, 0x3e,  // 224 (0xe0)
	0x4d, 0x4d, 0x4d, 0x5c, 0x5c, 0x5c, 0x6a, 0x6a, 0x6a, 0x79, 0x79, 0x79,  // 228 (0xe4)
	0x88, 0x88, 0x88, 0x97, 0x97, 0x97, 0xa6, 0xa6, 0xa6, 0xb5, 0xb5, 0xb5,  // 232 (0xe8)
	0xc4, 0xc4, 0xc4, 0xd3, 0xd3, 0xd3, 0xe2, 0xe2, 0xe2, 0xf1, 0xf1, 0xf1,  // 236 (0xec)
	0xff, 0xff, 0xff, 0xee, 0xee, 0xee, 0xdd, 0xdd, 0xdd, 0xcc, 0xcc, 0xcc,  // 240 (0xf0)
	0xbb, 0xbb, 0xbb, 0xaa, 0xaa, 0xaa, 0x99, 0x99, 0x99, 0x88, 0x88, 0x88,  // 244 (0xf4)
	0x77, 0x77, 0x77, 0x66, 0x66, 0x66, 0x55, 0x55, 0x55, 0x44, 0x44, 0x44,  // 248 (0xf8)
	0x33, 0x33, 0x33, 0x22, 0x22, 0x22, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00,  // 252 (0xfc)
};

static byte win16Palette[48] = {
	0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff,  //   0 (0x00)
	0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x7f, 0x7f, 0x7f,  //   4 (0x04)
	0xc0, 0xc0, 0xc0, 0x00, 0xbf, 0xbf, 0xbf, 0x00, 0xbf, 0x00, 0x00, 0xbf,  //   8 (0x08)
	0xbf, 0xbf, 0x00, 0x00, 0xbf, 0x00, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00,  //  12 (0x0c)
};

static byte winD516Palette[48] = {
	0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff,  //   0 (0x00)
	0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x80, 0x80, 0x80,  //   4 (0x04)
	0xa0, 0xa0, 0xa4, 0x00, 0x80, 0x80, 0x80, 0x00, 0x80, 0x00, 0x00, 0x80,  //   8 (0x08)
	0x80, 0x80, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  //  12 (0x0c)
};

static byte winPalette[768] = {
	0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff,  //   0 (0x00)
	0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x80, 0x80, 0x80,  //   4 (0x04)
	0xa0, 0xa0, 0xa4, 0xff, 0xfb, 0xf0, 0x33, 0x33, 0x33, 0x99, 0x66, 0x00,  //   8 (0x08)
	0x33, 0x66, 0x33, 0x00, 0x33, 0x99, 0xcc, 0x00, 0xff, 0x88, 0x00, 0x00,  //  12 (0x0c)
	0xff, 0xcc, 0x66, 0xff, 0x99, 0xcc, 0xdd, 0xdd, 0xdd, 0xff, 0x99, 0x00,  //  16 (0x10)
	0xff, 0x66, 0xff, 0xff, 0x66, 0xcc, 0xff, 0x66, 0x99, 0xff, 0x66, 0x66,  //  20 (0x14)
	0xff, 0x66, 0x33, 0xff, 0x66, 0x00, 0xff, 0x33, 0xff, 0xff, 0x33, 0xcc,  //  24 (0x18)
	0xff, 0x33, 0x99, 0xff, 0x33, 0x66, 0xff, 0x33, 0x33, 0xff, 0x33, 0x00,  //  28 (0x1c)
	0xff, 0x00, 0xcc, 0xff, 0x00, 0x99, 0xff, 0x00, 0x66, 0xff, 0x00, 0x33,  //  32 (0x20)
	0xcc, 0xff, 0xff, 0xcc, 0xff, 0xcc, 0xcc, 0xff, 0x99, 0xcc, 0xff, 0x66,  //  36 (0x24)
	0xcc, 0xff, 0x33, 0xcc, 0xff, 0x00, 0xcc, 0xcc, 0xff, 0xcc, 0xcc, 0xcc,  //  40 (0x28)
	0xcc, 0xcc, 0x99, 0xcc, 0xcc, 0x66, 0xcc, 0xcc, 0x33, 0xcc, 0xcc, 0x00,  //  44 (0x2c)
	0xcc, 0x99, 0xff, 0xcc, 0x99, 0xcc, 0xcc, 0x99, 0x99, 0xcc, 0x99, 0x66,  //  48 (0x30)
	0xcc, 0x99, 0x33, 0xcc, 0x99, 0x00, 0xcc, 0x66, 0xff, 0xcc, 0x66, 0xcc,  //  52 (0x34)
	0xcc, 0x66, 0x99, 0xcc, 0x66, 0x66, 0xcc, 0x66, 0x33, 0xcc, 0x66, 0x00,  //  56 (0x38)
	0xcc, 0x33, 0xff, 0xcc, 0x33, 0xcc, 0xcc, 0x33, 0x99, 0xcc, 0x33, 0x66,  //  60 (0x3c)
	0xcc, 0x33, 0x33, 0xcc, 0x33, 0x00, 0xd4, 0x08, 0xff, 0xcc, 0x00, 0xcc,  //  64 (0x40)
	0xcc, 0x00, 0x99, 0xcc, 0x00, 0x66, 0xcc, 0x00, 0x33, 0xcc, 0x00, 0x00,  //  68 (0x44)
	0x99, 0xff, 0xff, 0x99, 0xff, 0xcc, 0x99, 0xff, 0x99, 0x99, 0xff, 0x66,  //  72 (0x48)
	0x99, 0xff, 0x33, 0x99, 0xff, 0x00, 0x99, 0xcc, 0xff, 0x99, 0xcc, 0xcc,  //  76 (0x4c)
	0x99, 0xcc, 0x99, 0x99, 0xcc, 0x66, 0x99, 0xcc, 0x33, 0x99, 0xcc, 0x00,  //  80 (0x50)
	0x99, 0x99, 0xff, 0x99, 0x99, 0xcc, 0x99, 0x99, 0x99, 0x99, 0x99, 0x66,  //  84 (0x54)
	0x99, 0x99, 0x33, 0x99, 0x99, 0x00, 0x99, 0x66, 0xff, 0x99, 0x66, 0xcc,  //  88 (0x58)
	0x99, 0x66, 0x99, 0x99, 0x66, 0x66, 0x99, 0x66, 0x33, 0xa1, 0x66, 0x00,  //  92 (0x5c)
	0x99, 0x33, 0xff, 0x99, 0x33, 0xcc, 0x99, 0x33, 0x99, 0x99, 0x33, 0x66,  //  96 (0x60)
	0x99, 0x33, 0x33, 0x99, 0x33, 0x00, 0x99, 0x00, 0xff, 0x99, 0x00, 0xcc,  // 100 (0x64)
	0x99, 0x00, 0x99, 0x99, 0x00, 0x66, 0x99, 0x00, 0x33, 0x99, 0x00, 0x00,  // 104 (0x68)
	0x66, 0xff, 0xff, 0x66, 0xff, 0xcc, 0x66, 0xff, 0x99, 0x66, 0xff, 0x66,  // 108 (0x6c)
	0x66, 0xff, 0x33, 0x66, 0xff, 0x00, 0x66, 0xcc, 0xff, 0x66, 0xcc, 0xcc,  // 112 (0x70)
	0x66, 0xcc, 0x99, 0x66, 0xcc, 0x66, 0x66, 0xcc, 0x33, 0x66, 0xcc, 0x00,  // 116 (0x74)
	0x66, 0x99, 0xff, 0x66, 0x99, 0xcc, 0x66, 0x99, 0x99, 0x66, 0x99, 0x66,  // 120 (0x78)
	0x66, 0x99, 0x33, 0x66, 0x99, 0x00, 0x66, 0x66, 0xff, 0x66, 0x66, 0xcc,  // 124 (0x7c)
	0x66, 0x66, 0x99, 0x66, 0x66, 0x66, 0x66, 0x66, 0x33, 0x66, 0x66, 0x00,  // 128 (0x80)
	0x66, 0x33, 0xff, 0x66, 0x33, 0xcc, 0x66, 0x33, 0x99, 0x66, 0x33, 0x66,  // 132 (0x84)
	0x66, 0x33, 0x33, 0x66, 0x33, 0x00, 0x66, 0x00, 0xff, 0x66, 0x00, 0xcc,  // 136 (0x88)
	0x66, 0x00, 0x99, 0x66, 0x00, 0x66, 0x66, 0x00, 0x33, 0x66, 0x00, 0x00,  // 140 (0x8c)
	0x33, 0xff, 0xff, 0x33, 0xff, 0xcc, 0x33, 0xff, 0x99, 0x33, 0xff, 0x66,  // 144 (0x90)
	0x33, 0xff, 0x33, 0x33, 0xff, 0x00, 0x33, 0xcc, 0xff, 0x33, 0xcc, 0xcc,  // 148 (0x94)
	0x33, 0xcc, 0x99, 0x33, 0xcc, 0x66, 0x33, 0xcc, 0x33, 0x33, 0xcc, 0x00,  // 152 (0x98)
	0x33, 0x99, 0xff, 0x33, 0x99, 0xcc, 0x33, 0x99, 0x99, 0x33, 0x99, 0x66,  // 156 (0x9c)
	0x33, 0x99, 0x33, 0x33, 0x99, 0x00, 0x33, 0x66, 0xff, 0x33, 0x66, 0xcc,  // 160 (0xa0)
	0x33, 0x66, 0x99, 0x33, 0x66, 0x66, 0x33, 0x6e, 0x33, 0x33, 0x66, 0x00,  // 164 (0xa4)
	0x33, 0x33, 0xff, 0x33, 0x33, 0xcc, 0x33, 0x33, 0x99, 0x33, 0x33, 0x66,  // 168 (0xa8)
	0x33, 0x33, 0x3b, 0x33, 0x33, 0x00, 0x33, 0x00, 0xff, 0x33, 0x00, 0xcc,  // 172 (0xac)
	0x33, 0x00, 0x99, 0x33, 0x00, 0x66, 0x33, 0x00, 0x33, 0x33, 0x00, 0x00,  // 176 (0xb0)
	0x00, 0xff, 0xcc, 0x00, 0xff, 0x99, 0x00, 0xff, 0x66, 0x00, 0xff, 0x33,  // 180 (0xb4)
	0x00, 0xcc, 0xff, 0x00, 0xcc, 0xcc, 0x00, 0xcc, 0x99, 0x00, 0xcc, 0x66,  // 184 (0xb8)
	0x00, 0xcc, 0x33, 0x00, 0xcc, 0x00, 0x00, 0x99, 0xff, 0x00, 0x99, 0xcc,  // 188 (0xbc)
	0x00, 0x99, 0x99, 0x00, 0x99, 0x66, 0x00, 0x99, 0x33, 0x00, 0x99, 0x00,  // 192 (0xc0)
	0x00, 0x66, 0xff, 0x00, 0x66, 0xcc, 0x00, 0x66, 0x99, 0x00, 0x66, 0x66,  // 196 (0xc4)
	0x00, 0x66, 0x33, 0x00, 0x66, 0x00, 0x00, 0x33, 0xff, 0x00, 0x33, 0xcc,  // 200 (0xc8)
	0x00, 0x33, 0xa1, 0x00, 0x33, 0x66, 0x00, 0x33, 0x33, 0x00, 0x33, 0x00,  // 204 (0xcc)
	0x00, 0x00, 0xcc, 0x00, 0x00, 0x99, 0x00, 0x00, 0x66, 0x00, 0x00, 0x33,  // 208 (0xd0)
	0xee, 0x00, 0x00, 0xdd, 0x00, 0x00, 0xaa, 0x00, 0x00, 0x90, 0x00, 0x00,  // 212 (0xd4)
	0x77, 0x00, 0x00, 0x55, 0x00, 0x00, 0x44, 0x00, 0x00, 0x22, 0x00, 0x00,  // 216 (0xd8)
	0x11, 0x00, 0x00, 0x00, 0xee, 0x00, 0x00, 0xdd, 0x00, 0x00, 0xaa, 0x00,  // 220 (0xdc)
	0x00, 0x88, 0x00, 0x00, 0x77, 0x00, 0x00, 0x55, 0x00, 0x00, 0x44, 0x00,  // 224 (0xe0)
	0x00, 0x22, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0xee, 0x00, 0x00, 0xdd,  // 228 (0xe4)
	0x00, 0x00, 0xaa, 0x00, 0x00, 0x88, 0x00, 0x00, 0x77, 0x00, 0x00, 0x55,  // 232 (0xe8)
	0x00, 0x00, 0x44, 0x00, 0x00, 0x22, 0x00, 0x00, 0x11, 0x22, 0x22, 0x30,  // 236 (0xec)
	0xff, 0x99, 0x99, 0xff, 0xcc, 0xff, 0x99, 0xd4, 0xff, 0x99, 0xd4, 0x99,  // 240 (0xf0)
	0xff, 0xff, 0x99, 0xf0, 0xf0, 0xf0, 0xa4, 0xc8, 0xf0, 0xc0, 0xdc, 0xc0,  // 244 (0xf4)
	0xc0, 0xc0, 0xc0, 0x00, 0xbf, 0xbf, 0xbf, 0x00, 0xbf, 0x00, 0x00, 0xbf,  // 248 (0xf8)
	0xbf, 0xbf, 0x00, 0x00, 0xbf, 0x00, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00,  // 252 (0xfc)
};

static byte winD5Palette[768] = {
	0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff,  //   0 (0x00)
	0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x80, 0x80, 0x80,  //   4 (0x04)
	0xa0, 0xa0, 0xa4, 0xff, 0xfb, 0xf0, 0x33, 0x33, 0x33, 0x99, 0x66, 0x00,  //   8 (0x08)
	0x33, 0x66, 0x33, 0x00, 0x33, 0x99, 0xcc, 0x00, 0xff, 0x88, 0x00, 0x00,  //  12 (0x0c)
	0xff, 0xcc, 0x66, 0xff, 0x99, 0xcc, 0xdd, 0xdd, 0xdd, 0xff, 0x99, 0x00,  //  16 (0x10)
	0xff, 0x66, 0xff, 0xff, 0x66, 0xcc, 0xff, 0x66, 0x99, 0xff, 0x66, 0x66,  //  20 (0x14)
	0xff, 0x66, 0x33, 0xff, 0x66, 0x00, 0xff, 0x33, 0xff, 0xff, 0x33, 0xcc,  //  24 (0x18)
	0xff, 0x33, 0x99, 0xff, 0x33, 0x66, 0xff, 0x33, 0x33, 0xff, 0x33, 0x00,  //  28 (0x1c)
	0xff, 0x00, 0xcc, 0xff, 0x00, 0x99, 0xff, 0x00, 0x66, 0xff, 0x00, 0x33,  //  32 (0x20)
	0xcc, 0xff, 0xff, 0xcc, 0xff, 0xcc, 0xcc, 0xff, 0x99, 0xcc, 0xff, 0x66,  //  36 (0x24)
	0xcc, 0xff, 0x33, 0xcc, 0xff, 0x00, 0xcc, 0xcc, 0xff, 0xcc, 0xcc, 0xcc,  //  40 (0x28)
	0xcc, 0xcc, 0x99, 0xcc, 0xcc, 0x66, 0xcc, 0xcc, 0x33, 0xcc, 0xcc, 0x00,  //  44 (0x2c)
	0xcc, 0x99, 0xff, 0xcc, 0x99, 0xcc, 0xcc, 0x99, 0x99, 0xcc, 0x99, 0x66,  //  48 (0x30)
	0xcc, 0x99, 0x33, 0xcc, 0x99, 0x00, 0xcc, 0x66, 0xff, 0xcc, 0x66, 0xcc,  //  52 (0x34)
	0xcc, 0x66, 0x99, 0xcc, 0x66, 0x66, 0xcc, 0x66, 0x33, 0xcc, 0x66, 0x00,  //  56 (0x38)
	0xcc, 0x33, 0xff, 0xcc, 0x33, 0xcc, 0xcc, 0x33, 0x99, 0xcc, 0x33, 0x66,  //  60 (0x3c)
	0xcc, 0x33, 0x33, 0xcc, 0x33, 0x00, 0xd4, 0x08, 0xff, 0xcc, 0x00, 0xcc,  //  64 (0x40)
	0xcc, 0x00, 0x99, 0xcc, 0x00, 0x66, 0xcc, 0x00, 0x33, 0xcc, 0x00, 0x00,  //  68 (0x44)
	0x99, 0xff, 0xff, 0x99, 0xff, 0xcc, 0x99, 0xff, 0x99, 0x99, 0xff, 0x66,  //  72 (0x48)
	0x99, 0xff, 0x33, 0x99, 0xff, 0x00, 0x99, 0xcc, 0xff, 0x99, 0xcc, 0xcc,  //  76 (0x4c)
	0x99, 0xcc, 0x99, 0x99, 0xcc, 0x66, 0x99, 0xcc, 0x33, 0x99, 0xcc, 0x00,  //  80 (0x50)
	0x99, 0x99, 0xff, 0x99, 0x99, 0xcc, 0x99, 0x99, 0x99, 0x99, 0x99, 0x66,  //  84 (0x54)
	0x99, 0x99, 0x33, 0x99, 0x99, 0x00, 0x99, 0x66, 0xff, 0x99, 0x66, 0xcc,  //  88 (0x58)
	0x99, 0x66, 0x99, 0x99, 0x66, 0x66, 0x99, 0x66, 0x33, 0xa1, 0x66, 0x00,  //  92 (0x5c)
	0x99, 0x33, 0xff, 0x99, 0x33, 0xcc, 0x99, 0x33, 0x99, 0x99, 0x33, 0x66,  //  96 (0x60)
	0x99, 0x33, 0x33, 0x99, 0x33, 0x00, 0x99, 0x00, 0xff, 0x99, 0x00, 0xcc,  // 100 (0x64)
	0x99, 0x00, 0x99, 0x99, 0x00, 0x66, 0x99, 0x00, 0x33, 0x99, 0x00, 0x00,  // 104 (0x68)
	0x66, 0xff, 0xff, 0x66, 0xff, 0xcc, 0x66, 0xff, 0x99, 0x66, 0xff, 0x66,  // 108 (0x6c)
	0x66, 0xff, 0x33, 0x66, 0xff, 0x00, 0x66, 0xcc, 0xff, 0x66, 0xcc, 0xcc,  // 112 (0x70)
	0x66, 0xcc, 0x99, 0x66, 0xcc, 0x66, 0x66, 0xcc, 0x33, 0x66, 0xcc, 0x00,  // 116 (0x74)
	0x66, 0x99, 0xff, 0x66, 0x99, 0xcc, 0x66, 0x99, 0x99, 0x66, 0x99, 0x66,  // 120 (0x78)
	0x66, 0x99, 0x33, 0x66, 0x99, 0x00, 0x66, 0x66, 0xff, 0x66, 0x66, 0xcc,  // 124 (0x7c)
	0x66, 0x66, 0x99, 0x66, 0x66, 0x66, 0x66, 0x66, 0x33, 0x66, 0x66, 0x00,  // 128 (0x80)
	0x66, 0x33, 0xff, 0x66, 0x33, 0xcc, 0x66, 0x33, 0x99, 0x66, 0x33, 0x66,  // 132 (0x84)
	0x66, 0x33, 0x33, 0x66, 0x33, 0x00, 0x66, 0x00, 0xff, 0x66, 0x00, 0xcc,  // 136 (0x88)
	0x66, 0x00, 0x99, 0x66, 0x00, 0x66, 0x66, 0x00, 0x33, 0x66, 0x00, 0x00,  // 140 (0x8c)
	0x33, 0xff, 0xff, 0x33, 0xff, 0xcc, 0x33, 0xff, 0x99, 0x33, 0xff, 0x66,  // 144 (0x90)
	0x33, 0xff, 0x33, 0x33, 0xff, 0x00, 0x33, 0xcc, 0xff, 0x33, 0xcc, 0xcc,  // 148 (0x94)
	0x33, 0xcc, 0x99, 0x33, 0xcc, 0x66, 0x33, 0xcc, 0x33, 0x33, 0xcc, 0x00,  // 152 (0x98)
	0x33, 0x99, 0xff, 0x33, 0x99, 0xcc, 0x33, 0x99, 0x99, 0x33, 0x99, 0x66,  // 156 (0x9c)
	0x33, 0x99, 0x33, 0x33, 0x99, 0x00, 0x33, 0x66, 0xff, 0x33, 0x66, 0xcc,  // 160 (0xa0)
	0x33, 0x66, 0x99, 0x33, 0x66, 0x66, 0x33, 0x6e, 0x33, 0x33, 0x66, 0x00,  // 164 (0xa4)
	0x33, 0x33, 0xff, 0x33, 0x33, 0xcc, 0x33, 0x33, 0x99, 0x33, 0x33, 0x66,  // 168 (0xa8)
	0x33, 0x33, 0x3b, 0x33, 0x33, 0x00, 0x33, 0x00, 0xff, 0x33, 0x00, 0xcc,  // 172 (0xac)
	0x33, 0x00, 0x99, 0x33, 0x00, 0x66, 0x33, 0x00, 0x33, 0x33, 0x00, 0x00,  // 176 (0xb0)
	0x00, 0xff, 0xcc, 0x00, 0xff, 0x99, 0x00, 0xff, 0x66, 0x00, 0xff, 0x33,  // 180 (0xb4)
	0x00, 0xcc, 0xff, 0x00, 0xcc, 0xcc, 0x00, 0xcc, 0x99, 0x00, 0xcc, 0x66,  // 184 (0xb8)
	0x00, 0xcc, 0x33, 0x00, 0xcc, 0x00, 0x00, 0x99, 0xff, 0x00, 0x99, 0xcc,  // 188 (0xbc)
	0x00, 0x99, 0x99, 0x00, 0x99, 0x66, 0x00, 0x99, 0x33, 0x00, 0x99, 0x00,  // 192 (0xc0)
	0x00, 0x66, 0xff, 0x00, 0x66, 0xcc, 0x00, 0x66, 0x99, 0x00, 0x66, 0x66,  // 196 (0xc4)
	0x00, 0x66, 0x33, 0x00, 0x66, 0x00, 0x00, 0x33, 0xff, 0x00, 0x33, 0xcc,  // 200 (0xc8)
	0x00, 0x33, 0xa1, 0x00, 0x33, 0x66, 0x00, 0x33, 0x33, 0x00, 0x33, 0x00,  // 204 (0xcc)
	0x00, 0x00, 0xcc, 0x00, 0x00, 0x99, 0x00, 0x00, 0x66, 0x00, 0x00, 0x33,  // 208 (0xd0)
	0xee, 0x00, 0x00, 0xdd, 0x00, 0x00, 0xaa, 0x00, 0x00, 0x90, 0x00, 0x00,  // 212 (0xd4)
	0x77, 0x00, 0x00, 0x55, 0x00, 0x00, 0x44, 0x00, 0x00, 0x22, 0x00, 0x00,  // 216 (0xd8)
	0x11, 0x00, 0x00, 0x00, 0xee, 0x00, 0x00, 0xdd, 0x00, 0x00, 0xaa, 0x00,  // 220 (0xdc)
	0x00, 0x88, 0x00, 0x00, 0x77, 0x00, 0x00, 0x55, 0x00, 0x00, 0x44, 0x00,  // 224 (0xe0)
	0x00, 0x22, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0xee, 0x00, 0x00, 0xdd,  // 228 (0xe4)
	0x00, 0x00, 0xaa, 0x00, 0x00, 0x88, 0x00, 0x00, 0x77, 0x00, 0x00, 0x55,  // 232 (0xe8)
	0x00, 0x00, 0x44, 0x00, 0x00, 0x22, 0x00, 0x00, 0x11, 0x22, 0x22, 0x30,  // 236 (0xec)
	0xff, 0x99, 0x99, 0xff, 0xcc, 0xff, 0x99, 0xd4, 0xff, 0x99, 0xd4, 0x99,  // 240 (0xf0)
	0xff, 0xff, 0x99, 0xf0, 0xf0, 0xf0, 0xa6, 0xc8, 0xf0, 0xc0, 0xdc, 0xc0,  // 244 (0xf4)
	0xc0, 0xc0, 0xc0, 0x00, 0x80, 0x80, 0x80, 0x00, 0x80, 0x00, 0x00, 0x80,  // 248 (0xf8)
	0x80, 0x80, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  // 252 (0xfc)
};


// For 2-bit and 4-bit graphics, Director assumes a fixed palette and uses nearest-neighbour
// remapping to the current movie palette.

// The 2-bit palette is clear cut; white, light gray, dark gray, black.
static byte grayscale4Palette[12] = {
	0xff, 0xff, 0xff, 0xa3, 0xa3, 0xa3, 0x65, 0x65, 0x65, 0x00, 0x00, 0x00
};


static byte director3Patterns[][8] = {
	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
	{ 0xFF, 0xFF, 0x77, 0xFF, 0xFF, 0xFF, 0x77, 0xFF },
	{ 0x77, 0xFF, 0xDD, 0xFF, 0x77, 0xFF, 0xDD, 0xFF },
	{ 0xFF, 0xDD, 0xFF, 0x55, 0xFF, 0xDD, 0xFF, 0x55 },
	{ 0xFF, 0xD5, 0xFF, 0x55, 0xFF, 0x5D, 0xFF, 0x55 },
	{ 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA },
	{ 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA },
	{ 0xAA, 0x44, 0xAA, 0x11, 0xAA, 0x44, 0xAA, 0x11 },
	{ 0xAA, 0x44, 0xAA, 0x00, 0xAA, 0x44, 0xAA, 0x00 },
	{ 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0x00 },
	{ 0x00, 0x22, 0x00, 0x88, 0x00, 0x22, 0x00, 0x88 },
	{ 0x88, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00 },
	{ 0x80, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00 },
	{ 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80 },
	{ 0x21, 0x42, 0x84, 0x09, 0x12, 0x24, 0x48, 0x90 },
	{ 0x11, 0x22, 0x44, 0x88, 0x11, 0x22, 0x44, 0x88 },
	{ 0xEE, 0xDD, 0xBB, 0x77, 0xEE, 0xDD, 0xBB, 0x77 },
	{ 0xF6, 0xED, 0xDB, 0xB7, 0x6F, 0xDE, 0xBD, 0x7B },
	{ 0xFE, 0xFD, 0xFB, 0xF7, 0xEF, 0xDF, 0xBF, 0x7F },
	{ 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF },
	{ 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF },
	{ 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0xFF },
	{ 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF },
	{ 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00 },
	{ 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00 },
	{ 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00 },
	{ 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
	{ 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
	{ 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88 },
	{ 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94 },
	{ 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA },
	{ 0xAD, 0xAD, 0xAD, 0xAD, 0xAD, 0xAD, 0xAD, 0xAD },
	{ 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB },
	{ 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7 },
	{ 0xBF, 0xBF, 0xBF, 0xBF, 0xBF, 0xBF, 0xBF, 0xBF },
	{ 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x00 },
	{ 0x7F, 0x7F, 0x7F, 0x00, 0x7F, 0x7F, 0x7F, 0x00 },
	{ 0x77, 0x77, 0x77, 0x00, 0x77, 0x77, 0x77, 0x00 },
	{ 0x88, 0x88, 0x88, 0xFF, 0x88, 0x88, 0x88, 0xFF },
	{ 0x80, 0x80, 0x80, 0xFF, 0x80, 0x80, 0x80, 0xFF },
	{ 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xFF },
	{ 0x01, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82 },
	{ 0x11, 0x82, 0x45, 0xAB, 0xD7, 0xAB, 0x45, 0x82 },
	{ 0xF7, 0x7F, 0xBE, 0x5D, 0x2A, 0x5D, 0xBE, 0x7F },
	{ 0xFE, 0x7D, 0xBB, 0xD7, 0xEF, 0xD7, 0xBB, 0x7D },
	{ 0xFE, 0x7F, 0xBF, 0xDF, 0xEF, 0xDF, 0xBF, 0x7F },
	{ 0xEE, 0x77, 0xBB, 0xDD, 0xEE, 0xDD, 0xBB, 0x77 },
	{ 0x11, 0x88, 0x44, 0x22, 0x11, 0x22, 0x44, 0x88 },
	{ 0x01, 0x80, 0x40, 0x20, 0x10, 0x20, 0x40, 0x80 },
	{ 0x22, 0x00, 0x01, 0x22, 0x54, 0x88, 0x01, 0x00 },
	{ 0xBF, 0xAF, 0xAB, 0xAA, 0xEA, 0xFA, 0xFE, 0xFF },
	{ 0xFF, 0xFF, 0xBE, 0x9C, 0xAA, 0xB6, 0xBE, 0xFF }
};

static byte director3QuickDrawPatterns[][8] = {
	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
	{ 0xDD, 0xFF, 0x77, 0xFF, 0xDD, 0xFF, 0x77, 0xFF },
	{ 0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77 },
	{ 0xEE, 0xDD, 0xBB, 0x77, 0xEE, 0xDD, 0xBB, 0x77 },
	{ 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA },
	{ 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55 },
	{ 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55 },
	{ 0x11, 0x22, 0x44, 0x88, 0x11, 0x22, 0x44, 0x88 },
	{ 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0x00 },
	{ 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22 },
	{ 0x00, 0x22, 0x00, 0x88, 0x00, 0x22, 0x00, 0x88 },
	{ 0x10, 0x20, 0x40, 0x80, 0x01, 0x02, 0x04, 0x08 },
	{ 0x80, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00 },
	{ 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88 },
	{ 0x58, 0xDF, 0x00, 0xDF, 0xDF, 0x58, 0x58, 0x58 },
	{ 0xB1, 0x36, 0x06, 0x60, 0x63, 0x1B, 0x18, 0x81 },
	{ 0x08, 0xFF, 0x01, 0x01, 0x01, 0xFF, 0x08, 0x08 },
	{ 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00 },
	{ 0x80, 0x80, 0x80, 0xFF, 0x80, 0x80, 0x80, 0x80 },
	{ 0x80, 0x10, 0x02, 0x40, 0x04, 0x20, 0x09, 0x00 },
	{ 0x80, 0x01, 0x82, 0x44, 0x38, 0x10, 0x20, 0x40 },
	{ 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00 },
	{ 0x22, 0xFF, 0x22, 0x22, 0x22, 0xFF, 0x22, 0x22 },
	{ 0x00, 0x08, 0x14, 0x2A, 0x55, 0x2A, 0x14, 0x08 },
	{ 0x81, 0xAA, 0x14, 0x08, 0x08, 0xAA, 0x41, 0x80 },
	{ 0x3E, 0x1D, 0x88, 0xD1, 0xE3, 0xC5, 0x88, 0x5C },
	{ 0xAA, 0x00, 0x80, 0x00, 0x88, 0x00, 0x80, 0x00 },
	{ 0x00, 0x11, 0x82, 0x44, 0x28, 0x11, 0x00, 0x55 },
	{ 0x7C, 0x10, 0x10, 0x28, 0xC7, 0x01, 0x01, 0x82 },
	{ 0xEE, 0x31, 0xF1, 0xF1, 0xEE, 0x13, 0x1F, 0x1F },
	{ 0x00, 0x40, 0x20, 0x10, 0x00, 0x01, 0x02, 0x04 },
	{ 0x00, 0x00, 0x40, 0xA0, 0x00, 0x04, 0x0A, 0x00 },
	{ 0x20, 0x60, 0x90, 0x09, 0x06, 0x81, 0x40, 0x20 },
	{ 0x00, 0x7F, 0x43, 0x5F, 0x5F, 0x5F, 0x7F, 0x7F },
	{ 0x01, 0x02, 0x45, 0xAA, 0xFF, 0x20, 0x40, 0x80 },
	{ 0x00, 0x44, 0x0A, 0x11, 0x11, 0x11, 0x51, 0x24 },
	{ 0x0F, 0x0F, 0x0F, 0x0F, 0xF0, 0xF0, 0xF0, 0xF0 },
	{ 0xF8, 0xFC, 0xFA, 0xFC, 0xFA, 0x54, 0x2A, 0x00 },
	{ 0x42, 0xC3, 0x3C, 0x3C, 0x3C, 0x3C, 0xC3, 0x42 },
	{ 0x10, 0x38, 0x7C, 0xFE, 0x7D, 0x3A, 0x14, 0x08 },
	{ 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF },
	{ 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC },
	{ 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00 },
	{ 0xBB, 0xDD, 0xAE, 0x77, 0xEE, 0xDD, 0xAB, 0x77 },
	{ 0x80, 0x40, 0x40, 0x20, 0x20, 0x18, 0x06, 0x01 },
	{ 0x01, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82 },
	{ 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xFF, 0xFF },
	{ 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xFF, 0xFF, 0xFF },
	{ 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00 },
	{ 0xC3, 0x87, 0x0F, 0x1E, 0x3C, 0x78, 0xF0, 0xE1 },
	{ 0xF0, 0xF0, 0x0F, 0x0F, 0x0F, 0xF0, 0xF0, 0xF0 },
	{ 0xFF, 0xFF, 0xE7, 0xC3, 0x81, 0x18, 0x3C, 0x7E },
	{ 0x1F, 0x8F, 0xC7, 0xE3, 0xC7, 0x8F, 0x1F, 0x3E },
	{ 0xFF, 0x2A, 0xFF, 0xC8, 0xFF, 0x65, 0xFF, 0x9D }
};

static const byte mouseUp[] = {
	3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 0, 0, 3, 3, 0, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 0, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 1, 1, 1, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 1, 1, 1, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3
};

static const byte mouseDown[] = {
	3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 0, 0, 3, 3, 0, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 0, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3
};

static const byte tile1[] = {
	0x07, 0xce, 0xf0, 0xcf, 0xef, 0xcf, 0xef, 0xcf, 0xf0, 0xfc, 0xce, 0x0d, 0xef, 0xce, 0xcf, 0xd4,
	0xcf, 0xef, 0xcf, 0xef, 0xcf, 0xf0, 0xcf, 0xf0, 0xd5, 0xcf, 0xfe, 0xd5, 0x15, 0xf1, 0xd5, 0xc7,
	0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xce, 0xc7, 0xcd, 0xce, 0xcd, 0xce, 0xce,
	0xcd, 0xce, 0xcd, 0xfb, 0xce, 0x00, 0xef, 0xfe, 0xce, 0x08, 0xf0, 0xce, 0xce, 0xcf, 0xef, 0xce,
	0xcf, 0xef, 0xcf, 0xfe, 0xce, 0x1e, 0xd4, 0xce, 0xce, 0xcf, 0xce, 0xef, 0xce, 0xce, 0xcf, 0xd4,
	0xcf, 0xce, 0xf0, 0xcf, 0xf0, 0xcf, 0xf0, 0xcf, 0xd5, 0xcf, 0xd5, 0xcf, 0xf1, 0xcd, 0xc7, 0xcd,
	0xc7, 0xcd, 0xcd, 0xc7, 0xce, 0xfe, 0xcd, 0x05, 0xce, 0xc7, 0xce, 0xcd, 0xc8, 0xcd, 0xfe, 0xce,
	0x00, 0xcd, 0xfa, 0xce, 0x01, 0xf0, 0xce, 0x07, 0xce, 0xf0, 0xce, 0xcf, 0xef, 0xcf, 0xef, 0xcf,
	0xfb, 0xce, 0x26, 0xef, 0xce, 0xce, 0xcf, 0xef, 0xce, 0xcf, 0xef, 0xcf, 0xef, 0xcf, 0xef, 0xcf,
	0xf0, 0xcf, 0xf0, 0xcf, 0xd5, 0xd5, 0xcf, 0xc7, 0xcc, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7,
	0xcd, 0xc8, 0xcd, 0xcd, 0xce, 0xcd, 0xce, 0xcd, 0xce, 0xcd, 0xf7, 0xce, 0x08, 0xcf, 0xce, 0xcf,
	0xef, 0xce, 0xcf, 0xd4, 0xcf, 0xcd, 0xf8, 0xce, 0x26, 0xef, 0xce, 0xcf, 0xd4, 0xce, 0xcf, 0xef,
	0xce, 0xd5, 0xcf, 0xef, 0xcf, 0xf0, 0xd5, 0xcf, 0xd5, 0xd5, 0xf1, 0xcd, 0xc7, 0xcc, 0xc7, 0xcd,
	0xc7, 0xcd, 0xcd, 0xc7, 0xcd, 0xcd, 0xc8, 0xcd, 0xc7, 0xce, 0xcd, 0xc8, 0xce, 0xcd, 0xce, 0xcd,
	0xfd, 0xce, 0x02, 0xd4, 0xce, 0xce, 0x00, 0xef, 0xfe, 0xce, 0x03, 0xcf, 0xd4, 0xce, 0xcf, 0xfe,
	0xce, 0x00, 0xcd, 0xfe, 0xce, 0x27, 0xef, 0xce, 0xce, 0xcf, 0xce, 0xce, 0xcf, 0xef, 0xce, 0xcf,
	0xef, 0xcf, 0xce, 0xd5, 0xcf, 0xf0, 0xcf, 0xd5, 0xcf, 0xd5, 0xcf, 0xcd, 0xc6, 0xc7, 0xcd, 0xc7,
	0xcd, 0xc7, 0xcd, 0xc7, 0xce, 0xc7, 0xcd, 0xcd, 0xce, 0xcd, 0xc8, 0xcd, 0xce, 0xcd, 0xfe, 0xce,
	0x00, 0xcd, 0xfa, 0xce, 0x08, 0xcf, 0xd4, 0xce, 0xcf, 0xce, 0xcd, 0xc8, 0xce, 0xcd, 0xfa, 0xce,
	0x19, 0xef, 0xce, 0xef, 0xce, 0xce, 0xf0, 0xce, 0xcf, 0xef, 0xcf, 0xef, 0xcf, 0xf0, 0xcf, 0xf0,
	0xd5, 0xcf, 0xd5, 0xd5, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xfe, 0xcd, 0x09, 0xc7, 0xce,
	0xc7, 0xcd, 0xce, 0xcd, 0xce, 0xc7, 0xce, 0xcd, 0xfb, 0xce, 0xfb, 0xce, 0x04, 0xf0, 0xce, 0xc7,
	0xce, 0xcd, 0xf6, 0xce, 0x26, 0xcf, 0xce, 0xcf, 0xef, 0xce, 0xcf, 0xef, 0xcf, 0xef, 0xcf, 0xef,
	0xcf, 0xf0, 0xcf, 0xd5, 0xd5, 0xcd, 0xc6, 0xc7, 0xcd, 0xc6, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7,
	0xcd, 0xcd, 0xce, 0xc7, 0xcd, 0xce, 0xcd, 0xce, 0xce, 0xcd, 0xce, 0xcd, 0xfc, 0xce, 0x0d, 0xd4,
	0xce, 0xf0, 0xce, 0xce, 0xc7, 0xce, 0xcd, 0xce, 0xce, 0xcd, 0xce, 0xce, 0xcd, 0xfd, 0xce, 0x2a,
	0xef, 0xce, 0xce, 0xef, 0xce, 0xce, 0xf0, 0xce, 0xcf, 0xef, 0xce, 0xd5, 0xcf, 0xf0, 0xcf, 0xf0,
	0xcf, 0xd5, 0xd5, 0xc7, 0xcc, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xce, 0xc7, 0xcd,
	0xcd, 0xc8, 0xcd, 0xce, 0xc7, 0xce, 0xcd, 0xc8, 0xce, 0xce, 0xcd, 0xf9, 0xce, 0x04, 0xcd, 0xce,
	0xcd, 0xce, 0xcd, 0xf5, 0xce, 0x24, 0xcf, 0xef, 0xce, 0xcf, 0xef, 0xce, 0xcf, 0xf0, 0xce, 0xf0,
	0xcf, 0xf0, 0xcf, 0xf0, 0xcf, 0xc7, 0xc7, 0xcc, 0xc7, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7,
	0xcd, 0xc7, 0xce, 0xcd, 0xcd, 0xc8, 0xcd, 0xce, 0xcd, 0xce, 0xcd, 0xf9, 0xce, 0x0a, 0xef, 0xc8,
	0xcd, 0xce, 0xc7, 0xce, 0xcd, 0xce, 0xcd, 0xce, 0xcd, 0xfc, 0xce, 0x28, 0xef, 0xce, 0xce, 0xef,
	0xce, 0xcf, 0xce, 0xef, 0xcf, 0xef, 0xcf, 0xcf, 0xef, 0xcf, 0xf0, 0xcf, 0xf0, 0xd5, 0xcf, 0xcc,
	0xc7, 0xc7, 0xcc, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xcd, 0xc7, 0xcd, 0xc7, 0xce, 0xcd, 0xcd,
	0xce, 0xc7, 0xce, 0xce, 0xcd, 0x01, 0xce, 0xcd, 0xfb, 0xce, 0x08, 0xcd, 0xcd, 0xc8, 0xcd, 0xce,
	0xcd, 0xc8, 0xce, 0xcd, 0xfe, 0xce, 0x00, 0xcd, 0xfa, 0xce, 0x23, 0xef, 0xce, 0xcf, 0xce, 0xce,
	0xf0, 0xce, 0xf0, 0xcf, 0xef, 0xcf, 0xf0, 0xcf, 0xf0, 0xc6, 0xc7, 0xcc, 0xc7, 0xcd, 0xc6, 0xcd,
	0xc7, 0xcd, 0xc7, 0xcd, 0xcd, 0xc8, 0xcd, 0xcd, 0xc7, 0xce, 0xcd, 0xce, 0xcd, 0xce, 0xcd, 0xfe,
	0xce, 0x00, 0xcd, 0xfe, 0xce, 0x01, 0xc7, 0xce, 0xfe, 0xcd, 0x06, 0xc8, 0xcd, 0xce, 0xcd, 0xce,
	0xc8, 0xcd, 0xfa, 0xce, 0x24, 0xef, 0xce, 0xcf, 0xce, 0xef, 0xce, 0xf0, 0xcf, 0xce, 0xf0, 0xcf,
	0xce, 0xd5, 0xcf, 0xf0, 0xcf, 0xd5, 0xcc, 0xc7, 0xc7, 0xcc, 0xc7, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7,
	0xcd, 0xc7, 0xcd, 0xcd, 0xce, 0xc7, 0xcd, 0xc8, 0xcd, 0xce, 0x02, 0xc7, 0xce, 0xcd, 0xfc, 0xce,
	0x0c, 0xc7, 0xcd, 0xc7, 0xce, 0xc7, 0xcd, 0xce, 0xcd, 0xc8, 0xcd, 0xce, 0xce, 0xcd, 0xf6, 0xce,
	0x24, 0xcf, 0xce, 0xef, 0xcf, 0xce, 0xf0, 0xcf, 0xef, 0xcf, 0xf0, 0xcf, 0xf0, 0xc6, 0xc7, 0xcc,
	0xc7, 0xc7, 0xcd, 0xc6, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xce, 0xcd, 0xcd,
	0xc8, 0xcd, 0xce, 0xce, 0xcd, 0xce, 0xfe, 0xcd, 0x0e, 0xc7, 0xcd, 0xcd, 0xc7, 0xcd, 0xce, 0xc7,
	0xcd, 0xce, 0xcd, 0xce, 0xcd, 0xce, 0xce, 0xcd, 0xfb, 0xce, 0x21, 0xef, 0xce, 0xce, 0xef, 0xce,
	0xcf, 0xd4, 0xcf, 0xce, 0xf0, 0xcf, 0xef, 0xcf, 0xef, 0xcf, 0xf0, 0xc6, 0xc7, 0xcc, 0xc7, 0xcc,
	0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xcd, 0xc7, 0xce, 0xcd, 0xc7, 0xcd, 0xc8, 0x04, 0xcd, 0xce,
	0xcd, 0xce, 0xc7, 0xfe, 0xce, 0x0d, 0xc7, 0xcd, 0xc7, 0xcd, 0xce, 0xc7, 0xcd, 0xcd, 0xce, 0xc7,
	0xce, 0xcd, 0xce, 0xc7, 0xfe, 0xce, 0x00, 0xcd, 0xfa, 0xce, 0x24, 0xcf, 0xd4, 0xce, 0xce, 0xcf,
	0xef, 0xce, 0xcf, 0xef, 0xcf, 0xef, 0xcf, 0xf0, 0xcc, 0xc7, 0xc6, 0xc7, 0xc7, 0xcd, 0xc6, 0xc7,
	0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xcd, 0xc8, 0xcd, 0xcd, 0xce, 0xc7, 0xce, 0xcd, 0xce,
	0xfe, 0xcd, 0x0e, 0xc7, 0xcd, 0xc7, 0xcd, 0xcd, 0xc7, 0xce, 0xcd, 0xcd, 0xce, 0xc7, 0xce, 0xcd,
	0xce, 0xcd, 0xfb, 0xce, 0x00, 0xd4, 0xfd, 0xce, 0x19, 0xcf, 0xd4, 0xce, 0xcf, 0xef, 0xce, 0xf0,
	0xcf, 0xce, 0xd5, 0xcf, 0xf0, 0xc7, 0xcc, 0xc7, 0xcc, 0xc7, 0xc7, 0xcd, 0xc6, 0xcd, 0xc7, 0xcd,
	0xc7, 0xcd, 0xc7, 0xff, 0xcd, 0x1b, 0xcd, 0xc8, 0xcd, 0xcd, 0xce, 0xcd, 0xce, 0xc8, 0xc7, 0xc7,
	0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xce, 0xc7, 0xcd, 0xce, 0xcd, 0xce, 0xce, 0xcd,
	0xce, 0xcd, 0xfb, 0xce, 0x00, 0xef, 0xfe, 0xce, 0x0a, 0xf0, 0xce, 0xcf, 0xce, 0xf0, 0xcf, 0xef,
	0xcf, 0xef, 0xcf, 0xf0, 0xfc, 0xce, 0x0d, 0xef, 0xce, 0xcf, 0xd4, 0xcf, 0xef, 0xcf, 0xef, 0xcf,
	0xf0, 0xcf, 0xf0, 0xd5, 0xcf, 0xfe, 0xd5, 0x09, 0xf1, 0xcf, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xcd,
	0xc7, 0xce, 0xfe, 0xcd, 0x05, 0xce, 0xc7, 0xce, 0xcd, 0xc8, 0xcd, 0xfe, 0xce, 0x00, 0xcd, 0xfa,
	0xce, 0x0a, 0xf0, 0xce, 0xce, 0xf0, 0xce, 0xcf, 0xef, 0xce, 0xcf, 0xef, 0xcf, 0xfe, 0xce, 0x0b,
	0xd4, 0xce, 0xce, 0xcf, 0xce, 0xef, 0xce, 0xce, 0xcf, 0xd4, 0xcf, 0xce, 0x1c, 0xf0, 0xcf, 0xf0,
	0xcf, 0xf0, 0xcf, 0xd5, 0xcf, 0xd5, 0xf1, 0xc7, 0xcc, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7,
	0xcd, 0xc8, 0xcd, 0xcd, 0xce, 0xcd, 0xce, 0xcd, 0xce, 0xcd, 0xf7, 0xce, 0x09, 0xcf, 0xce, 0xce,
	0xf0, 0xce, 0xcf, 0xef, 0xcf, 0xef, 0xcf, 0xfb, 0xce, 0x28, 0xef, 0xce, 0xce, 0xcf, 0xef, 0xce,
	0xcf, 0xef, 0xcf, 0xef, 0xcf, 0xef, 0xcf, 0xf0, 0xcf, 0xf0, 0xcf, 0xd5, 0xf1, 0xcf, 0xcd, 0xc7,
	0xcc, 0xc7, 0xcd, 0xc7, 0xcd, 0xcd, 0xc7, 0xcd, 0xcd, 0xc8, 0xcd, 0xc7, 0xce, 0xcd, 0xc8, 0xce,
	0xcd, 0xce, 0xcd, 0xfd, 0xce, 0x0c, 0xd4, 0xce, 0xce, 0xef, 0xce, 0xce, 0xcf, 0xef, 0xce, 0xcf,
	0xd4, 0xcf, 0xcd, 0xf8, 0xce, 0x04, 0xef, 0xce, 0xcf, 0xd4, 0xce, 0x1e, 0xcf, 0xef, 0xce, 0xd5,
	0xcf, 0xef, 0xcf, 0xf0, 0xd5, 0xcf, 0xcf, 0xd5, 0xcd, 0xc6, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd,
	0xc7, 0xce, 0xc7, 0xcd, 0xcd, 0xce, 0xcd, 0xc8, 0xcd, 0xce, 0xcd, 0xfe, 0xce, 0x00, 0xcd, 0xfa,
	0xce, 0x06, 0xef, 0xce, 0xce, 0xcf, 0xd4, 0xce, 0xcf, 0xfe, 0xce, 0x00, 0xcd, 0xfe, 0xce, 0x10,
	0xef, 0xce, 0xce, 0xcf, 0xce, 0xce, 0xcf, 0xef, 0xce, 0xcf, 0xef, 0xcf, 0xce, 0xd5, 0xcf, 0xf0,
	0xcf, 0xfe, 0xd5, 0x07, 0xcf, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xfe, 0xcd, 0x09, 0xc7,
	0xce, 0xc7, 0xcd, 0xce, 0xcd, 0xce, 0xc7, 0xce, 0xcd, 0xf7, 0xce, 0x08, 0xcf, 0xd4, 0xce, 0xcf,
	0xce, 0xcd, 0xc8, 0xce, 0xcd, 0xfa, 0xce, 0x03, 0xef, 0xce, 0xef, 0xce, 0x24, 0xce, 0xf0, 0xce,
	0xcf, 0xef, 0xcf, 0xef, 0xcf, 0xf0, 0xcf, 0xf0, 0xd5, 0xd5, 0xcf, 0xcd, 0xc6, 0xc7, 0xcd, 0xc6,
	0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xcd, 0xce, 0xc7, 0xcd, 0xce, 0xcd, 0xce, 0xce, 0xcd,
	0xce, 0xcd, 0xfc, 0xce, 0x00, 0xd4, 0xfd, 0xce, 0x04, 0xf0, 0xce, 0xc7, 0xce, 0xcd, 0xf6, 0xce,
	0x27, 0xcf, 0xce, 0xcf, 0xef, 0xce, 0xcf, 0xef, 0xcf, 0xef, 0xcf, 0xef, 0xcf, 0xcf, 0xd5, 0xd5,
	0xcf, 0xc7, 0xcc, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xce, 0xc7, 0xcd, 0xcd, 0xc8,
	0xcd, 0xce, 0xc7, 0xce, 0xcd, 0xc8, 0xce, 0xce, 0xcd, 0xfb, 0xce, 0x0b, 0xf0, 0xce, 0xce, 0xc7,
	0xce, 0xcd, 0xce, 0xce, 0xcd, 0xce, 0xce, 0xcd, 0xfd, 0xce, 0x01, 0xef, 0xce, 0x25, 0xce, 0xef,
	0xce, 0xce, 0xf0, 0xce, 0xcf, 0xef, 0xce, 0xd5, 0xcf, 0xf0, 0xcf, 0xf0, 0xcf, 0xd5, 0xc7, 0xc7,
	0xcc, 0xc7, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xce, 0xcd, 0xcd, 0xc8, 0xcd,
	0xce, 0xcd, 0xce, 0xcd, 0xf6, 0xce, 0x04, 0xcd, 0xce, 0xcd, 0xce, 0xcd, 0xf5, 0xce, 0x26, 0xcf,
	0xef, 0xce, 0xcf, 0xef, 0xce, 0xcf, 0xf0, 0xce, 0xf0, 0xcf, 0xf0, 0xd5, 0xcf, 0xd5, 0xcc, 0xc7,
	0xc7, 0xcc, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xcd, 0xc7, 0xcd, 0xc7, 0xce, 0xcd, 0xcd, 0xce,
	0xc7, 0xce, 0xce, 0xcd, 0xce, 0xcd, 0xfb, 0xce, 0x0a, 0xef, 0xc8, 0xcd, 0xce, 0xc7, 0xce, 0xcd,
	0xce, 0xcd, 0xce, 0xcd, 0xfc, 0xce, 0x27, 0xef, 0xce, 0xce, 0xef, 0xce, 0xcf, 0xce, 0xef, 0xcf,
	0xef, 0xcf, 0xcf, 0xef, 0xcf, 0xf0, 0xcf, 0xf0, 0xcf, 0xc6, 0xc7, 0xcc, 0xc7, 0xcd, 0xc6, 0xcd,
	0xc7, 0xcd, 0xc7, 0xcd, 0xcd, 0xc8, 0xcd, 0xcd, 0xc7, 0xce, 0xcd, 0xce, 0xcd, 0xce, 0xcd, 0xfe,
	0xce, 0x00, 0xcd, 0xfc, 0xce, 0x08, 0xcd, 0xcd, 0xc8, 0xcd, 0xce, 0xcd, 0xc8, 0xce, 0xcd, 0xfe,
	0xce, 0x00, 0xcd, 0xfa, 0xce, 0x24, 0xef, 0xce, 0xcf, 0xce, 0xce, 0xf0, 0xce, 0xf0, 0xd5, 0xcf,
	0xf0, 0xcf, 0xd5, 0xcf, 0xcc, 0xc7, 0xc7, 0xcc, 0xc7, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7,
	0xcd, 0xcd, 0xce, 0xc7, 0xcd, 0xc8, 0xcd, 0xce, 0xc7, 0xce, 0xcd, 0xfb, 0xce, 0x01, 0xc7, 0xce,
	0xfe, 0xcd, 0x06, 0xc8, 0xcd, 0xce, 0xcd, 0xce, 0xc8, 0xcd, 0xfe, 0xce, 0xfd, 0xce, 0x29, 0xef,
	0xce, 0xcf, 0xce, 0xef, 0xce, 0xf0, 0xcf, 0xce, 0xf0, 0xef, 0xcf, 0xf0, 0xcf, 0xf0, 0xd5, 0xc6,
	0xc7, 0xcc, 0xc7, 0xc7, 0xcd, 0xc6, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xce,
	0xcd, 0xcd, 0xc8, 0xcd, 0xce, 0xce, 0xcd, 0xce, 0xcd, 0xfe, 0xce, 0x0c, 0xc7, 0xcd, 0xc7, 0xce,
	0xc7, 0xcd, 0xce, 0xcd, 0xc8, 0xcd, 0xce, 0xce, 0xcd, 0xf6, 0xce, 0x22, 0xcf, 0xce, 0xef, 0xcf,
	0xce, 0xcf, 0xef, 0xcf, 0xef, 0xcf, 0xf0, 0xcf, 0xc6, 0xc7, 0xcc, 0xc7, 0xcc, 0xc7, 0xcd, 0xc7,
	0xcd, 0xc7, 0xcd, 0xcd, 0xc7, 0xce, 0xcd, 0xc7, 0xcd, 0xc8, 0xcd, 0xce, 0xcd, 0xce, 0xc7, 0xfe,
	0xce, 0x0f, 0xcd, 0xcd, 0xc7, 0xcd, 0xcd, 0xc7, 0xcd, 0xce, 0xc7, 0xcd, 0xce, 0xcd, 0xce, 0xcd,
	0xce, 0xce, 0x00, 0xcd, 0xfb, 0xce, 0x37, 0xef, 0xce, 0xce, 0xef, 0xce, 0xcf, 0xd4, 0xcf, 0xcf,
	0xef, 0xcf, 0xef, 0xcf, 0xf0, 0xd5, 0xcc, 0xc7, 0xc6, 0xc7, 0xc7, 0xcd, 0xc6, 0xc7, 0xcd, 0xc7,
	0xcd, 0xc7, 0xcd, 0xc7, 0xcd, 0xcd, 0xc8, 0xcd, 0xcd, 0xce, 0xc7, 0xce, 0xcd, 0xce, 0xcd, 0xce,
	0xce, 0xc7, 0xcd, 0xc7, 0xcd, 0xce, 0xc7, 0xcd, 0xcd, 0xce, 0xc7, 0xce, 0xcd, 0xce, 0xc7, 0xfe,
	0xce, 0x00, 0xcd, 0xfa, 0xce, 0x1a, 0xcf, 0xd4, 0xce, 0xce, 0xcf, 0xce, 0xf0, 0xcf, 0xce, 0xd5,
	0xcf, 0xf0, 0xcf, 0xc7, 0xcc, 0xc7, 0xcc, 0xc7, 0xc7, 0xcd, 0xc6, 0xcd, 0xc7, 0xcd, 0xc7, 0xcd,
	0xc7, 0xfe, 0xcd, 0x06, 0xc8, 0xcd, 0xcd, 0xce, 0xcd, 0xce, 0xc8, 0xfe, 0xcd, 0x0c, 0xc7, 0xcd,
	0xc7, 0xcd, 0xcd, 0xc7, 0xce, 0xcd, 0xcd, 0xce, 0xc7, 0xce, 0xcd, 0x01, 0xce, 0xcd, 0xfb, 0xce,
	0x00, 0xd4, 0xfd, 0xce, 0x02, 0xcf, 0xd4, 0xce
};

static const byte tile2[] = {
	0xdb, 0xdb, 0xdb, 0x6b, 0x6b, 0xda, 0xda, 0xd9, 0xd9, 0xd9, 0x47, 0x47, 0xd8, 0xd8, 0xd7, 0xd7,
	0xdc, 0xdb, 0xdb, 0xdb, 0x6b, 0x6b, 0xda, 0xda, 0xda, 0xd9, 0xd9, 0x47, 0x47, 0xd8, 0xd8, 0xd8,
	0xdc, 0xdc, 0xdb, 0xdb, 0xdb, 0x6b, 0x6b, 0xda, 0xda, 0xd9, 0xd9, 0xd9, 0x47, 0x47, 0xd8, 0xd8,
	0xdc, 0xdc, 0xdc, 0xdb, 0xdb, 0xdb, 0x6b, 0x6b, 0xda, 0xda, 0xda, 0xd9, 0x47, 0x47, 0x47, 0xd8,
	0x8f, 0xdc, 0xdc, 0xdc, 0xdb, 0xdb, 0x6b, 0x6b, 0xda, 0xda, 0xda, 0xd9, 0xd9, 0x47, 0x47, 0x47,
	0x8f, 0x8f, 0x8f, 0xdc, 0xdc, 0xdb, 0xdb, 0x6b, 0x6b, 0x6b, 0xda, 0xda, 0xd9, 0xd9, 0xd9, 0x47,
	0xdd, 0x8f, 0x8f, 0xdc, 0xdc, 0xdc, 0xdb, 0xdb, 0x6b, 0x6b, 0x6b, 0xda, 0xd9, 0xd9, 0xd9, 0x47,
	0xdd, 0xdd, 0x8f, 0x8f, 0xdc, 0xdc, 0xdb, 0xdb, 0xdb, 0x6b, 0x6b, 0xda, 0xda, 0xda, 0xd9, 0xd9,
	0xdd, 0xdd, 0x8f, 0x8f, 0x8f, 0xdc, 0xdc, 0xdb, 0xdb, 0xdb, 0x6b, 0x6b, 0xda, 0xda, 0xd9, 0xd9,
	0xde, 0xdd, 0xdd, 0xdd, 0x8f, 0x8f, 0xdc, 0xdc, 0xdb, 0xdb, 0xdb, 0x6b, 0xda, 0xda, 0xda, 0xda,
	0xde, 0xde, 0xdd, 0xdd, 0x8f, 0x8f, 0xdc, 0xdc, 0xdc, 0xdb, 0xdb, 0x6b, 0x6b, 0x6b, 0xda, 0xda,
	0xde, 0xde, 0xdd, 0xdd, 0xdd, 0xdd, 0x8f, 0xdc, 0xdc, 0xdc, 0xdb, 0xdb, 0x6b, 0x6b, 0x6b, 0xda,
	0xb3, 0xde, 0xde, 0xde, 0xdd, 0xdd, 0x8f, 0x8f, 0xdc, 0xdc, 0xdc, 0xdb, 0xdb, 0x6b, 0x6b, 0xda,
	0xb3, 0xb3, 0xde, 0xde, 0xde, 0xdd, 0x8f, 0x8f, 0x8f, 0x8f, 0xdc, 0xdb, 0xdb, 0xdb, 0x6b, 0x6b,
	0xdf, 0xb3, 0xb3, 0xde, 0xde, 0xdd, 0xdd, 0xdd, 0x8f, 0x8f, 0xdc, 0xdc, 0xdb, 0xdb, 0xdb, 0x6b,
	0xdf, 0xdf, 0xb3, 0xde, 0xde, 0xde, 0xdd, 0xdd, 0x8f, 0x8f, 0x8f, 0xdc, 0xdc, 0xdb, 0xdb, 0xdb
};

static const byte tile3[] = {
	0x00, 0xf6, 0xf2, 0xfd, 0x01, 0xf6, 0xf6, 0xf5, 0xfd, 0x03, 0xfc, 0xfd, 0xf6, 0xf6, 0xf5, 0xf9,
	0x03, 0xfc, 0xfc, 0xf6, 0xf6, 0xf5, 0xf9, 0x03, 0xfc, 0xfc, 0xf6, 0xf6, 0xf5, 0xf9, 0x03, 0xfc,
	0xfc, 0xf6, 0xf6, 0xf5, 0xf9, 0x03, 0xfc, 0xfc, 0xf6, 0xf6, 0xf5, 0xf9, 0x03, 0xfc, 0xfc, 0xf6,
	0xf6, 0xf5, 0xf9, 0x00, 0xfc, 0x02, 0xfc, 0xf6, 0xf6, 0xf5, 0xf9, 0x03, 0xfc, 0xfc, 0xf6, 0xf6,
	0xf5, 0xf9, 0x03, 0xfc, 0xfc, 0xf6, 0xf6, 0xf5, 0xf9, 0x03, 0xfc, 0xfc, 0xf6, 0xf6, 0xf5, 0xf9,
	0x03, 0xfc, 0xfc, 0xf6, 0xf6, 0xf5, 0xf9, 0x03, 0xfc, 0xfc, 0xf6, 0xf6, 0xf5, 0xf9, 0x03, 0xfc,
	0xfc, 0xf6, 0xf6, 0xf5, 0xf7, 0x02, 0xfc, 0xfc, 0xf6, 0xf4, 0xf7, 0x01, 0xf7, 0xfc
};

static const byte tile4[] = {
	0x2b, 0x07, 0x2c, 0xf7, 0x07, 0x2c, 0x25, 0x07, 0xf6, 0xf6, 0x01, 0xf6, 0xf5, 0x01, 0xf5, 0xf6,
	0xf7, 0x2c, 0x07, 0x2c, 0x2c, 0x31, 0xf6, 0xf6, 0xf5, 0x07, 0xf5, 0xf6, 0xf5, 0xf6, 0x01, 0xf5,
	0x2b, 0x08, 0xf7, 0xf7, 0x08, 0x2c, 0x25, 0x07, 0xf5, 0x01, 0xf6, 0xf5, 0x01, 0xf5, 0x06, 0xf5,
	0x07, 0x2c, 0xf7, 0x08, 0x31, 0x2c, 0x07, 0xf5, 0x07, 0xf6, 0xf5, 0xf6, 0x01, 0xf5, 0xf5, 0x01,
	0xf7, 0x08, 0x31, 0x2c, 0x2c, 0x2c, 0xf5, 0x01, 0xf6, 0xf5, 0xf5, 0x01, 0xf5, 0x06, 0xf5, 0xf5,
	0x2b, 0xf7, 0x2b, 0xf6, 0x2b, 0x2b, 0x33, 0xfb, 0x57, 0x82, 0x57, 0xfb, 0x57, 0xfa, 0x57, 0xfa,
	0xf7, 0xf7, 0xf7, 0xf7, 0x2b, 0xf6, 0x58, 0x5d, 0xfa, 0x5d, 0xfa, 0x57, 0xfa, 0x57, 0xfb, 0x57,
	0xf7, 0x2b, 0xf7, 0x2b, 0xf6, 0xf7, 0x5d, 0xfa, 0x57, 0xfa, 0x57, 0xfb, 0x57, 0xfa, 0x57, 0xfa,
	0x2b, 0xf6, 0x2b, 0xf6, 0xf6, 0x2b, 0x33, 0xfa, 0x5d, 0xfa, 0x57, 0xfa, 0x57, 0xfa, 0x57, 0xf9,
	0x2b, 0xf6, 0xf7, 0x2b, 0xf6, 0xf6, 0x57, 0x5d, 0xfa, 0x57, 0xfb, 0x57, 0xfa, 0x5d, 0xf9, 0xfa,
	0x2b, 0xf6, 0x2b, 0xf6, 0xf6, 0x2b, 0x5d, 0x57, 0xfa, 0x57, 0xfa, 0x57, 0x57, 0xf9, 0x57, 0x57,
	0xf6, 0xf5, 0xf6, 0x01, 0xf5, 0x06, 0xfa, 0x57, 0xfa, 0x5d, 0x57, 0xfa, 0x32, 0x33, 0x57, 0x32,
	0xf6, 0x01, 0xf5, 0xf5, 0xf6, 0xf5, 0xfa, 0x57, 0xfa, 0x57, 0xfa, 0xf9, 0x57, 0x33, 0x32, 0x57,
	0xf6, 0xf5, 0x07, 0xf5, 0xf5, 0xf5, 0xfa, 0x5d, 0x57, 0xfa, 0xf9, 0x57, 0x33, 0x57, 0x32, 0x33,
	0x01, 0xf5, 0xf5, 0xf5, 0xf5, 0xf5, 0xfa, 0x57, 0xfa, 0xf9, 0x57, 0xfa, 0x32, 0x33, 0x56, 0x33,
	0xf5, 0xf5, 0xf5, 0x01, 0x00, 0x01, 0x57, 0xf9, 0xfa, 0x57, 0xfa, 0xf9, 0x33, 0xf9, 0x33, 0x32
};

static const byte tile5[] = {
	0xed, 0xfb, 0xf4, 0xfd, 0xfd, 0xfb, 0xf4, 0xfd, 0xfd, 0xfb, 0xf7, 0xfd, 0xfe, 0xff, 0xfd, 0xfb,
	0xf4, 0xff, 0xfd, 0xfb, 0xf4, 0xff, 0xfd, 0xfb, 0xfa, 0xff, 0x01, 0xfd, 0xfd, 0xfd, 0xff, 0xfd,
	0xfb, 0xfc, 0xfd, 0xfd, 0xfd, 0xfd, 0xff, 0xfd, 0xfb, 0xf8, 0xfd, 0xfd, 0xff, 0xfd, 0xfb, 0xf8,
	0xfd, 0xfd, 0xff, 0xfd, 0xfb, 0xf8, 0xfd, 0xfd, 0xff, 0xfd, 0xfb, 0xf8, 0xfd, 0xfd, 0xff, 0xfd,
	0xfb, 0xf8, 0xfd, 0xfd, 0xff, 0xfc, 0xfb, 0xf9, 0xfd, 0xfd, 0xff, 0xfc, 0xfb, 0xf9, 0xfd, 0xfd,
	0xff, 0x01, 0xfb, 0xfb
};

static const byte tile6[] = {
	0x2f, 0x11, 0x0b, 0x2f, 0x0b, 0x0b, 0x35, 0x0b, 0x2f, 0x11, 0x2f, 0x0b, 0x35, 0x0b, 0x35, 0x0b,
	0x0b, 0x2f, 0x0b, 0x2f, 0x11, 0x2f, 0x0b, 0x0b, 0x35, 0x0b, 0x0b, 0x35, 0x0b, 0x2f, 0x11, 0x2f,
	0x0b, 0x2f, 0x11, 0x0b, 0x2f, 0x0b, 0x0b, 0x35, 0x0b, 0x2f, 0x0b, 0x35, 0x0b, 0x35, 0x0b, 0x2f,
	0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x0b, 0x35, 0x0b, 0x2f, 0x0b, 0x11, 0x2f, 0x0b, 0x2f, 0x11, 0x0b,
	0x0b, 0x0b, 0x2f, 0x0b, 0x11, 0x2f, 0x0b, 0x0b, 0x2f, 0x11, 0x2f, 0x0b, 0x35, 0x0b, 0x35, 0x0b,
	0x2f, 0x0b, 0x2f, 0x0b, 0x2f, 0x0b, 0x2f, 0x0b, 0x11, 0x2f, 0x0b, 0x0b, 0x35, 0x0b, 0x0b, 0x35,
	0x2f, 0x0b, 0x0b, 0x0b, 0x35, 0x0b, 0x0b, 0x2f, 0x0b, 0x2f, 0x11, 0x2f, 0x0b, 0x2f, 0x11, 0x2f,
	0x0b, 0x2f, 0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x11, 0x0b, 0x2f, 0x0b, 0x0b, 0x35, 0x0b, 0x2f, 0x11,
	0x2f, 0x0b, 0x0b, 0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x0b, 0x2f, 0x11, 0x2f, 0x0b, 0x0b, 0x35, 0x0b,
	0x0b, 0x2f, 0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x0b, 0x11, 0x2f, 0x0b, 0x0b, 0x35, 0x0b, 0x2f, 0x11,
	0x2f, 0x0b, 0x0b, 0x0b, 0x2f, 0x0b, 0x2f, 0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x0b, 0x2f, 0x11, 0x2f,
	0x2f, 0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x0b, 0x0b, 0x11, 0x2f, 0x0b, 0x35, 0x0b, 0x0b, 0x2f, 0x0b,
	0x05, 0x0b, 0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x0b, 0x35, 0x0b, 0x35,
	0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x11, 0x0b, 0x2f, 0x0b, 0x0b,
	0x0b, 0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x0b, 0x2f, 0x11, 0x2f,
	0x29, 0x0b, 0x0b, 0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x0b, 0x0b, 0x2f, 0x0b, 0x11, 0x2f, 0x0b, 0x0b
};

static const byte tile7[] = {
	0x07, 0xf6, 0x00, 0xf5, 0xf6, 0xf5, 0x2b, 0xf7, 0xf6, 0xfe, 0xf5, 0x03, 0x00, 0xf5, 0xf5, 0x00,
	0xfd, 0xf5, 0x0a, 0xf6, 0xf5, 0x2b, 0xf7, 0xf6, 0xf6, 0xf5, 0x00, 0xf5, 0xf5, 0x00, 0xfc, 0xf5,
	0x05, 0xf6, 0x2b, 0xf6, 0xf5, 0xf5, 0x00, 0xfd, 0xf5, 0xfe, 0x00, 0x02, 0x2b, 0xf5, 0x00, 0xfe,
	0xf5, 0xfd, 0x00, 0xfe, 0xf5, 0x07, 0x00, 0x00, 0xf5, 0xf7, 0xf6, 0x00, 0xf5, 0xf5, 0xfc, 0x00,
	0xfe, 0xf5, 0x01, 0x00, 0x00, 0xfb, 0xf5, 0xfe, 0x00, 0x08, 0xf5, 0xf5, 0x00, 0xf5, 0xf5, 0x00,
	0xf5, 0x00, 0xf6, 0xfd, 0xf5, 0x04, 0x00, 0x00, 0xf6, 0x00, 0xf5, 0xfe, 0x00, 0xfe, 0xf5, 0x07,
	0xf6, 0xf5, 0xf5, 0x00, 0xf5, 0x00, 0x00, 0xf6, 0xfd, 0x00, 0x02, 0xf5, 0xf6, 0xf5, 0x03, 0xf5,
	0xf6, 0xf5, 0xf5, 0xfe, 0x00, 0x07, 0xf5, 0xf6, 0xf6, 0x00, 0xf5, 0x00, 0xf6, 0xf6, 0xfe, 0xf5,
	0xfc, 0x00, 0x00, 0xf5, 0xfe, 0x00, 0x05, 0xf5, 0xf5, 0x00, 0xf6, 0xf5, 0xf5, 0xf6, 0x00, 0x01,
	0xf5, 0xf5, 0xfe, 0xf6, 0xf3, 0x00, 0x02, 0xf5, 0x00, 0xf5, 0xfd, 0x00, 0x0d, 0xf5, 0x00, 0xf5,
	0x00, 0x00, 0xf5, 0xf6, 0xf5, 0xf5, 0x00, 0x00, 0xf5, 0x00, 0xf6, 0xfe, 0xf5, 0xfd, 0xf6, 0x00,
	0xf5, 0xfd, 0x00, 0x08, 0xf5, 0xf5, 0xf6, 0xf7, 0xf6, 0xf5, 0xf5, 0xf6, 0xf6, 0xfe, 0x00, 0x02,
	0xf6, 0xf5, 0xf5, 0xfe, 0x00, 0x05, 0xf6, 0x2b, 0xf6, 0xf5, 0xf5, 0xf6, 0xfd, 0x00, 0x02, 0xf5,
	0xf5, 0x00, 0xff, 0x00, 0xf5
};

static const byte tile8[] = {
	0xfd, 0xfc, 0xac, 0xff, 0xfd, 0xfc, 0xff, 0x56, 0xfc, 0xfd, 0xac, 0xfd, 0xfd, 0xfb, 0xfb, 0xfc,
	0xac, 0x81, 0xfd, 0xfe, 0xfe, 0xfe, 0xfe, 0xf8, 0xac, 0xfc, 0xfc, 0xfc, 0xff, 0xfc, 0xfb, 0xac,
	0x81, 0xfb, 0xfd, 0xfe, 0xfe, 0xff, 0xfe, 0x56, 0x81, 0xfb, 0xfb, 0xfc, 0xfe, 0xfd, 0xfe, 0xfd,
	0xfb, 0x56, 0xfd, 0xfd, 0xfe, 0xfd, 0xff, 0xf7, 0x81, 0xf9, 0xfb, 0xfc, 0xff, 0xac, 0xff, 0xfe,
	0xac, 0x56, 0xfd, 0xfe, 0xfc, 0xac, 0xff, 0xfb, 0xfb, 0xfa, 0xf9, 0xfd, 0xfe, 0xfc, 0xfd, 0xfe,
	0xfd, 0xf8, 0xfc, 0xac, 0x81, 0xac, 0xfe, 0xfe, 0xfe, 0x56, 0xfa, 0xfe, 0xac, 0xfb, 0xfd, 0xfe,
	0xfe, 0xf8, 0x81, 0x81, 0x81, 0xac, 0xff, 0xfd, 0xff, 0xfa, 0xf9, 0xac, 0xac, 0xfa, 0xfe, 0xfd,
	0xac, 0x81, 0xfa, 0xfa, 0xfa, 0xfc, 0xfe, 0xfd, 0xfe, 0x81, 0xf7, 0xfc, 0xfb, 0xf9, 0xfe, 0xff,
	0xfd, 0xfc, 0xfd, 0xfa, 0x56, 0xfe, 0xfd, 0xfb, 0xff, 0xac, 0x81, 0xfc, 0xfc, 0xf9, 0xff, 0xfc,
	0xfe, 0xfd, 0xff, 0xfb, 0xf9, 0xff, 0xfc, 0xfb, 0xfd, 0xfe, 0xfd, 0xff, 0xfb, 0x56, 0xfd, 0x81,
	0xfd, 0xfd, 0xfe, 0xac, 0xf9, 0xfc, 0xfa, 0x81, 0xfd, 0xfd, 0xff, 0xfe, 0xac, 0x56, 0xfc, 0xfa,
	0xfe, 0xac, 0xff, 0xfc, 0x56, 0xfd, 0x56, 0xfc, 0xfe, 0xfd, 0xfd, 0xfd, 0xfd, 0xf8, 0xfb, 0xfa,
	0xac, 0xac, 0xfe, 0xfc, 0x56, 0xfd, 0x81, 0x81, 0xfd, 0xac, 0xfe, 0xfe, 0xac, 0x56, 0xfd, 0x56,
	0xac, 0xfb, 0xfd, 0xfd, 0xac, 0xfe, 0xfa, 0xf9, 0xfe, 0xfc, 0xfb, 0xac, 0xfe, 0xfc, 0xff, 0x56,
	0xfc, 0xfc, 0xfe, 0xfe, 0xff, 0xac, 0xfc, 0xf9, 0xfe, 0x81, 0xfc, 0xfd, 0xff, 0xfd, 0xff, 0xf9,
	0xff, 0xfd, 0xfe, 0xfd, 0xff, 0xff, 0xfb, 0xfa, 0xac, 0xfd, 0xfd, 0xac, 0xff, 0xff, 0xfb, 0x81
};

struct TileStruct {
	int w, h;
	const byte *ptr;
	uint size;
} static const builtinTiles[kNumBuiltinTiles] = {
	{ 64, 32, tile1, ARRAYSIZE(tile1) },
	{ 16, 16, tile2, ARRAYSIZE(tile2) },
	{ 16, 16, tile3, ARRAYSIZE(tile3) },
	{ 16, 16, tile4, ARRAYSIZE(tile4) },
	{ 16, 16, tile5, ARRAYSIZE(tile5) },
	{ 16, 16, tile6, ARRAYSIZE(tile6) },
	{ 16, 16, tile7, ARRAYSIZE(tile7) },
	{ 16, 16, tile8, ARRAYSIZE(tile8) },
};
