/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.hadoop.fs.swift.exceptions.SwiftJsonMarshallingException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.type.TypeReference;

public class JSONUtil {
    private static ObjectMapper jsonMapper = new ObjectMapper();

    private JSONUtil() {
    }

    public static String toJSON(Object object) throws IOException {
        StringWriter json = new StringWriter();
        try {
            jsonMapper.writeValue((Writer)json, object);
            return ((Object)json).toString();
        }
        catch (JsonGenerationException e) {
            throw new SwiftJsonMarshallingException(e.toString(), e);
        }
        catch (JsonMappingException e) {
            throw new SwiftJsonMarshallingException(e.toString(), e);
        }
    }

    public static <T> T toObject(String value, Class<T> klazz) throws IOException {
        try {
            return (T)jsonMapper.readValue(value, klazz);
        }
        catch (JsonGenerationException e) {
            throw new SwiftJsonMarshallingException(e.toString() + " source: " + value, e);
        }
        catch (JsonMappingException e) {
            throw new SwiftJsonMarshallingException(e.toString() + " source: " + value, e);
        }
    }

    public static <T> T toObject(String value, TypeReference<T> typeReference) throws IOException {
        try {
            return (T)jsonMapper.readValue(value, typeReference);
        }
        catch (JsonGenerationException e) {
            throw new SwiftJsonMarshallingException("Error generating response", e);
        }
        catch (JsonMappingException e) {
            throw new SwiftJsonMarshallingException("Error generating response", e);
        }
    }

    public static <T> T toObject(String value, CollectionType collectionType) throws IOException {
        try {
            return (T)jsonMapper.readValue(value, (JavaType)collectionType);
        }
        catch (JsonGenerationException e) {
            throw new SwiftJsonMarshallingException(e.toString() + " source: " + value, e);
        }
        catch (JsonMappingException e) {
            throw new SwiftJsonMarshallingException(e.toString() + " source: " + value, e);
        }
    }

    public static ObjectMapper getJsonMapper() {
        return jsonMapper;
    }
}

