ITK Release 4.3
===============

The Insight Software Consortium is happy to announce the release of ITK
4.3.0!

The 4.3.0 release is a major milestone that marks the hard work on many
outstanding community members.

We are excited to announce that experimental DICOM image reading is
available via the DCMTK library as a backend in addition to the GDCM
library. By default, DCMTK ImageIO support is not enabled. To try DCMTK
ImageIO support, turn the CMake option Module\_ITKIODCMTK ON. For Unix
platforms, the supporting DCMTK library will automatically be built as a
CMake ExternalProject. On Windows, the DCMTK library must be built
independently of the ITK build system. Then, specify the location to the
external build after setting the CMake option ITK\_USE\_SYSTEM\_DCMTK
ON.

WrapITK has undergone extensive improvements and bug fixes.

A number of registration-related feature enhancements were added. The
image registration methods have been updated to accommodate multiple
image metrics within a single optimization scheme. This permits, for
example, registration of a T1/T2 fixed image pair with a T1/T2 moving
image pair using a single metric for both T1 and T2 gradients or even
using two different metrics. New exponential transforms are available
along with automated B-Spline transform scale estimation. A new
physics-based non-rigid registration class is also available.

Updated third-party library versions include:

-   NrrdIO from Teem 1.11,
-   libtiff 4.03,
-   FFTW 3.3.2

A large number of important bugs were crushed, including fixes to the
ObjectFactoryBase, Patch-Based Denoising improvements, support for a
system libtiff, mesh processing, and FFTW use.

Support for itk::VectorImage’s was added to many algorithms, and a
single templated Adaptor class can now be applied without modification
to both itk::VectorImage’s and itk::Image’s of itk::Vector’s,
itk::RGBPixel’s, etc.

An extensive amount of code cruft was removed and coding style was made
more consistent; ITK gets more stylish and classy with every release!

Performance optimizations were achieved by removing GetInput/GetOutput
calls within filter inner loops, improving memory alignment, memory
access pattern optimizations, and parallelization through threading.

NOTE: As previously scheduled, Visual Studio 2005 will no longer be
supported after this release.

Andreas Schuh (1):

`     DOC: Modify BSplineDeformableTransform comments.`

Andriy Kot (1):

`     ENH: Main filter for A2D2 PBNRR.`

Arnaud Gelas (10):

`     PERF: couple of performance improvements useful for mesh processing`\
`     PERF: Minor performance improvement in KernelTransform`\
`     BUG: Fix errors on MS Visual`\
`     COMP: missing includes in itkVectorImageToImageMetricTraitsv4.h`\
`     ENH: Add tests for iterator indices`\
`     COMP: fix doxgen warnings`\
`     COMP: fix warning about uninitialized value`\
`     COMP: Fix compilation error (missing include).`\
`     COMP: fix clang warning about unused parameter`\
`     STYLE: Make CopyMeshToMesh a function just like the other Copy Container ones.`

Baohua Wu (2):

`     BUG: fixed a few bugs related to GPU Demons`\
`     ENH: added suport for buffered region in GPU image`

Bill Lorensen (11):

`     COMP: Macro definition of None in X11 breaks enum`\
`     BUG: ThirdParty should not depend on ITK`\
`     ENH: Utility to find modules needed by an ITK app`\
`     COMP: Incorrect test signature`\
`     BUG: GDCMImageIO ignores ImagePositionPatient`\
`     STYLE: Fix according to KWstyle`\
`     BUG: DCMTKImageIOFactory has wrong class name`\
`     COMP: Remove DCMTK from default modules`\
`     COMP: add set methods for member variables where missing.`\
`     BUG: Cannot read a 2 channel (gray, alpha) png file correctly`\
`     COMP: Revert recent change to iterator that fails to compile`

Brad King (11):

`     MetaIO: Avoid NULL dereference in MetaOutput::GetUsername`\
`     KWSys: Fix SystemInformation declaration order`\
`     ENH: Allow ITK modules to export custom information`\
`     ENH: ExternalData: Fix typo in unknown action error message`\
`     COMP: Make module header tests depend on module libraries`\
`     COMP: Make module header tests depend on module libraries`\
`     STYLE: Replace write_file() with file(WRITE) and file(APPEND)`\
`     STYLE: Replace make_directory() with file(MAKE_DIRECTORY)`\
`     STYLE: Replace install_(files|programs|targets) with install command`\
`     STYLE: Replace remove() with list(REMOVE_ITEM)`\
`     STYLE: Remove unsed vxl source directory`

Bradley Lowekamp (47):

`     COMP: fixing error when instatiated with image of double`\
`     COMP: fixing error when instatiated with image of double`\
`     PERF: remove per sample allocation, use per-thread structure`\
`     BUG: prevent static initialization fiasco during factory registration`\
`     PERF: Avoid memcpy call per component for Nift`\
`     BUG: Correct for divide by zero when first bin has zero frequency`\
`     PERF: add alignment data attribute to per-thread structure`\
`     BUG: fix writing a corrupt meta image header from unknow metadata`\
`     PERF: remove per sample allocation, use per-thread structure`\
`     BUG: prevent static initialization fiasco during factory registration`\
`     BUG: fix writing a corrupt meta image header from unknow metadata`\
`     BUG: fix for overlay functor for llvm optimization bug`\
`     ENH: adding support for VectorImage output in LabelMapCountorOverlay`\
`     BUG: Fix segfault when no inital means were set.`\
`     BUG: verify sigma is a positive number for Recursive Gaussian`\
`     COMP: fix exception specification warning`\
`     BUG: Restore automatic loading of factories in ITK_AUTOLOAD_PATH`\
`     BUG: Avoid warning by using ProcessObject::GetInput method`\
`     COMP: add missing functional header for logic ops tests`\
`     BUG: The incorrect auto_load path was specified in itkIOPluginTest`\
`     BUG: Use path to configure NrrdIO.h for installation`\
`     PERF: Replacing iterator copy with optimized ImageAgotithm::Copy`\
`     BUG: Prevent segfault when logger not set for PatchedBasedDenoising`\
`     BUG: Update uncrustify configuration with space before access spec`\
`     ENH: Enabling support for system lib versions prior to TIFF 4.0.0`\
`     STYLE: Fixed numerous style error in PatchBased denoising`\
`     BUG: Internal factory must use RegisterFactoryInternal method`\
`     BUG: Fix Wrapping FFTWComplexToComplex`\
`     ENH: updating to libtif 4.0.3`\
`     BUG: Fix compilation ofswig external project`\
`     BUG: Fix segfault from integer overflow in NIFTI reader`\
`     BUG: disable wrapping of Toboggan filter for win 64`\
`     ENH: adding support for VectorImage to JoinSeries filter`\
`     ENH: support for VectorImage output to GradientRecursiveGaussian`\
`     BUG: Correcting wrapping CMakeList.txt for DCMTK`\
`     ENH: Improve MRCImageIO support for VectorImages`\
`     COMP: Adding Valgrind suppression for NRRD IO on RH6`\
`     ENH: Convert the Modulus filter to standard binary filter`\
`     BUG: unset environmental default number of threads`\
`     COMP: Adding valgrid suppression file for RHEL6`\
`     BUG: Remove NiftiBigIO Test add MEMORY_SIZE test lock`\
`     COMP: Fix WrapITK warning in DCMTK`\
`     BUG: Append FFTW dirs to ITK's in ITKConfig`\
`     COMP: Fix link error with visibility-inlines-hidden`\
`     BUG: ShrinkImageFilter marked as modified in SetShrinkFactor`\
`     BUG: Prevent modulus by zero is Modulus functor`\
`     BUG: Enable the rehash method to re-register internal factories.`

Brian Avants (2):

`     COMP: The + operation was not registering on Win7-vc10-vce32rel`\
`     BUG: InputImageDimension should be OutputImageDimension`

Brian Helba (1):

`     ENH: Update Remote/LesionSizingToolkit to newer commit`

Cory Quammen (5):

`     BUG: Added missing include `<algorithm>\
`     BUG: Added missing include `<algorithm>\
`     BUG: Propagate the spacing and meta-data in FFTWForwardFFT fitler.`\
`     BUG: Added locking around fftw_destroy_plan`\
`     DOC: Modify PasteImageFilter comments.`

David Doria (6):

`     ENH: Add a SetRegion function to all ImageIterators.`\
`     ENH: Add SetRegion function to NeighborhoodIterators.`\
`     ENH: Allow the ShapedNeighborhoodIterators to use SetRegion.`\
`     COMP: Replace stdlib.h with cstdlib.`\
`     STYLE: Replace dash character in comment.`\
`     STYLE: Replace C Library headers with c[headername]`

Dirk Padfield (3):

`     PERF: Faster distance computation and fixed reflective iterator bug`\
`     BUG: Corrected bug in SignedDanielssonDistanceMap and added regression tests.`\
`     ENH: Templated MaskedFFTNormalizedCorr. over MaskType (#ITK-2940)`

Fotis Drakopoulos (1):

`     BUG: Variance and structure tensor fix`

Gang Song (2):

`     ENH: Add sparse threader for ANTS CC metric`\
`     COMP: Remove deque header from metric class header`

Gordon Kindlmann (5):

`     ENH: updating ITK's NrrdIO to reflect state of Teem's NrrdIO, take 4`\
`     ENH: re-enabling warnings for NrrdIO`\
`     ENH: warning about idxIn in reorder.c; no trailing whitespace`\
`     ENH: still trying to quash warning about idxIn in reorder.c`\
`     BUG: tracking changes (hopefully the last) in Teem prior to its 1.11 release`

Hans Johnson (35):

`     ENH: Bump version to 4.3.0`\
`     BUG: Test harness gave false positives`\
`     BUG: Remove duplicate file in wrong place`\
`     ENH: Allow removal of all Deprecated code`\
`     COMP: Remove unnecessary const_cast.`\
`     STYLE: Remove all references to StartRegistation`\
`     BUG: Array overrun in LaplacianRecursiveGaussian`\
`     COMP: Revert use of itkLegacyMacro`\
`     ENH: Improve testing of GetInverse`\
`     PERF:  Const correct optimize initialization.`\
`     COMP: Fix data type for consistency`\
`     ENH: Imaging data should not be in git`\
`     BUG: Missing DisplacementFieldTransform IO`\
`     COMP: Fix warning for propogating success status`\
`     BUG: Make IsTransformQueueEmpty const`\
`     STYLE: Convert CMake-language commands lower case`\
`     STYLE: Remove CMake-language block-end arguments`\
`     BUG: Reading composite transform error`\
`     ENH: Update compiler fixes for fftw external`\
`     BUG: Test harness gave false positives`\
`     BUG: Remove duplicate file in wrong place`\
`     COMP: Remove unnecessary const_cast.`\
`     COMP: Unused variable warning with FFTW options`\
`     ENH: Test always uncondintionally returned true`\
`     STYLE: Add more files that need to be ignored`\
`     STYLE: Fix typo in comment.`\
`     PERF: Avoid costly redundant computations.`\
`     BUG: Removed too stringent ConceptChecking`\
`     PERF: Remove unnecessary function GetImageDimension`\
`     STYLE: Remove dead code ITK_TEMPLATE_EXPLICIT`\
`     STYLE: Made use of .hxx guards consistent`\
`     DOC: Update space before access specification`\
`     BUG: Allow backwards compatibilty for ITK_TEMPLATE_TXX`\
`     STYLE: Make round consistent in ITK.`\
`     BUG: Incorrect syntax for Intel optimize pragma`

Ho Cheung (6):

`     COMP: Add `“`#include`` `<functional>”` to classes for VS2012`\
`     PERF: Fix usage of ElementAt in PolyLineParametricPath to use const version`\
`     COMP: Add `“`#include`` `<functional>”` to classes for VS2012`\
`     PERF: Fix usage of ElementAt in PolyLineParametricPath to use const version`\
`     BUG: Make LaplRecurGauss filter set the number of threads on the subfilters`\
`     COMP: Fix regression of name mangling for libtiff`

ITK Migration V4 (3):

`     DOC: Modify ComposeImageFilter comments.`\
`     DOC: Modify VectorIndexSelectionCastImageFilter comments.`\
`     DOC: Modify AnisotropicDiffusionFunction comments.`

Jean-Christophe Fillion-Robin (2):

`     BUG: Prevent MetaIO vessel tube from getting stuck in while loop`\
`     BUG: Add test for MetaIO vessel tube from getting stuck in while loop`

Jeffrey Duda (1):

`     ENH: Updates for multivariate metrics`

Kent Williams (18):

`     PERF: Pull expensive GetInput/GetOutput calls out of inner loops`\
`     COMP: propogate compiler selection & flags to FFTW build`\
`     STYLE: Remove superfluous static_cast`\
`     PERF: Pull expensive GetInput/GetOutput calls out of inner loops`\
`     STYLE: Refine usage of static_cast`\
`     BUG: B.Lowenkamp's changes to detect empty fields in Meta files`\
`     BUG: isblank is missing on Microsoft Visual Studio.`\
`     COMP: propogate compiler selection & flags to FFTW build`\
`     BUG: Added test to verify metadata gets copied on file write w/Nrrd`\
`     BUG: Add regression test to try very long filename w/MetaIO`\
`     ENH: Allow change of tolerance in ImageToImageFilter`\
`     DOC: Document spacing/direction tolerance access methods.`\
`     BUG: Orientation vector in FiniteCylinderFunction`\
`     PERF: hoist computation of norm outside Evaluate method.`\
`     ENH: Add DCMTKImageIO to ITK`\
`     BUG: Origin was lost reading HDF5 format images.`\
`     COMP: add new gdcm test for SeriesReader + MetaDataDictionary`\
`     COMP: add set methods for member variables where missing.`

Kris Zygmunt (6):

`     PERF: Optimize patch-based denoiser tensor computations`\
`     BUG: GPU tests sometimes fails`\
`     BUG: GPU tests sometimes fails`\
`     BUG: SymmetricEigenAnalysis OrderByMagnitude bug`\
`     PERF: speed up patch-based denoising tests`\
`     BUG: Denoising 3D patch weights incorrect`

Luis Ibanez (1):

`     BUG: MetaImage data file was missing path.`

Marius Staring (1):

`     ENH: Creating a typedef for the modified time`

Matthew McCormick (65):

`     ENH: Allow custom name for ProcessObject Primary Input/Output.`\
`     DOC: Clarify ProcessObject NumberOfRequiredInputs.`\
`     STYLE: Fix style in itkBlockMatchingImageFilterTest.`\
`     BUG: Fix BlockMatchingImageFilter for pipeline updating.`\
`     DOC: Use one column in the Doxygen alphabetical class index.`\
`     BUG: Fix GCC_XML and SWIG ExternalProject dependencies.`\
`     BUG: Fix GCC_XML and SWIG ExternalProject dependencies.`\
`     BUG: Fix multi-object MetaIO reading for ASCII MetaVesselTube.`\
`     STYLE: Improve readability and debugability in MetaScene.`\
`     BUG: Fix multi-object MetaIO reading for ASCII MetaVesselTube.`\
`     COMP: Fix QuadEdgeMesh doxygen warnings.`\
`     ENH: Wrap new exponential Transform classes.`\
`     STYLE: Use typedefs in TreeNode.`\
`     STYLE: Use more descriptive names in itkSceneSpatialObject.hxx.`\
`     STYLE: Cleanup WrapITK comments.`\
`     BUG: Fix WrapITK GCCXML ExternalProject dependency.`\
`     COMP: Make sure the VC script gets executed after gccxml installation.`\
`     ENH: Use tarball for gccxml ExternalProject build.`\
`     PERF: Use GetPrimaryOutput in ImageSource GetOutput.`\
`     COMP: Add missing deque header for ANTSNeighborhoodCorrelation metric.`\
`     BUG: Fix WrapITK GCCXML ExternalProject dependency.`\
`     COMP: Make sure the VC script gets executed after gccxml installation.`\
`     BUG: Fix multi-object MetaIO reading for ASCII MetaVesselTube.`\
`     ENH: Bump release branch CMakeLists.txt version to 4.2.1.`\
`     DOC: Update Doxygen config's for 1.8.2.`\
`     DOC: Remove out-of-date files in Documentation/`\
`     STYLE: Use EXIT_SUCCESS in itkQuadEdgeMeshPolygonCellTest.`\
`     DOC: Improve Doxygen HTML layout.`\
`     STYLE: Improve style in itkGaussianImageSourceTest.`\
`     COMP: GaussianImageSource unsigned comparison always false.`\
`     BUG: Fix VelocityFieldTransform classes wrapping.`\
`     ENH: Support Vector scalar product with CovariantVector.`\
`     MetaIO: Remove the executable bit from metaFEMObject.{h,cxx}.`\
`     MetaIO: Fix invalid memory dereference with empty Meta field.`\
`     COMP: Fix invalid unsigned comparison with 1D instantiation.`\
`     ENH: Archive testing data in Midas.`\
`     BUG: FixedArray wrapping for 4D wrapping.`\
`     ENH: Add operator=( FloatType & rhs ) to CompensatedSummation.`\
`     BUG: Improve robustness of RayCastInterpolateImageFunction.`\
`     BUG: VTKPolyDataMeshIO for Meshes with Tensor Pixels. #2961`\
`     COMP: Do not wrap WatershedImageFilter on Windows.`\
`     BUG: Set the third-party libtiff VERSION to the correct value.`\
`     COMP: Build with ITK_USE_SYSTEM_TIFF. #2967`\
`     COMP: Fix wrapping of itkNarrowBandCurvesLevelSetImageFilter. #2970.`\
`     COMP: Do not run itkSampleToHistogramFilterTest4 with VC.`\
`     COMP: Fix 1D wrapping of itkImageToVTKImageFilter.`\
`     MetaIO: Prevent vessel tube from getting stuck in while loop`\
`     MetaIO: Fix error in metaVesselTube ASCII reader.`\
`     COMP: Disable DCMTK for MinGW.`\
`     COMP: Ignore DCMTK build warnings.`\
`     BUG: Use HTTP protocol by default for Git pull URLs.`\
`     COMP: Better identification of MSVC90.`\
`     STYLE: Fix style of BorderQuadEdgeMeshFilter.`\
`     STYLE: Fix style of CleanQuadEdgeMeshFilter.`\
`     STYLE: Rename itkMultiTransformBase to itkMultiTransform.`\
`     COMP: Wrap MultiTransform.`\
`     STYLE: Fix style in MultiTransform.`\
`     COMP: Disabling the VideoStreamTest.`\
`     COMP: Suppress fftw ExternalProject warnings.`\
`     COMP: LabelImageInterpolateImageFunctionTest type conversion.`\
`     COMP: Add include directory for ITK_USE_SYSTEM_HDF5.`\
`     COMP: itkLabelImageGaussianInterpolateImageFunctionTest signed unsigned.`\
`     COMP: Fix Doxygen warnings.`\
`     COMP: Ignore libtool FFTW warnings with quote.`\
`     COMP: Fix HDF5IO with ITK_USE_64BITS_IDS on Windows.`

Matthias Seise (2):

`     COMP: Compile wrapITK for python2.7,64bit on windows`\
`     COMP: Compile wrapITK for python2.7,64bit on windows`

Michael Stauffer (6):

`     PERF: Optimize GetValue in v4 image metrics.`\
`     ENH: Add `“`WithOnlyIndex`”` iterators.`\
`     PERF: improve speed of ImageToImageMetricv4 and derived metrics`\
`     ENH: Add parameter weighting option to Optimizersv4`\
`     ENH: Add MultiTransformBase`\
`     DOC: Fix to ObjectToObjectOptimizerBase documentation`

Nick Tustison (20):

`     ENH: Expanding HasLocalSupport to transform categories.`\
`     ENH:  Adding ability to prepend transform queue.`\
`     ENH: Adding labeled point set metric.`\
`     ENH:  Add GetTransformCategory() to translation transform.`\
`     ENH: Adding exponential transforms.`\
`     ENH:  Adding common transforms to be registered.`\
`     BUG:  Voxel size scaling needed`\
`     ENH:  Enable inverse for exponential transforms.`\
`     ENH:  BSpline automated scales estimation.`\
`     BUG: Fix resampling of constant velocity field.`\
`     BUG:  Uninitialized variable.`\
`     ENH:  Reorganization of vel. field transforms.`\
`     BUG:  Control point grid origin wasn't set correctly.`\
`     ENH:  Adding option to permit voxel-based smoothing.`\
`     ENH:  Adding Multiple label STAPLE.`\
`     BUG:  Disp. field xfrm inverse not set correctly.`\
`     ENH: Multiple metrics in registration methods.`\
`     BUG:  Incomplete dynamic casting.`\
`     BUG: Correcting valgrind error.`\
`     BUG:  Set correct images in update field.`

Paul Novotny (1):

`     COMP: Fix Spatial Object Test Segfaults`

Richard Beare (1):

`     ENH: Functors for logic operations`

Willi Huber (2):

`     COMP: WrapITK generates non-unique typedefs in FFT submodule`\
`     COMP: Fix the wrapping for some modules`

Xiaoxiao Liu (3):

`     ENH: Update LSTK version.`\
`     BUG: Update LSTK version to sync with VTK 6.0.`\
`     BUG: Fix ffmpeg VideoStream failing tests.`
