/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MessageBox.java
 *
 * Created on May 13, 2011, 1:35:38 AM
 */
package com.epam.indigo.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;

/**
 *
 * @author rybalkin
 */
public class MessageBox extends javax.swing.JDialog
{
   public static final int ICON_NONE = 0;
   public static final int ICON_INFORMATION = 0;
   public static final int ICON_WARNING = 0;
   public static final int ICON_ERROR = 0;
   private String _message_text;
   private String _message_context_type;

   public static void show (java.awt.Frame parent, String message, String title, int icon_type)
   {
      show(parent, message, title, icon_type, false);
   }

   public static void show (java.awt.Frame parent, String message, String title, Icon icon)
   {
      show(parent, message, title, icon, false);
   }

   public static void show (java.awt.Frame parent, String message, String title, int icon_type, boolean html)
   {
      Icon icon = null;
      if (icon_type == ICON_WARNING)
         icon = UIManager.getIcon("OptionPane.warningIcon");
      else if (icon_type == ICON_INFORMATION)
         icon = UIManager.getIcon("OptionPane.informationIcon");
      else if (icon_type == ICON_ERROR)
         icon = UIManager.getIcon("OptionPane.warningIcon");

      MessageBox mbox = new MessageBox(parent, true, message, icon, html);
      mbox.setTitle(title);
      mbox.setLocationRelativeTo(parent);
      mbox.setVisible(true);
   }

   public static void show (java.awt.Frame parent, String message, String title, Icon icon, boolean html)
   {
      MessageBox mbox = new MessageBox(parent, true, message, icon, html);
      mbox.setTitle(title);
      mbox.setLocationRelativeTo(parent);
      mbox.setVisible(true);
   }

   public static void showHtml (java.awt.Frame parent, String message, String title, int icon_type)
   {
      show(parent, message, title, icon_type, true);
   }

   public static void showHtml (java.awt.Frame parent, String message, String title, Icon icon)
   {
      show(parent, message, title, icon, true);
   }

   private String getMessage ()
   {
      return _message_text;
   }
   private String getContentType ()
   {
      return _message_context_type;
   }

   public MessageBox (java.awt.Frame parent, boolean modal, String message, Icon icon, boolean html)
   {
      super(parent, modal);

      // Set _message_text before initComponents for correct pack
      _message_text = message;
      if (html)
         _message_context_type = "text/html";
      else
         _message_context_type = "text/plain";

      initComponents();

      if (icon == null)
         icon_label.setVisible(false);
      else
      {
         icon_label.setIcon(icon);
         icon_label.setText("");
      }
      if (html)
         message_field.setContentType("text/html");
      else
      {
         message_field.setContentType("text/plain");
      }

      message_field.setBackground(UIManager.getColor("TextField.disabledBackground"));
      message_field.setText(message);
      if (!html)
      {
         JTextPane check_size = new JTextPane();
         check_size.setText(message);
         Dimension s = check_size.getPreferredSize();
         s.width += 20;
         s.height += 20;
         //message_field.setPreferredSize(s);
         //message_field.setMaximumSize(s);
         message_field_scroll.setPreferredSize(s);
         message_field_scroll.setMaximumSize(s);
      }
      pack();

      ok_button.requestFocus();
      
      // TODO: Exception while removing reference: java.lang.InterruptedException
      // 1. Open load
      // 2. Cancel
      // 3. Close main window
   }

   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        icon_label = new javax.swing.JLabel();
        ok_button = new javax.swing.JButton();
        message_field_scroll = new javax.swing.JScrollPane();
        message_field = new javax.swing.JEditorPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        icon_label.setText("icon");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        getContentPane().add(icon_label, gridBagConstraints);

        ok_button.setText("OK");
        ok_button.setMargin(new java.awt.Insets(2, 40, 2, 40));
        ok_button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ok_buttonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 10);
        getContentPane().add(ok_button, gridBagConstraints);

        message_field.setEditable(false);
        message_field.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
                message_fieldHyperlinkUpdate(evt);
            }
        });
        message_field_scroll.setViewportView(message_field);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        getContentPane().add(message_field_scroll, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

   private void ok_buttonActionPerformed (java.awt.event.ActionEvent evt)//GEN-FIRST:event_ok_buttonActionPerformed
   {//GEN-HEADEREND:event_ok_buttonActionPerformed
      setVisible(false);
   }//GEN-LAST:event_ok_buttonActionPerformed

   private void message_fieldHyperlinkUpdate (javax.swing.event.HyperlinkEvent evt)//GEN-FIRST:event_message_fieldHyperlinkUpdate
   {//GEN-HEADEREND:event_message_fieldHyperlinkUpdate
    if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) 
    {
       try
       {
          java.awt.Desktop desktop = java.awt.Desktop.getDesktop();
          java.net.URI uri = new java.net.URI(evt.getURL().toString());
          desktop.browse(uri);
       }
       catch (URISyntaxException uRISyntaxException)
       {
       }
       catch (IOException iOException)
       {
       }
    }
   }//GEN-LAST:event_message_fieldHyperlinkUpdate

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel icon_label;
    private javax.swing.JEditorPane message_field;
    private javax.swing.JScrollPane message_field_scroll;
    private javax.swing.JButton ok_button;
    // End of variables declaration//GEN-END:variables
}
