/*
// $Id: //open/dev/farrago/src/org/eigenbase/rel/rules/PushSemiJoinPastFilterRule.java#8 $
// Package org.eigenbase is a class library of data management components.
// Copyright (C) 2005-2009 The Eigenbase Project
// Copyright (C) 2002-2009 SQLstream, Inc.
// Copyright (C) 2005-2009 LucidEra, Inc.
// Portions Copyright (C) 2003-2009 John V. Sichi
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package org.eigenbase.rel.rules;

import org.eigenbase.rel.*;
import org.eigenbase.relopt.*;


/**
 * PushSemiJoinPastFilterRule implements the rule for pushing semijoins down in
 * a tree past a filter in order to trigger other rules that will convert
 * semijoins. SemiJoinRel(FilterRel(X), Y) --> FilterRel(SemiJoinRel(X, Y))
 *
 * @author Zelaine Fong
 * @version $Id: //open/dev/farrago/src/org/eigenbase/rel/rules/PushSemiJoinPastFilterRule.java#8 $
 */
public class PushSemiJoinPastFilterRule
    extends RelOptRule
{
    public static final PushSemiJoinPastFilterRule instance =
        new PushSemiJoinPastFilterRule();

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a PushSemiJoinPastFilterRule.
     */
    private PushSemiJoinPastFilterRule()
    {
        super(
            new RelOptRuleOperand(
                SemiJoinRel.class,
                new RelOptRuleOperand(FilterRel.class, ANY)));
    }

    //~ Methods ----------------------------------------------------------------

    // implement RelOptRule
    public void onMatch(RelOptRuleCall call)
    {
        SemiJoinRel semiJoin = (SemiJoinRel) call.rels[0];
        FilterRel filter = (FilterRel) call.rels[1];

        RelNode newSemiJoin =
            new SemiJoinRel(
                semiJoin.getCluster(),
                filter.getChild(),
                semiJoin.getRight(),
                semiJoin.getCondition(),
                semiJoin.getLeftKeys(),
                semiJoin.getRightKeys());

        RelNode newFilter =
            CalcRel.createFilter(
                newSemiJoin,
                filter.getCondition());

        call.transformTo(newFilter);
    }
}

// End PushSemiJoinPastFilterRule.java
