# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Rename ``host_architecture`` to ``build_architecture``."""

from django.db import migrations

from debusine.artifacts.models import TaskTypes
from debusine.db.migrations._utils import (
    make_work_request_task_data_field_renamer,
    make_workflow_template_task_data_field_renamer,
)

affected_tasks = {
    "autopkgtest",
    "lintian",
    "blhc",
    "debdiff",
    "piuparts",
    "sbuild",
    "extractforsigning",
    "assemblesignedsource",
    "makesourcepackageupload",
}


class Migration(migrations.Migration):

    dependencies = [
        ("db", "0028_rename_arch_all_build_architecture"),
    ]

    operations = [
        make_work_request_task_data_field_renamer(
            TaskTypes.WORKER,
            affected_tasks,
            [("host_architecture", "build_architecture")],
        )
    ]
