#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Westport Independent
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251013.2

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='the-westport-independent'
GAME_NAME='The Westport Independent'

## This game used to be sold by gog.com, but is no longer available for sale there.
ARCHIVE_BASE_0_NAME='gog_the_westport_independent_2.0.0.1.sh'
ARCHIVE_BASE_0_MD5='7032059f085e94f52444e9bf4ed0195c'
ARCHIVE_BASE_0_SIZE='130000'
ARCHIVE_BASE_0_VERSION='1.0.0-gog2.0.0.1'

ARCHIVE_OPTIONAL_ICONS_NAME='the-westport-independent_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_MD5='054b51fe4c02f256b8130b40e93d28ae'
ARCHIVE_OPTIONAL_ICONS_URL='http://downloads.dotslashplay.it/games/the-westport-independent/'
CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
16x16
32x32
48x48
256x256'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN64_RELATIVE_PATH='linux64'
CONTENT_GAME_BIN64_FILES='
the_westport_independent'
CONTENT_GAME_BIN32_RELATIVE_PATH='linux32'
CONTENT_GAME_BIN32_FILES='
the_westport_independent'
CONTENT_GAME_DATA_RELATIVE_PATH='linux64'
CONTENT_GAME_DATA_FILES='
config.json
assets'
CONTENT_DOC_DATA_RELATIVE_PATH='linux64'
CONTENT_DOC_DATA_FILES='
*.txt'

USER_PERSISTENT_FILES='
config.json'

APP_MAIN_EXE='the_westport_independent'
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libstdc++.so.6'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Force the use of system-provided SDL.
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')
$(launcher_tweak_sdl_override)"
PKG_BIN_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES
libSDL2-2.0.so.0"

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
