// x11-rs: Rust bindings for X11 libraries
// The X11 libraries are available under the MIT license.
// These bindings are public domain.

use std::os::raw::c_uint;

pub const XK_BackSpace: c_uint = 0xFF08;
pub const XK_Tab: c_uint = 0xFF09;
pub const XK_Linefeed: c_uint = 0xFF0A;
pub const XK_Clear: c_uint = 0xFF0B;
pub const XK_Return: c_uint = 0xFF0D;
pub const XK_Pause: c_uint = 0xFF13;
pub const XK_Scroll_Lock: c_uint = 0xFF14;
pub const XK_Sys_Req: c_uint = 0xFF15;
pub const XK_Escape: c_uint = 0xFF1B;
pub const XK_Delete: c_uint = 0xFFFF;
pub const XK_Multi_key: c_uint = 0xFF20;
pub const XK_Kanji: c_uint = 0xFF21;
pub const XK_Muhenkan: c_uint = 0xFF22;
pub const XK_Henkan_Mode: c_uint = 0xFF23;
pub const XK_Henkan: c_uint = 0xFF23;
pub const XK_Romaji: c_uint = 0xFF24;
pub const XK_Hiragana: c_uint = 0xFF25;
pub const XK_Katakana: c_uint = 0xFF26;
pub const XK_Hiragana_Katakana: c_uint = 0xFF27;
pub const XK_Zenkaku: c_uint = 0xFF28;
pub const XK_Hankaku: c_uint = 0xFF29;
pub const XK_Zenkaku_Hankaku: c_uint = 0xFF2A;
pub const XK_Touroku: c_uint = 0xFF2B;
pub const XK_Massyo: c_uint = 0xFF2C;
pub const XK_Kana_Lock: c_uint = 0xFF2D;
pub const XK_Kana_Shift: c_uint = 0xFF2E;
pub const XK_Eisu_Shift: c_uint = 0xFF2F;
pub const XK_Eisu_toggle: c_uint = 0xFF30;
pub const XK_Home: c_uint = 0xFF50;
pub const XK_Left: c_uint = 0xFF51;
pub const XK_Up: c_uint = 0xFF52;
pub const XK_Right: c_uint = 0xFF53;
pub const XK_Down: c_uint = 0xFF54;
pub const XK_Prior: c_uint = 0xFF55;
pub const XK_Page_Up: c_uint = 0xFF55;
pub const XK_Next: c_uint = 0xFF56;
pub const XK_Page_Down: c_uint = 0xFF56;
pub const XK_End: c_uint = 0xFF57;
pub const XK_Begin: c_uint = 0xFF58;
pub const XK_Win_L: c_uint = 0xFF5B;
pub const XK_Win_R: c_uint = 0xFF5C;
pub const XK_App: c_uint = 0xFF5D;
pub const XK_Select: c_uint = 0xFF60;
pub const XK_Print: c_uint = 0xFF61;
pub const XK_Execute: c_uint = 0xFF62;
pub const XK_Insert: c_uint = 0xFF63;
pub const XK_Undo: c_uint = 0xFF65;
pub const XK_Redo: c_uint = 0xFF66;
pub const XK_Menu: c_uint = 0xFF67;
pub const XK_Find: c_uint = 0xFF68;
pub const XK_Cancel: c_uint = 0xFF69;
pub const XK_Help: c_uint = 0xFF6A;
pub const XK_Break: c_uint = 0xFF6B;
pub const XK_Mode_switch: c_uint = 0xFF7E;
pub const XK_script_switch: c_uint = 0xFF7E;
pub const XK_Num_Lock: c_uint = 0xFF7F;
pub const XK_KP_Space: c_uint = 0xFF80;
pub const XK_KP_Tab: c_uint = 0xFF89;
pub const XK_KP_Enter: c_uint = 0xFF8D;
pub const XK_KP_F1: c_uint = 0xFF91;
pub const XK_KP_F2: c_uint = 0xFF92;
pub const XK_KP_F3: c_uint = 0xFF93;
pub const XK_KP_F4: c_uint = 0xFF94;
pub const XK_KP_Home: c_uint = 0xFF95;
pub const XK_KP_Left: c_uint = 0xFF96;
pub const XK_KP_Up: c_uint = 0xFF97;
pub const XK_KP_Right: c_uint = 0xFF98;
pub const XK_KP_Down: c_uint = 0xFF99;
pub const XK_KP_Prior: c_uint = 0xFF9A;
pub const XK_KP_Page_Up: c_uint = 0xFF9A;
pub const XK_KP_Next: c_uint = 0xFF9B;
pub const XK_KP_Page_Down: c_uint = 0xFF9B;
pub const XK_KP_End: c_uint = 0xFF9C;
pub const XK_KP_Begin: c_uint = 0xFF9D;
pub const XK_KP_Insert: c_uint = 0xFF9E;
pub const XK_KP_Delete: c_uint = 0xFF9F;
pub const XK_KP_Equal: c_uint = 0xFFBD;
pub const XK_KP_Multiply: c_uint = 0xFFAA;
pub const XK_KP_Add: c_uint = 0xFFAB;
pub const XK_KP_Separator: c_uint = 0xFFAC;
pub const XK_KP_Subtract: c_uint = 0xFFAD;
pub const XK_KP_Decimal: c_uint = 0xFFAE;
pub const XK_KP_Divide: c_uint = 0xFFAF;
pub const XK_KP_0: c_uint = 0xFFB0;
pub const XK_KP_1: c_uint = 0xFFB1;
pub const XK_KP_2: c_uint = 0xFFB2;
pub const XK_KP_3: c_uint = 0xFFB3;
pub const XK_KP_4: c_uint = 0xFFB4;
pub const XK_KP_5: c_uint = 0xFFB5;
pub const XK_KP_6: c_uint = 0xFFB6;
pub const XK_KP_7: c_uint = 0xFFB7;
pub const XK_KP_8: c_uint = 0xFFB8;
pub const XK_KP_9: c_uint = 0xFFB9;
pub const XK_F1: c_uint = 0xFFBE;
pub const XK_F2: c_uint = 0xFFBF;
pub const XK_F3: c_uint = 0xFFC0;
pub const XK_F4: c_uint = 0xFFC1;
pub const XK_F5: c_uint = 0xFFC2;
pub const XK_F6: c_uint = 0xFFC3;
pub const XK_F7: c_uint = 0xFFC4;
pub const XK_F8: c_uint = 0xFFC5;
pub const XK_F9: c_uint = 0xFFC6;
pub const XK_F10: c_uint = 0xFFC7;
pub const XK_F11: c_uint = 0xFFC8;
pub const XK_L1: c_uint = 0xFFC8;
pub const XK_F12: c_uint = 0xFFC9;
pub const XK_L2: c_uint = 0xFFC9;
pub const XK_F13: c_uint = 0xFFCA;
pub const XK_L3: c_uint = 0xFFCA;
pub const XK_F14: c_uint = 0xFFCB;
pub const XK_L4: c_uint = 0xFFCB;
pub const XK_F15: c_uint = 0xFFCC;
pub const XK_L5: c_uint = 0xFFCC;
pub const XK_F16: c_uint = 0xFFCD;
pub const XK_L6: c_uint = 0xFFCD;
pub const XK_F17: c_uint = 0xFFCE;
pub const XK_L7: c_uint = 0xFFCE;
pub const XK_F18: c_uint = 0xFFCF;
pub const XK_L8: c_uint = 0xFFCF;
pub const XK_F19: c_uint = 0xFFD0;
pub const XK_L9: c_uint = 0xFFD0;
pub const XK_F20: c_uint = 0xFFD1;
pub const XK_L10: c_uint = 0xFFD1;
pub const XK_F21: c_uint = 0xFFD2;
pub const XK_R1: c_uint = 0xFFD2;
pub const XK_F22: c_uint = 0xFFD3;
pub const XK_R2: c_uint = 0xFFD3;
pub const XK_F23: c_uint = 0xFFD4;
pub const XK_R3: c_uint = 0xFFD4;
pub const XK_F24: c_uint = 0xFFD5;
pub const XK_R4: c_uint = 0xFFD5;
pub const XK_F25: c_uint = 0xFFD6;
pub const XK_R5: c_uint = 0xFFD6;
pub const XK_F26: c_uint = 0xFFD7;
pub const XK_R6: c_uint = 0xFFD7;
pub const XK_F27: c_uint = 0xFFD8;
pub const XK_R7: c_uint = 0xFFD8;
pub const XK_F28: c_uint = 0xFFD9;
pub const XK_R8: c_uint = 0xFFD9;
pub const XK_F29: c_uint = 0xFFDA;
pub const XK_R9: c_uint = 0xFFDA;
pub const XK_F30: c_uint = 0xFFDB;
pub const XK_R10: c_uint = 0xFFDB;
pub const XK_F31: c_uint = 0xFFDC;
pub const XK_R11: c_uint = 0xFFDC;
pub const XK_F32: c_uint = 0xFFDD;
pub const XK_R12: c_uint = 0xFFDD;
pub const XK_F33: c_uint = 0xFFDE;
pub const XK_R13: c_uint = 0xFFDE;
pub const XK_F34: c_uint = 0xFFDF;
pub const XK_R14: c_uint = 0xFFDF;
pub const XK_F35: c_uint = 0xFFE0;
pub const XK_R15: c_uint = 0xFFE0;
pub const XK_Shift_L: c_uint = 0xFFE1;
pub const XK_Shift_R: c_uint = 0xFFE2;
pub const XK_Control_L: c_uint = 0xFFE3;
pub const XK_Control_R: c_uint = 0xFFE4;
pub const XK_Caps_Lock: c_uint = 0xFFE5;
pub const XK_Shift_Lock: c_uint = 0xFFE6;
pub const XK_Meta_L: c_uint = 0xFFE7;
pub const XK_Meta_R: c_uint = 0xFFE8;
pub const XK_Alt_L: c_uint = 0xFFE9;
pub const XK_Alt_R: c_uint = 0xFFEA;
pub const XK_Super_L: c_uint = 0xFFEB;
pub const XK_Super_R: c_uint = 0xFFEC;
pub const XK_Hyper_L: c_uint = 0xFFED;
pub const XK_Hyper_R: c_uint = 0xFFEE;
pub const XK_space: c_uint = 0x020;
pub const XK_exclam: c_uint = 0x021;
pub const XK_quotedbl: c_uint = 0x022;
pub const XK_numbersign: c_uint = 0x023;
pub const XK_dollar: c_uint = 0x024;
pub const XK_percent: c_uint = 0x025;
pub const XK_ampersand: c_uint = 0x026;
pub const XK_apostrophe: c_uint = 0x027;
pub const XK_quoteright: c_uint = 0x027;
pub const XK_parenleft: c_uint = 0x028;
pub const XK_parenright: c_uint = 0x029;
pub const XK_asterisk: c_uint = 0x02a;
pub const XK_plus: c_uint = 0x02b;
pub const XK_comma: c_uint = 0x02c;
pub const XK_minus: c_uint = 0x02d;
pub const XK_period: c_uint = 0x02e;
pub const XK_slash: c_uint = 0x02f;
pub const XK_0: c_uint = 0x030;
pub const XK_1: c_uint = 0x031;
pub const XK_2: c_uint = 0x032;
pub const XK_3: c_uint = 0x033;
pub const XK_4: c_uint = 0x034;
pub const XK_5: c_uint = 0x035;
pub const XK_6: c_uint = 0x036;
pub const XK_7: c_uint = 0x037;
pub const XK_8: c_uint = 0x038;
pub const XK_9: c_uint = 0x039;
pub const XK_colon: c_uint = 0x03a;
pub const XK_semicolon: c_uint = 0x03b;
pub const XK_less: c_uint = 0x03c;
pub const XK_equal: c_uint = 0x03d;
pub const XK_greater: c_uint = 0x03e;
pub const XK_question: c_uint = 0x03f;
pub const XK_at: c_uint = 0x040;
pub const XK_A: c_uint = 0x041;
pub const XK_B: c_uint = 0x042;
pub const XK_C: c_uint = 0x043;
pub const XK_D: c_uint = 0x044;
pub const XK_E: c_uint = 0x045;
pub const XK_F: c_uint = 0x046;
pub const XK_G: c_uint = 0x047;
pub const XK_H: c_uint = 0x048;
pub const XK_I: c_uint = 0x049;
pub const XK_J: c_uint = 0x04a;
pub const XK_K: c_uint = 0x04b;
pub const XK_L: c_uint = 0x04c;
pub const XK_M: c_uint = 0x04d;
pub const XK_N: c_uint = 0x04e;
pub const XK_O: c_uint = 0x04f;
pub const XK_P: c_uint = 0x050;
pub const XK_Q: c_uint = 0x051;
pub const XK_R: c_uint = 0x052;
pub const XK_S: c_uint = 0x053;
pub const XK_T: c_uint = 0x054;
pub const XK_U: c_uint = 0x055;
pub const XK_V: c_uint = 0x056;
pub const XK_W: c_uint = 0x057;
pub const XK_X: c_uint = 0x058;
pub const XK_Y: c_uint = 0x059;
pub const XK_Z: c_uint = 0x05a;
pub const XK_bracketleft: c_uint = 0x05b;
pub const XK_backslash: c_uint = 0x05c;
pub const XK_bracketright: c_uint = 0x05d;
pub const XK_asciicircum: c_uint = 0x05e;
pub const XK_underscore: c_uint = 0x05f;
pub const XK_grave: c_uint = 0x060;
pub const XK_quoteleft: c_uint = 0x060;
pub const XK_a: c_uint = 0x061;
pub const XK_b: c_uint = 0x062;
pub const XK_c: c_uint = 0x063;
pub const XK_d: c_uint = 0x064;
pub const XK_e: c_uint = 0x065;
pub const XK_f: c_uint = 0x066;
pub const XK_g: c_uint = 0x067;
pub const XK_h: c_uint = 0x068;
pub const XK_i: c_uint = 0x069;
pub const XK_j: c_uint = 0x06a;
pub const XK_k: c_uint = 0x06b;
pub const XK_l: c_uint = 0x06c;
pub const XK_m: c_uint = 0x06d;
pub const XK_n: c_uint = 0x06e;
pub const XK_o: c_uint = 0x06f;
pub const XK_p: c_uint = 0x070;
pub const XK_q: c_uint = 0x071;
pub const XK_r: c_uint = 0x072;
pub const XK_s: c_uint = 0x073;
pub const XK_t: c_uint = 0x074;
pub const XK_u: c_uint = 0x075;
pub const XK_v: c_uint = 0x076;
pub const XK_w: c_uint = 0x077;
pub const XK_x: c_uint = 0x078;
pub const XK_y: c_uint = 0x079;
pub const XK_z: c_uint = 0x07a;
pub const XK_braceleft: c_uint = 0x07b;
pub const XK_bar: c_uint = 0x07c;
pub const XK_braceright: c_uint = 0x07d;
pub const XK_asciitilde: c_uint = 0x07e;
pub const XK_nobreakspace: c_uint = 0x0a0;
pub const XK_exclamdown: c_uint = 0x0a1;
pub const XK_cent: c_uint = 0x0a2;
pub const XK_sterling: c_uint = 0x0a3;
pub const XK_currency: c_uint = 0x0a4;
pub const XK_yen: c_uint = 0x0a5;
pub const XK_brokenbar: c_uint = 0x0a6;
pub const XK_section: c_uint = 0x0a7;
pub const XK_diaeresis: c_uint = 0x0a8;
pub const XK_copyright: c_uint = 0x0a9;
pub const XK_ordfeminine: c_uint = 0x0aa;
pub const XK_guillemotleft: c_uint = 0x0ab;
pub const XK_notsign: c_uint = 0x0ac;
pub const XK_hyphen: c_uint = 0x0ad;
pub const XK_registered: c_uint = 0x0ae;
pub const XK_macron: c_uint = 0x0af;
pub const XK_degree: c_uint = 0x0b0;
pub const XK_plusminus: c_uint = 0x0b1;
pub const XK_twosuperior: c_uint = 0x0b2;
pub const XK_threesuperior: c_uint = 0x0b3;
pub const XK_acute: c_uint = 0x0b4;
pub const XK_mu: c_uint = 0x0b5;
pub const XK_paragraph: c_uint = 0x0b6;
pub const XK_periodcentered: c_uint = 0x0b7;
pub const XK_cedilla: c_uint = 0x0b8;
pub const XK_onesuperior: c_uint = 0x0b9;
pub const XK_masculine: c_uint = 0x0ba;
pub const XK_guillemotright: c_uint = 0x0bb;
pub const XK_onequarter: c_uint = 0x0bc;
pub const XK_onehalf: c_uint = 0x0bd;
pub const XK_threequarters: c_uint = 0x0be;
pub const XK_questiondown: c_uint = 0x0bf;
pub const XK_Agrave: c_uint = 0x0c0;
pub const XK_Aacute: c_uint = 0x0c1;
pub const XK_Acircumflex: c_uint = 0x0c2;
pub const XK_Atilde: c_uint = 0x0c3;
pub const XK_Adiaeresis: c_uint = 0x0c4;
pub const XK_Aring: c_uint = 0x0c5;
pub const XK_AE: c_uint = 0x0c6;
pub const XK_Ccedilla: c_uint = 0x0c7;
pub const XK_Egrave: c_uint = 0x0c8;
pub const XK_Eacute: c_uint = 0x0c9;
pub const XK_Ecircumflex: c_uint = 0x0ca;
pub const XK_Ediaeresis: c_uint = 0x0cb;
pub const XK_Igrave: c_uint = 0x0cc;
pub const XK_Iacute: c_uint = 0x0cd;
pub const XK_Icircumflex: c_uint = 0x0ce;
pub const XK_Idiaeresis: c_uint = 0x0cf;
pub const XK_ETH: c_uint = 0x0d0;
pub const XK_Eth: c_uint = 0x0d0;
pub const XK_Ntilde: c_uint = 0x0d1;
pub const XK_Ograve: c_uint = 0x0d2;
pub const XK_Oacute: c_uint = 0x0d3;
pub const XK_Ocircumflex: c_uint = 0x0d4;
pub const XK_Otilde: c_uint = 0x0d5;
pub const XK_Odiaeresis: c_uint = 0x0d6;
pub const XK_multiply: c_uint = 0x0d7;
pub const XK_Ooblique: c_uint = 0x0d8;
pub const XK_Ugrave: c_uint = 0x0d9;
pub const XK_Uacute: c_uint = 0x0da;
pub const XK_Ucircumflex: c_uint = 0x0db;
pub const XK_Udiaeresis: c_uint = 0x0dc;
pub const XK_Yacute: c_uint = 0x0dd;
pub const XK_THORN: c_uint = 0x0de;
pub const XK_Thorn: c_uint = 0x0de;
pub const XK_ssharp: c_uint = 0x0df;
pub const XK_agrave: c_uint = 0x0e0;
pub const XK_aacute: c_uint = 0x0e1;
pub const XK_acircumflex: c_uint = 0x0e2;
pub const XK_atilde: c_uint = 0x0e3;
pub const XK_adiaeresis: c_uint = 0x0e4;
pub const XK_aring: c_uint = 0x0e5;
pub const XK_ae: c_uint = 0x0e6;
pub const XK_ccedilla: c_uint = 0x0e7;
pub const XK_egrave: c_uint = 0x0e8;
pub const XK_eacute: c_uint = 0x0e9;
pub const XK_ecircumflex: c_uint = 0x0ea;
pub const XK_ediaeresis: c_uint = 0x0eb;
pub const XK_igrave: c_uint = 0x0ec;
pub const XK_iacute: c_uint = 0x0ed;
pub const XK_icircumflex: c_uint = 0x0ee;
pub const XK_idiaeresis: c_uint = 0x0ef;
pub const XK_eth: c_uint = 0x0f0;
pub const XK_ntilde: c_uint = 0x0f1;
pub const XK_ograve: c_uint = 0x0f2;
pub const XK_oacute: c_uint = 0x0f3;
pub const XK_ocircumflex: c_uint = 0x0f4;
pub const XK_otilde: c_uint = 0x0f5;
pub const XK_odiaeresis: c_uint = 0x0f6;
pub const XK_division: c_uint = 0x0f7;
pub const XK_oslash: c_uint = 0x0f8;
pub const XK_ugrave: c_uint = 0x0f9;
pub const XK_uacute: c_uint = 0x0fa;
pub const XK_ucircumflex: c_uint = 0x0fb;
pub const XK_udiaeresis: c_uint = 0x0fc;
pub const XK_yacute: c_uint = 0x0fd;
pub const XK_thorn: c_uint = 0x0fe;
pub const XK_ydiaeresis: c_uint = 0x0ff;
pub const XK_Aogonek: c_uint = 0x1a1;
pub const XK_breve: c_uint = 0x1a2;
pub const XK_Lstroke: c_uint = 0x1a3;
pub const XK_Lcaron: c_uint = 0x1a5;
pub const XK_Sacute: c_uint = 0x1a6;
pub const XK_Scaron: c_uint = 0x1a9;
pub const XK_Scedilla: c_uint = 0x1aa;
pub const XK_Tcaron: c_uint = 0x1ab;
pub const XK_Zacute: c_uint = 0x1ac;
pub const XK_Zcaron: c_uint = 0x1ae;
pub const XK_Zabovedot: c_uint = 0x1af;
pub const XK_aogonek: c_uint = 0x1b1;
pub const XK_ogonek: c_uint = 0x1b2;
pub const XK_lstroke: c_uint = 0x1b3;
pub const XK_lcaron: c_uint = 0x1b5;
pub const XK_sacute: c_uint = 0x1b6;
pub const XK_caron: c_uint = 0x1b7;
pub const XK_scaron: c_uint = 0x1b9;
pub const XK_scedilla: c_uint = 0x1ba;
pub const XK_tcaron: c_uint = 0x1bb;
pub const XK_zacute: c_uint = 0x1bc;
pub const XK_doubleacute: c_uint = 0x1bd;
pub const XK_zcaron: c_uint = 0x1be;
pub const XK_zabovedot: c_uint = 0x1bf;
pub const XK_Racute: c_uint = 0x1c0;
pub const XK_Abreve: c_uint = 0x1c3;
pub const XK_Lacute: c_uint = 0x1c5;
pub const XK_Cacute: c_uint = 0x1c6;
pub const XK_Ccaron: c_uint = 0x1c8;
pub const XK_Eogonek: c_uint = 0x1ca;
pub const XK_Ecaron: c_uint = 0x1cc;
pub const XK_Dcaron: c_uint = 0x1cf;
pub const XK_Dstroke: c_uint = 0x1d0;
pub const XK_Nacute: c_uint = 0x1d1;
pub const XK_Ncaron: c_uint = 0x1d2;
pub const XK_Odoubleacute: c_uint = 0x1d5;
pub const XK_Rcaron: c_uint = 0x1d8;
pub const XK_Uring: c_uint = 0x1d9;
pub const XK_Udoubleacute: c_uint = 0x1db;
pub const XK_Tcedilla: c_uint = 0x1de;
pub const XK_racute: c_uint = 0x1e0;
pub const XK_abreve: c_uint = 0x1e3;
pub const XK_lacute: c_uint = 0x1e5;
pub const XK_cacute: c_uint = 0x1e6;
pub const XK_ccaron: c_uint = 0x1e8;
pub const XK_eogonek: c_uint = 0x1ea;
pub const XK_ecaron: c_uint = 0x1ec;
pub const XK_dcaron: c_uint = 0x1ef;
pub const XK_dstroke: c_uint = 0x1f0;
pub const XK_nacute: c_uint = 0x1f1;
pub const XK_ncaron: c_uint = 0x1f2;
pub const XK_odoubleacute: c_uint = 0x1f5;
pub const XK_udoubleacute: c_uint = 0x1fb;
pub const XK_rcaron: c_uint = 0x1f8;
pub const XK_uring: c_uint = 0x1f9;
pub const XK_tcedilla: c_uint = 0x1fe;
pub const XK_abovedot: c_uint = 0x1ff;
pub const XK_Hstroke: c_uint = 0x2a1;
pub const XK_Hcircumflex: c_uint = 0x2a6;
pub const XK_Iabovedot: c_uint = 0x2a9;
pub const XK_Gbreve: c_uint = 0x2ab;
pub const XK_Jcircumflex: c_uint = 0x2ac;
pub const XK_hstroke: c_uint = 0x2b1;
pub const XK_hcircumflex: c_uint = 0x2b6;
pub const XK_idotless: c_uint = 0x2b9;
pub const XK_gbreve: c_uint = 0x2bb;
pub const XK_jcircumflex: c_uint = 0x2bc;
pub const XK_Cabovedot: c_uint = 0x2c5;
pub const XK_Ccircumflex: c_uint = 0x2c6;
pub const XK_Gabovedot: c_uint = 0x2d5;
pub const XK_Gcircumflex: c_uint = 0x2d8;
pub const XK_Ubreve: c_uint = 0x2dd;
pub const XK_Scircumflex: c_uint = 0x2de;
pub const XK_cabovedot: c_uint = 0x2e5;
pub const XK_ccircumflex: c_uint = 0x2e6;
pub const XK_gabovedot: c_uint = 0x2f5;
pub const XK_gcircumflex: c_uint = 0x2f8;
pub const XK_ubreve: c_uint = 0x2fd;
pub const XK_scircumflex: c_uint = 0x2fe;
pub const XK_kra: c_uint = 0x3a2;
pub const XK_kappa: c_uint = 0x3a2;
pub const XK_Rcedilla: c_uint = 0x3a3;
pub const XK_Itilde: c_uint = 0x3a5;
pub const XK_Lcedilla: c_uint = 0x3a6;
pub const XK_Emacron: c_uint = 0x3aa;
pub const XK_Gcedilla: c_uint = 0x3ab;
pub const XK_Tslash: c_uint = 0x3ac;
pub const XK_rcedilla: c_uint = 0x3b3;
pub const XK_itilde: c_uint = 0x3b5;
pub const XK_lcedilla: c_uint = 0x3b6;
pub const XK_emacron: c_uint = 0x3ba;
pub const XK_gcedilla: c_uint = 0x3bb;
pub const XK_tslash: c_uint = 0x3bc;
pub const XK_ENG: c_uint = 0x3bd;
pub const XK_eng: c_uint = 0x3bf;
pub const XK_Amacron: c_uint = 0x3c0;
pub const XK_Iogonek: c_uint = 0x3c7;
pub const XK_Eabovedot: c_uint = 0x3cc;
pub const XK_Imacron: c_uint = 0x3cf;
pub const XK_Ncedilla: c_uint = 0x3d1;
pub const XK_Omacron: c_uint = 0x3d2;
pub const XK_Kcedilla: c_uint = 0x3d3;
pub const XK_Uogonek: c_uint = 0x3d9;
pub const XK_Utilde: c_uint = 0x3dd;
pub const XK_Umacron: c_uint = 0x3de;
pub const XK_amacron: c_uint = 0x3e0;
pub const XK_iogonek: c_uint = 0x3e7;
pub const XK_eabovedot: c_uint = 0x3ec;
pub const XK_imacron: c_uint = 0x3ef;
pub const XK_ncedilla: c_uint = 0x3f1;
pub const XK_omacron: c_uint = 0x3f2;
pub const XK_kcedilla: c_uint = 0x3f3;
pub const XK_uogonek: c_uint = 0x3f9;
pub const XK_utilde: c_uint = 0x3fd;
pub const XK_umacron: c_uint = 0x3fe;
pub const XK_overline: c_uint = 0x47e;
pub const XK_kana_fullstop: c_uint = 0x4a1;
pub const XK_kana_openingbracket: c_uint = 0x4a2;
pub const XK_kana_closingbracket: c_uint = 0x4a3;
pub const XK_kana_comma: c_uint = 0x4a4;
pub const XK_kana_conjunctive: c_uint = 0x4a5;
pub const XK_kana_middledot: c_uint = 0x4a5;
pub const XK_kana_WO: c_uint = 0x4a6;
pub const XK_kana_a: c_uint = 0x4a7;
pub const XK_kana_i: c_uint = 0x4a8;
pub const XK_kana_u: c_uint = 0x4a9;
pub const XK_kana_e: c_uint = 0x4aa;
pub const XK_kana_o: c_uint = 0x4ab;
pub const XK_kana_ya: c_uint = 0x4ac;
pub const XK_kana_yu: c_uint = 0x4ad;
pub const XK_kana_yo: c_uint = 0x4ae;
pub const XK_kana_tsu: c_uint = 0x4af;
pub const XK_kana_tu: c_uint = 0x4af;
pub const XK_prolongedsound: c_uint = 0x4b0;
pub const XK_kana_A: c_uint = 0x4b1;
pub const XK_kana_I: c_uint = 0x4b2;
pub const XK_kana_U: c_uint = 0x4b3;
pub const XK_kana_E: c_uint = 0x4b4;
pub const XK_kana_O: c_uint = 0x4b5;
pub const XK_kana_KA: c_uint = 0x4b6;
pub const XK_kana_KI: c_uint = 0x4b7;
pub const XK_kana_KU: c_uint = 0x4b8;
pub const XK_kana_KE: c_uint = 0x4b9;
pub const XK_kana_KO: c_uint = 0x4ba;
pub const XK_kana_SA: c_uint = 0x4bb;
pub const XK_kana_SHI: c_uint = 0x4bc;
pub const XK_kana_SU: c_uint = 0x4bd;
pub const XK_kana_SE: c_uint = 0x4be;
pub const XK_kana_SO: c_uint = 0x4bf;
pub const XK_kana_TA: c_uint = 0x4c0;
pub const XK_kana_CHI: c_uint = 0x4c1;
pub const XK_kana_TI: c_uint = 0x4c1;
pub const XK_kana_TSU: c_uint = 0x4c2;
pub const XK_kana_TU: c_uint = 0x4c2;
pub const XK_kana_TE: c_uint = 0x4c3;
pub const XK_kana_TO: c_uint = 0x4c4;
pub const XK_kana_NA: c_uint = 0x4c5;
pub const XK_kana_NI: c_uint = 0x4c6;
pub const XK_kana_NU: c_uint = 0x4c7;
pub const XK_kana_NE: c_uint = 0x4c8;
pub const XK_kana_NO: c_uint = 0x4c9;
pub const XK_kana_HA: c_uint = 0x4ca;
pub const XK_kana_HI: c_uint = 0x4cb;
pub const XK_kana_FU: c_uint = 0x4cc;
pub const XK_kana_HU: c_uint = 0x4cc;
pub const XK_kana_HE: c_uint = 0x4cd;
pub const XK_kana_HO: c_uint = 0x4ce;
pub const XK_kana_MA: c_uint = 0x4cf;
pub const XK_kana_MI: c_uint = 0x4d0;
pub const XK_kana_MU: c_uint = 0x4d1;
pub const XK_kana_ME: c_uint = 0x4d2;
pub const XK_kana_MO: c_uint = 0x4d3;
pub const XK_kana_YA: c_uint = 0x4d4;
pub const XK_kana_YU: c_uint = 0x4d5;
pub const XK_kana_YO: c_uint = 0x4d6;
pub const XK_kana_RA: c_uint = 0x4d7;
pub const XK_kana_RI: c_uint = 0x4d8;
pub const XK_kana_RU: c_uint = 0x4d9;
pub const XK_kana_RE: c_uint = 0x4da;
pub const XK_kana_RO: c_uint = 0x4db;
pub const XK_kana_WA: c_uint = 0x4dc;
pub const XK_kana_N: c_uint = 0x4dd;
pub const XK_voicedsound: c_uint = 0x4de;
pub const XK_semivoicedsound: c_uint = 0x4df;
pub const XK_kana_switch: c_uint = 0xFF7E;
pub const XK_Arabic_comma: c_uint = 0x5ac;
pub const XK_Arabic_semicolon: c_uint = 0x5bb;
pub const XK_Arabic_question_mark: c_uint = 0x5bf;
pub const XK_Arabic_hamza: c_uint = 0x5c1;
pub const XK_Arabic_maddaonalef: c_uint = 0x5c2;
pub const XK_Arabic_hamzaonalef: c_uint = 0x5c3;
pub const XK_Arabic_hamzaonwaw: c_uint = 0x5c4;
pub const XK_Arabic_hamzaunderalef: c_uint = 0x5c5;
pub const XK_Arabic_hamzaonyeh: c_uint = 0x5c6;
pub const XK_Arabic_alef: c_uint = 0x5c7;
pub const XK_Arabic_beh: c_uint = 0x5c8;
pub const XK_Arabic_tehmarbuta: c_uint = 0x5c9;
pub const XK_Arabic_teh: c_uint = 0x5ca;
pub const XK_Arabic_theh: c_uint = 0x5cb;
pub const XK_Arabic_jeem: c_uint = 0x5cc;
pub const XK_Arabic_hah: c_uint = 0x5cd;
pub const XK_Arabic_khah: c_uint = 0x5ce;
pub const XK_Arabic_dal: c_uint = 0x5cf;
pub const XK_Arabic_thal: c_uint = 0x5d0;
pub const XK_Arabic_ra: c_uint = 0x5d1;
pub const XK_Arabic_zain: c_uint = 0x5d2;
pub const XK_Arabic_seen: c_uint = 0x5d3;
pub const XK_Arabic_sheen: c_uint = 0x5d4;
pub const XK_Arabic_sad: c_uint = 0x5d5;
pub const XK_Arabic_dad: c_uint = 0x5d6;
pub const XK_Arabic_tah: c_uint = 0x5d7;
pub const XK_Arabic_zah: c_uint = 0x5d8;
pub const XK_Arabic_ain: c_uint = 0x5d9;
pub const XK_Arabic_ghain: c_uint = 0x5da;
pub const XK_Arabic_tatweel: c_uint = 0x5e0;
pub const XK_Arabic_feh: c_uint = 0x5e1;
pub const XK_Arabic_qaf: c_uint = 0x5e2;
pub const XK_Arabic_kaf: c_uint = 0x5e3;
pub const XK_Arabic_lam: c_uint = 0x5e4;
pub const XK_Arabic_meem: c_uint = 0x5e5;
pub const XK_Arabic_noon: c_uint = 0x5e6;
pub const XK_Arabic_ha: c_uint = 0x5e7;
pub const XK_Arabic_heh: c_uint = 0x5e7;
pub const XK_Arabic_waw: c_uint = 0x5e8;
pub const XK_Arabic_alefmaksura: c_uint = 0x5e9;
pub const XK_Arabic_yeh: c_uint = 0x5ea;
pub const XK_Arabic_fathatan: c_uint = 0x5eb;
pub const XK_Arabic_dammatan: c_uint = 0x5ec;
pub const XK_Arabic_kasratan: c_uint = 0x5ed;
pub const XK_Arabic_fatha: c_uint = 0x5ee;
pub const XK_Arabic_damma: c_uint = 0x5ef;
pub const XK_Arabic_kasra: c_uint = 0x5f0;
pub const XK_Arabic_shadda: c_uint = 0x5f1;
pub const XK_Arabic_sukun: c_uint = 0x5f2;
pub const XK_Arabic_switch: c_uint = 0xFF7E;
pub const XK_Serbian_dje: c_uint = 0x6a1;
pub const XK_Macedonia_gje: c_uint = 0x6a2;
pub const XK_Cyrillic_io: c_uint = 0x6a3;
pub const XK_Ukrainian_ie: c_uint = 0x6a4;
pub const XK_Ukranian_je: c_uint = 0x6a4;
pub const XK_Macedonia_dse: c_uint = 0x6a5;
pub const XK_Ukrainian_i: c_uint = 0x6a6;
pub const XK_Ukranian_i: c_uint = 0x6a6;
pub const XK_Ukrainian_yi: c_uint = 0x6a7;
pub const XK_Ukranian_yi: c_uint = 0x6a7;
pub const XK_Cyrillic_je: c_uint = 0x6a8;
pub const XK_Serbian_je: c_uint = 0x6a8;
pub const XK_Cyrillic_lje: c_uint = 0x6a9;
pub const XK_Serbian_lje: c_uint = 0x6a9;
pub const XK_Cyrillic_nje: c_uint = 0x6aa;
pub const XK_Serbian_nje: c_uint = 0x6aa;
pub const XK_Serbian_tshe: c_uint = 0x6ab;
pub const XK_Macedonia_kje: c_uint = 0x6ac;
pub const XK_Byelorussian_shortu: c_uint = 0x6ae;
pub const XK_Cyrillic_dzhe: c_uint = 0x6af;
pub const XK_Serbian_dze: c_uint = 0x6af;
pub const XK_numerosign: c_uint = 0x6b0;
pub const XK_Serbian_DJE: c_uint = 0x6b1;
pub const XK_Macedonia_GJE: c_uint = 0x6b2;
pub const XK_Cyrillic_IO: c_uint = 0x6b3;
pub const XK_Ukrainian_IE: c_uint = 0x6b4;
pub const XK_Ukranian_JE: c_uint = 0x6b4;
pub const XK_Macedonia_DSE: c_uint = 0x6b5;
pub const XK_Ukrainian_I: c_uint = 0x6b6;
pub const XK_Ukranian_I: c_uint = 0x6b6;
pub const XK_Ukrainian_YI: c_uint = 0x6b7;
pub const XK_Ukranian_YI: c_uint = 0x6b7;
pub const XK_Cyrillic_JE: c_uint = 0x6b8;
pub const XK_Serbian_JE: c_uint = 0x6b8;
pub const XK_Cyrillic_LJE: c_uint = 0x6b9;
pub const XK_Serbian_LJE: c_uint = 0x6b9;
pub const XK_Cyrillic_NJE: c_uint = 0x6ba;
pub const XK_Serbian_NJE: c_uint = 0x6ba;
pub const XK_Serbian_TSHE: c_uint = 0x6bb;
pub const XK_Macedonia_KJE: c_uint = 0x6bc;
pub const XK_Byelorussian_SHORTU: c_uint = 0x6be;
pub const XK_Cyrillic_DZHE: c_uint = 0x6bf;
pub const XK_Serbian_DZE: c_uint = 0x6bf;
pub const XK_Cyrillic_yu: c_uint = 0x6c0;
pub const XK_Cyrillic_a: c_uint = 0x6c1;
pub const XK_Cyrillic_be: c_uint = 0x6c2;
pub const XK_Cyrillic_tse: c_uint = 0x6c3;
pub const XK_Cyrillic_de: c_uint = 0x6c4;
pub const XK_Cyrillic_ie: c_uint = 0x6c5;
pub const XK_Cyrillic_ef: c_uint = 0x6c6;
pub const XK_Cyrillic_ghe: c_uint = 0x6c7;
pub const XK_Cyrillic_ha: c_uint = 0x6c8;
pub const XK_Cyrillic_i: c_uint = 0x6c9;
pub const XK_Cyrillic_shorti: c_uint = 0x6ca;
pub const XK_Cyrillic_ka: c_uint = 0x6cb;
pub const XK_Cyrillic_el: c_uint = 0x6cc;
pub const XK_Cyrillic_em: c_uint = 0x6cd;
pub const XK_Cyrillic_en: c_uint = 0x6ce;
pub const XK_Cyrillic_o: c_uint = 0x6cf;
pub const XK_Cyrillic_pe: c_uint = 0x6d0;
pub const XK_Cyrillic_ya: c_uint = 0x6d1;
pub const XK_Cyrillic_er: c_uint = 0x6d2;
pub const XK_Cyrillic_es: c_uint = 0x6d3;
pub const XK_Cyrillic_te: c_uint = 0x6d4;
pub const XK_Cyrillic_u: c_uint = 0x6d5;
pub const XK_Cyrillic_zhe: c_uint = 0x6d6;
pub const XK_Cyrillic_ve: c_uint = 0x6d7;
pub const XK_Cyrillic_softsign: c_uint = 0x6d8;
pub const XK_Cyrillic_yeru: c_uint = 0x6d9;
pub const XK_Cyrillic_ze: c_uint = 0x6da;
pub const XK_Cyrillic_sha: c_uint = 0x6db;
pub const XK_Cyrillic_e: c_uint = 0x6dc;
pub const XK_Cyrillic_shcha: c_uint = 0x6dd;
pub const XK_Cyrillic_che: c_uint = 0x6de;
pub const XK_Cyrillic_hardsign: c_uint = 0x6df;
pub const XK_Cyrillic_YU: c_uint = 0x6e0;
pub const XK_Cyrillic_A: c_uint = 0x6e1;
pub const XK_Cyrillic_BE: c_uint = 0x6e2;
pub const XK_Cyrillic_TSE: c_uint = 0x6e3;
pub const XK_Cyrillic_DE: c_uint = 0x6e4;
pub const XK_Cyrillic_IE: c_uint = 0x6e5;
pub const XK_Cyrillic_EF: c_uint = 0x6e6;
pub const XK_Cyrillic_GHE: c_uint = 0x6e7;
pub const XK_Cyrillic_HA: c_uint = 0x6e8;
pub const XK_Cyrillic_I: c_uint = 0x6e9;
pub const XK_Cyrillic_SHORTI: c_uint = 0x6ea;
pub const XK_Cyrillic_KA: c_uint = 0x6eb;
pub const XK_Cyrillic_EL: c_uint = 0x6ec;
pub const XK_Cyrillic_EM: c_uint = 0x6ed;
pub const XK_Cyrillic_EN: c_uint = 0x6ee;
pub const XK_Cyrillic_O: c_uint = 0x6ef;
pub const XK_Cyrillic_PE: c_uint = 0x6f0;
pub const XK_Cyrillic_YA: c_uint = 0x6f1;
pub const XK_Cyrillic_ER: c_uint = 0x6f2;
pub const XK_Cyrillic_ES: c_uint = 0x6f3;
pub const XK_Cyrillic_TE: c_uint = 0x6f4;
pub const XK_Cyrillic_U: c_uint = 0x6f5;
pub const XK_Cyrillic_ZHE: c_uint = 0x6f6;
pub const XK_Cyrillic_VE: c_uint = 0x6f7;
pub const XK_Cyrillic_SOFTSIGN: c_uint = 0x6f8;
pub const XK_Cyrillic_YERU: c_uint = 0x6f9;
pub const XK_Cyrillic_ZE: c_uint = 0x6fa;
pub const XK_Cyrillic_SHA: c_uint = 0x6fb;
pub const XK_Cyrillic_E: c_uint = 0x6fc;
pub const XK_Cyrillic_SHCHA: c_uint = 0x6fd;
pub const XK_Cyrillic_CHE: c_uint = 0x6fe;
pub const XK_Cyrillic_HARDSIGN: c_uint = 0x6ff;
pub const XK_Greek_ALPHAaccent: c_uint = 0x7a1;
pub const XK_Greek_EPSILONaccent: c_uint = 0x7a2;
pub const XK_Greek_ETAaccent: c_uint = 0x7a3;
pub const XK_Greek_IOTAaccent: c_uint = 0x7a4;
pub const XK_Greek_IOTAdiaeresis: c_uint = 0x7a5;
pub const XK_Greek_OMICRONaccent: c_uint = 0x7a7;
pub const XK_Greek_UPSILONaccent: c_uint = 0x7a8;
pub const XK_Greek_UPSILONdieresis: c_uint = 0x7a9;
pub const XK_Greek_OMEGAaccent: c_uint = 0x7ab;
pub const XK_Greek_accentdieresis: c_uint = 0x7ae;
pub const XK_Greek_horizbar: c_uint = 0x7af;
pub const XK_Greek_alphaaccent: c_uint = 0x7b1;
pub const XK_Greek_epsilonaccent: c_uint = 0x7b2;
pub const XK_Greek_etaaccent: c_uint = 0x7b3;
pub const XK_Greek_iotaaccent: c_uint = 0x7b4;
pub const XK_Greek_iotadieresis: c_uint = 0x7b5;
pub const XK_Greek_iotaaccentdieresis: c_uint = 0x7b6;
pub const XK_Greek_omicronaccent: c_uint = 0x7b7;
pub const XK_Greek_upsilonaccent: c_uint = 0x7b8;
pub const XK_Greek_upsilondieresis: c_uint = 0x7b9;
pub const XK_Greek_upsilonaccentdieresis: c_uint = 0x7ba;
pub const XK_Greek_omegaaccent: c_uint = 0x7bb;
pub const XK_Greek_ALPHA: c_uint = 0x7c1;
pub const XK_Greek_BETA: c_uint = 0x7c2;
pub const XK_Greek_GAMMA: c_uint = 0x7c3;
pub const XK_Greek_DELTA: c_uint = 0x7c4;
pub const XK_Greek_EPSILON: c_uint = 0x7c5;
pub const XK_Greek_ZETA: c_uint = 0x7c6;
pub const XK_Greek_ETA: c_uint = 0x7c7;
pub const XK_Greek_THETA: c_uint = 0x7c8;
pub const XK_Greek_IOTA: c_uint = 0x7c9;
pub const XK_Greek_KAPPA: c_uint = 0x7ca;
pub const XK_Greek_LAMDA: c_uint = 0x7cb;
pub const XK_Greek_LAMBDA: c_uint = 0x7cb;
pub const XK_Greek_MU: c_uint = 0x7cc;
pub const XK_Greek_NU: c_uint = 0x7cd;
pub const XK_Greek_XI: c_uint = 0x7ce;
pub const XK_Greek_OMICRON: c_uint = 0x7cf;
pub const XK_Greek_PI: c_uint = 0x7d0;
pub const XK_Greek_RHO: c_uint = 0x7d1;
pub const XK_Greek_SIGMA: c_uint = 0x7d2;
pub const XK_Greek_TAU: c_uint = 0x7d4;
pub const XK_Greek_UPSILON: c_uint = 0x7d5;
pub const XK_Greek_PHI: c_uint = 0x7d6;
pub const XK_Greek_CHI: c_uint = 0x7d7;
pub const XK_Greek_PSI: c_uint = 0x7d8;
pub const XK_Greek_OMEGA: c_uint = 0x7d9;
pub const XK_Greek_alpha: c_uint = 0x7e1;
pub const XK_Greek_beta: c_uint = 0x7e2;
pub const XK_Greek_gamma: c_uint = 0x7e3;
pub const XK_Greek_delta: c_uint = 0x7e4;
pub const XK_Greek_epsilon: c_uint = 0x7e5;
pub const XK_Greek_zeta: c_uint = 0x7e6;
pub const XK_Greek_eta: c_uint = 0x7e7;
pub const XK_Greek_theta: c_uint = 0x7e8;
pub const XK_Greek_iota: c_uint = 0x7e9;
pub const XK_Greek_kappa: c_uint = 0x7ea;
pub const XK_Greek_lamda: c_uint = 0x7eb;
pub const XK_Greek_lambda: c_uint = 0x7eb;
pub const XK_Greek_mu: c_uint = 0x7ec;
pub const XK_Greek_nu: c_uint = 0x7ed;
pub const XK_Greek_xi: c_uint = 0x7ee;
pub const XK_Greek_omicron: c_uint = 0x7ef;
pub const XK_Greek_pi: c_uint = 0x7f0;
pub const XK_Greek_rho: c_uint = 0x7f1;
pub const XK_Greek_sigma: c_uint = 0x7f2;
pub const XK_Greek_finalsmallsigma: c_uint = 0x7f3;
pub const XK_Greek_tau: c_uint = 0x7f4;
pub const XK_Greek_upsilon: c_uint = 0x7f5;
pub const XK_Greek_phi: c_uint = 0x7f6;
pub const XK_Greek_chi: c_uint = 0x7f7;
pub const XK_Greek_psi: c_uint = 0x7f8;
pub const XK_Greek_omega: c_uint = 0x7f9;
pub const XK_Greek_switch: c_uint = 0xFF7E;
pub const XK_leftradical: c_uint = 0x8a1;
pub const XK_topleftradical: c_uint = 0x8a2;
pub const XK_horizconnector: c_uint = 0x8a3;
pub const XK_topintegral: c_uint = 0x8a4;
pub const XK_botintegral: c_uint = 0x8a5;
pub const XK_vertconnector: c_uint = 0x8a6;
pub const XK_topleftsqbracket: c_uint = 0x8a7;
pub const XK_botleftsqbracket: c_uint = 0x8a8;
pub const XK_toprightsqbracket: c_uint = 0x8a9;
pub const XK_botrightsqbracket: c_uint = 0x8aa;
pub const XK_topleftparens: c_uint = 0x8ab;
pub const XK_botleftparens: c_uint = 0x8ac;
pub const XK_toprightparens: c_uint = 0x8ad;
pub const XK_botrightparens: c_uint = 0x8ae;
pub const XK_leftmiddlecurlybrace: c_uint = 0x8af;
pub const XK_rightmiddlecurlybrace: c_uint = 0x8b0;
pub const XK_topleftsummation: c_uint = 0x8b1;
pub const XK_botleftsummation: c_uint = 0x8b2;
pub const XK_topvertsummationconnector: c_uint = 0x8b3;
pub const XK_botvertsummationconnector: c_uint = 0x8b4;
pub const XK_toprightsummation: c_uint = 0x8b5;
pub const XK_botrightsummation: c_uint = 0x8b6;
pub const XK_rightmiddlesummation: c_uint = 0x8b7;
pub const XK_lessthanequal: c_uint = 0x8bc;
pub const XK_notequal: c_uint = 0x8bd;
pub const XK_greaterthanequal: c_uint = 0x8be;
pub const XK_integral: c_uint = 0x8bf;
pub const XK_therefore: c_uint = 0x8c0;
pub const XK_variation: c_uint = 0x8c1;
pub const XK_infinity: c_uint = 0x8c2;
pub const XK_nabla: c_uint = 0x8c5;
pub const XK_approximate: c_uint = 0x8c8;
pub const XK_similarequal: c_uint = 0x8c9;
pub const XK_ifonlyif: c_uint = 0x8cd;
pub const XK_implies: c_uint = 0x8ce;
pub const XK_identical: c_uint = 0x8cf;
pub const XK_radical: c_uint = 0x8d6;
pub const XK_includedin: c_uint = 0x8da;
pub const XK_includes: c_uint = 0x8db;
pub const XK_intersection: c_uint = 0x8dc;
pub const XK_union: c_uint = 0x8dd;
pub const XK_logicaland: c_uint = 0x8de;
pub const XK_logicalor: c_uint = 0x8df;
pub const XK_partialderivative: c_uint = 0x8ef;
pub const XK_function: c_uint = 0x8f6;
pub const XK_leftarrow: c_uint = 0x8fb;
pub const XK_uparrow: c_uint = 0x8fc;
pub const XK_rightarrow: c_uint = 0x8fd;
pub const XK_downarrow: c_uint = 0x8fe;
pub const XK_blank: c_uint = 0x9df;
pub const XK_soliddiamond: c_uint = 0x9e0;
pub const XK_checkerboard: c_uint = 0x9e1;
pub const XK_ht: c_uint = 0x9e2;
pub const XK_ff: c_uint = 0x9e3;
pub const XK_cr: c_uint = 0x9e4;
pub const XK_lf: c_uint = 0x9e5;
pub const XK_nl: c_uint = 0x9e8;
pub const XK_vt: c_uint = 0x9e9;
pub const XK_lowrightcorner: c_uint = 0x9ea;
pub const XK_uprightcorner: c_uint = 0x9eb;
pub const XK_upleftcorner: c_uint = 0x9ec;
pub const XK_lowleftcorner: c_uint = 0x9ed;
pub const XK_crossinglines: c_uint = 0x9ee;
pub const XK_horizlinescan1: c_uint = 0x9ef;
pub const XK_horizlinescan3: c_uint = 0x9f0;
pub const XK_horizlinescan5: c_uint = 0x9f1;
pub const XK_horizlinescan7: c_uint = 0x9f2;
pub const XK_horizlinescan9: c_uint = 0x9f3;
pub const XK_leftt: c_uint = 0x9f4;
pub const XK_rightt: c_uint = 0x9f5;
pub const XK_bott: c_uint = 0x9f6;
pub const XK_topt: c_uint = 0x9f7;
pub const XK_vertbar: c_uint = 0x9f8;
pub const XK_emspace: c_uint = 0xaa1;
pub const XK_enspace: c_uint = 0xaa2;
pub const XK_em3space: c_uint = 0xaa3;
pub const XK_em4space: c_uint = 0xaa4;
pub const XK_digitspace: c_uint = 0xaa5;
pub const XK_punctspace: c_uint = 0xaa6;
pub const XK_thinspace: c_uint = 0xaa7;
pub const XK_hairspace: c_uint = 0xaa8;
pub const XK_emdash: c_uint = 0xaa9;
pub const XK_endash: c_uint = 0xaaa;
pub const XK_signifblank: c_uint = 0xaac;
pub const XK_ellipsis: c_uint = 0xaae;
pub const XK_doubbaselinedot: c_uint = 0xaaf;
pub const XK_onethird: c_uint = 0xab0;
pub const XK_twothirds: c_uint = 0xab1;
pub const XK_onefifth: c_uint = 0xab2;
pub const XK_twofifths: c_uint = 0xab3;
pub const XK_threefifths: c_uint = 0xab4;
pub const XK_fourfifths: c_uint = 0xab5;
pub const XK_onesixth: c_uint = 0xab6;
pub const XK_fivesixths: c_uint = 0xab7;
pub const XK_careof: c_uint = 0xab8;
pub const XK_figdash: c_uint = 0xabb;
pub const XK_leftanglebracket: c_uint = 0xabc;
pub const XK_decimalpoint: c_uint = 0xabd;
pub const XK_rightanglebracket: c_uint = 0xabe;
pub const XK_marker: c_uint = 0xabf;
pub const XK_oneeighth: c_uint = 0xac3;
pub const XK_threeeighths: c_uint = 0xac4;
pub const XK_fiveeighths: c_uint = 0xac5;
pub const XK_seveneighths: c_uint = 0xac6;
pub const XK_trademark: c_uint = 0xac9;
pub const XK_signaturemark: c_uint = 0xaca;
pub const XK_trademarkincircle: c_uint = 0xacb;
pub const XK_leftopentriangle: c_uint = 0xacc;
pub const XK_rightopentriangle: c_uint = 0xacd;
pub const XK_emopencircle: c_uint = 0xace;
pub const XK_emopenrectangle: c_uint = 0xacf;
pub const XK_leftsinglequotemark: c_uint = 0xad0;
pub const XK_rightsinglequotemark: c_uint = 0xad1;
pub const XK_leftdoublequotemark: c_uint = 0xad2;
pub const XK_rightdoublequotemark: c_uint = 0xad3;
pub const XK_prescription: c_uint = 0xad4;
pub const XK_minutes: c_uint = 0xad6;
pub const XK_seconds: c_uint = 0xad7;
pub const XK_latincross: c_uint = 0xad9;
pub const XK_hexagram: c_uint = 0xada;
pub const XK_filledrectbullet: c_uint = 0xadb;
pub const XK_filledlefttribullet: c_uint = 0xadc;
pub const XK_filledrighttribullet: c_uint = 0xadd;
pub const XK_emfilledcircle: c_uint = 0xade;
pub const XK_emfilledrect: c_uint = 0xadf;
pub const XK_enopencircbullet: c_uint = 0xae0;
pub const XK_enopensquarebullet: c_uint = 0xae1;
pub const XK_openrectbullet: c_uint = 0xae2;
pub const XK_opentribulletup: c_uint = 0xae3;
pub const XK_opentribulletdown: c_uint = 0xae4;
pub const XK_openstar: c_uint = 0xae5;
pub const XK_enfilledcircbullet: c_uint = 0xae6;
pub const XK_enfilledsqbullet: c_uint = 0xae7;
pub const XK_filledtribulletup: c_uint = 0xae8;
pub const XK_filledtribulletdown: c_uint = 0xae9;
pub const XK_leftpointer: c_uint = 0xaea;
pub const XK_rightpointer: c_uint = 0xaeb;
pub const XK_club: c_uint = 0xaec;
pub const XK_diamond: c_uint = 0xaed;
pub const XK_heart: c_uint = 0xaee;
pub const XK_maltesecross: c_uint = 0xaf0;
pub const XK_dagger: c_uint = 0xaf1;
pub const XK_doubledagger: c_uint = 0xaf2;
pub const XK_checkmark: c_uint = 0xaf3;
pub const XK_ballotcross: c_uint = 0xaf4;
pub const XK_musicalsharp: c_uint = 0xaf5;
pub const XK_musicalflat: c_uint = 0xaf6;
pub const XK_malesymbol: c_uint = 0xaf7;
pub const XK_femalesymbol: c_uint = 0xaf8;
pub const XK_telephone: c_uint = 0xaf9;
pub const XK_telephonerecorder: c_uint = 0xafa;
pub const XK_phonographcopyright: c_uint = 0xafb;
pub const XK_caret: c_uint = 0xafc;
pub const XK_singlelowquotemark: c_uint = 0xafd;
pub const XK_doublelowquotemark: c_uint = 0xafe;
pub const XK_cursor: c_uint = 0xaff;
pub const XK_leftcaret: c_uint = 0xba3;
pub const XK_rightcaret: c_uint = 0xba6;
pub const XK_downcaret: c_uint = 0xba8;
pub const XK_upcaret: c_uint = 0xba9;
pub const XK_overbar: c_uint = 0xbc0;
pub const XK_downtack: c_uint = 0xbc2;
pub const XK_upshoe: c_uint = 0xbc3;
pub const XK_downstile: c_uint = 0xbc4;
pub const XK_underbar: c_uint = 0xbc6;
pub const XK_jot: c_uint = 0xbca;
pub const XK_quad: c_uint = 0xbcc;
pub const XK_uptack: c_uint = 0xbce;
pub const XK_circle: c_uint = 0xbcf;
pub const XK_upstile: c_uint = 0xbd3;
pub const XK_downshoe: c_uint = 0xbd6;
pub const XK_rightshoe: c_uint = 0xbd8;
pub const XK_leftshoe: c_uint = 0xbda;
pub const XK_lefttack: c_uint = 0xbdc;
pub const XK_righttack: c_uint = 0xbfc;
pub const XK_hebrew_doublelowline: c_uint = 0xcdf;
pub const XK_hebrew_aleph: c_uint = 0xce0;
pub const XK_hebrew_bet: c_uint = 0xce1;
pub const XK_hebrew_beth: c_uint = 0xce1;
pub const XK_hebrew_gimel: c_uint = 0xce2;
pub const XK_hebrew_gimmel: c_uint = 0xce2;
pub const XK_hebrew_dalet: c_uint = 0xce3;
pub const XK_hebrew_daleth: c_uint = 0xce3;
pub const XK_hebrew_he: c_uint = 0xce4;
pub const XK_hebrew_waw: c_uint = 0xce5;
pub const XK_hebrew_zain: c_uint = 0xce6;
pub const XK_hebrew_zayin: c_uint = 0xce6;
pub const XK_hebrew_chet: c_uint = 0xce7;
pub const XK_hebrew_het: c_uint = 0xce7;
pub const XK_hebrew_tet: c_uint = 0xce8;
pub const XK_hebrew_teth: c_uint = 0xce8;
pub const XK_hebrew_yod: c_uint = 0xce9;
pub const XK_hebrew_finalkaph: c_uint = 0xcea;
pub const XK_hebrew_kaph: c_uint = 0xceb;
pub const XK_hebrew_lamed: c_uint = 0xcec;
pub const XK_hebrew_finalmem: c_uint = 0xced;
pub const XK_hebrew_mem: c_uint = 0xcee;
pub const XK_hebrew_finalnun: c_uint = 0xcef;
pub const XK_hebrew_nun: c_uint = 0xcf0;
pub const XK_hebrew_samech: c_uint = 0xcf1;
pub const XK_hebrew_samekh: c_uint = 0xcf1;
pub const XK_hebrew_ayin: c_uint = 0xcf2;
pub const XK_hebrew_finalpe: c_uint = 0xcf3;
pub const XK_hebrew_pe: c_uint = 0xcf4;
pub const XK_hebrew_finalzade: c_uint = 0xcf5;
pub const XK_hebrew_finalzadi: c_uint = 0xcf5;
pub const XK_hebrew_zade: c_uint = 0xcf6;
pub const XK_hebrew_zadi: c_uint = 0xcf6;
pub const XK_hebrew_qoph: c_uint = 0xcf7;
pub const XK_hebrew_kuf: c_uint = 0xcf7;
pub const XK_hebrew_resh: c_uint = 0xcf8;
pub const XK_hebrew_shin: c_uint = 0xcf9;
pub const XK_hebrew_taw: c_uint = 0xcfa;
pub const XK_hebrew_taf: c_uint = 0xcfa;
pub const XK_Hebrew_switch: c_uint = 0xFF7E;

pub const XF86XK_ModeLock: c_uint = 0x1008FF01;
pub const XF86XK_MonBrightnessUp: c_uint = 0x1008FF02;
pub const XF86XK_MonBrightnessDown: c_uint = 0x1008FF03;
pub const XF86XK_KbdLightOnOff: c_uint = 0x1008FF04;
pub const XF86XK_KbdBrightnessUp: c_uint = 0x1008FF05;
pub const XF86XK_KbdBrightnessDown: c_uint = 0x1008FF06;
pub const XF86XK_Standby: c_uint = 0x1008FF10;
pub const XF86XK_AudioLowerVolume: c_uint = 0x1008FF11;
pub const XF86XK_AudioMute: c_uint = 0x1008FF12;
pub const XF86XK_AudioRaiseVolume: c_uint = 0x1008FF13;
pub const XF86XK_AudioPlay: c_uint = 0x1008FF14;
pub const XF86XK_AudioStop: c_uint = 0x1008FF15;
pub const XF86XK_AudioPrev: c_uint = 0x1008FF16;
pub const XF86XK_AudioNext: c_uint = 0x1008FF17;
pub const XF86XK_HomePage: c_uint = 0x1008FF18;
pub const XF86XK_Mail: c_uint = 0x1008FF19;
pub const XF86XK_Start: c_uint = 0x1008FF1A;
pub const XF86XK_Search: c_uint = 0x1008FF1B;
pub const XF86XK_AudioRecord: c_uint = 0x1008FF1C;
pub const XF86XK_Calculator: c_uint = 0x1008FF1D;
pub const XF86XK_Memo: c_uint = 0x1008FF1E;
pub const XF86XK_ToDoList: c_uint = 0x1008FF1F;
pub const XF86XK_Calendar: c_uint = 0x1008FF20;
pub const XF86XK_PowerDown: c_uint = 0x1008FF21;
pub const XF86XK_ContrastAdjust: c_uint = 0x1008FF22;
pub const XF86XK_RockerUp: c_uint = 0x1008FF23;
pub const XF86XK_RockerDown: c_uint = 0x1008FF24;
pub const XF86XK_RockerEnter: c_uint = 0x1008FF25;
pub const XF86XK_Back: c_uint = 0x1008FF26;
pub const XF86XK_Forward: c_uint = 0x1008FF27;
pub const XF86XK_Stop: c_uint = 0x1008FF28;
pub const XF86XK_Refresh: c_uint = 0x1008FF29;
pub const XF86XK_PowerOff: c_uint = 0x1008FF2A;
pub const XF86XK_WakeUp: c_uint = 0x1008FF2B;
pub const XF86XK_Eject: c_uint = 0x1008FF2C;
pub const XF86XK_ScreenSaver: c_uint = 0x1008FF2D;
pub const XF86XK_WWW: c_uint = 0x1008FF2E;
pub const XF86XK_Sleep: c_uint = 0x1008FF2F;
pub const XF86XK_Favorites: c_uint = 0x1008FF30;
pub const XF86XK_AudioPause: c_uint = 0x1008FF31;
pub const XF86XK_AudioMedia: c_uint = 0x1008FF32;
pub const XF86XK_MyComputer: c_uint = 0x1008FF33;
pub const XF86XK_VendorHome: c_uint = 0x1008FF34;
pub const XF86XK_LightBulb: c_uint = 0x1008FF35;
pub const XF86XK_Shop: c_uint = 0x1008FF36;
pub const XF86XK_History: c_uint = 0x1008FF37;
pub const XF86XK_OpenURL: c_uint = 0x1008FF38;
pub const XF86XK_AddFavorite: c_uint = 0x1008FF39;
pub const XF86XK_HotLinks: c_uint = 0x1008FF3A;
pub const XF86XK_BrightnessAdjust: c_uint = 0x1008FF3B;
pub const XF86XK_Finance: c_uint = 0x1008FF3C;
pub const XF86XK_Community: c_uint = 0x1008FF3D;
pub const XF86XK_AudioRewind: c_uint = 0x1008FF3E;
pub const XF86XK_BackForward: c_uint = 0x1008FF3F;
pub const XF86XK_Launch0: c_uint = 0x1008FF40;
pub const XF86XK_Launch1: c_uint = 0x1008FF41;
pub const XF86XK_Launch2: c_uint = 0x1008FF42;
pub const XF86XK_Launch3: c_uint = 0x1008FF43;
pub const XF86XK_Launch4: c_uint = 0x1008FF44;
pub const XF86XK_Launch5: c_uint = 0x1008FF45;
pub const XF86XK_Launch6: c_uint = 0x1008FF46;
pub const XF86XK_Launch7: c_uint = 0x1008FF47;
pub const XF86XK_Launch8: c_uint = 0x1008FF48;
pub const XF86XK_Launch9: c_uint = 0x1008FF49;
pub const XF86XK_LaunchA: c_uint = 0x1008FF4A;
pub const XF86XK_LaunchB: c_uint = 0x1008FF4B;
pub const XF86XK_LaunchC: c_uint = 0x1008FF4C;
pub const XF86XK_LaunchD: c_uint = 0x1008FF4D;
pub const XF86XK_LaunchE: c_uint = 0x1008FF4E;
pub const XF86XK_LaunchF: c_uint = 0x1008FF4F;
pub const XF86XK_ApplicationLeft: c_uint = 0x1008FF50;
pub const XF86XK_ApplicationRight: c_uint = 0x1008FF51;
pub const XF86XK_Book: c_uint = 0x1008FF52;
pub const XF86XK_CD: c_uint = 0x1008FF53;
pub const XF86XK_Calculater: c_uint = 0x1008FF54;
pub const XF86XK_Clear: c_uint = 0x1008FF55;
pub const XF86XK_Close: c_uint = 0x1008FF56;
pub const XF86XK_Copy: c_uint = 0x1008FF57;
pub const XF86XK_Cut: c_uint = 0x1008FF58;
pub const XF86XK_Display: c_uint = 0x1008FF59;
pub const XF86XK_DOS: c_uint = 0x1008FF5A;
pub const XF86XK_Documents: c_uint = 0x1008FF5B;
pub const XF86XK_Excel: c_uint = 0x1008FF5C;
pub const XF86XK_Explorer: c_uint = 0x1008FF5D;
pub const XF86XK_Game: c_uint = 0x1008FF5E;
pub const XF86XK_Go: c_uint = 0x1008FF5F;
pub const XF86XK_iTouch: c_uint = 0x1008FF60;
pub const XF86XK_LogOff: c_uint = 0x1008FF61;
pub const XF86XK_Market: c_uint = 0x1008FF62;
pub const XF86XK_Meeting: c_uint = 0x1008FF63;
pub const XF86XK_MenuKB: c_uint = 0x1008FF65;
pub const XF86XK_MenuPB: c_uint = 0x1008FF66;
pub const XF86XK_MySites: c_uint = 0x1008FF67;
pub const XF86XK_New: c_uint = 0x1008FF68;
pub const XF86XK_News: c_uint = 0x1008FF69;
pub const XF86XK_OfficeHome: c_uint = 0x1008FF6A;
pub const XF86XK_Open: c_uint = 0x1008FF6B;
pub const XF86XK_Option: c_uint = 0x1008FF6C;
pub const XF86XK_Paste: c_uint = 0x1008FF6D;
pub const XF86XK_Phone: c_uint = 0x1008FF6E;
pub const XF86XK_Q: c_uint = 0x1008FF70;
pub const XF86XK_Reply: c_uint = 0x1008FF72;
pub const XF86XK_Reload: c_uint = 0x1008FF73;
pub const XF86XK_RotateWindows: c_uint = 0x1008FF74;
pub const XF86XK_RotationPB: c_uint = 0x1008FF75;
pub const XF86XK_RotationKB: c_uint = 0x1008FF76;
pub const XF86XK_Save: c_uint = 0x1008FF77;
pub const XF86XK_ScrollUp: c_uint = 0x1008FF78;
pub const XF86XK_ScrollDown: c_uint = 0x1008FF79;
pub const XF86XK_ScrollClick: c_uint = 0x1008FF7A;
pub const XF86XK_Send: c_uint = 0x1008FF7B;
pub const XF86XK_Spell: c_uint = 0x1008FF7C;
pub const XF86XK_SplitScreen: c_uint = 0x1008FF7D;
pub const XF86XK_Support: c_uint = 0x1008FF7E;
pub const XF86XK_TaskPane: c_uint = 0x1008FF7F;
pub const XF86XK_Terminal: c_uint = 0x1008FF80;
pub const XF86XK_Tools: c_uint = 0x1008FF81;
pub const XF86XK_Travel: c_uint = 0x1008FF82;
pub const XF86XK_UserPB: c_uint = 0x1008FF84;
pub const XF86XK_User1KB: c_uint = 0x1008FF85;
pub const XF86XK_User2KB: c_uint = 0x1008FF86;
pub const XF86XK_Video: c_uint = 0x1008FF87;
pub const XF86XK_WheelButton: c_uint = 0x1008FF88;
pub const XF86XK_Word: c_uint = 0x1008FF89;
pub const XF86XK_Xfer: c_uint = 0x1008FF8A;
pub const XF86XK_ZoomIn: c_uint = 0x1008FF8B;
pub const XF86XK_ZoomOut: c_uint = 0x1008FF8C;
pub const XF86XK_Away: c_uint = 0x1008FF8D;
pub const XF86XK_Messenger: c_uint = 0x1008FF8E;
pub const XF86XK_WebCam: c_uint = 0x1008FF8F;
pub const XF86XK_MailForward: c_uint = 0x1008FF90;
pub const XF86XK_Pictures: c_uint = 0x1008FF91;
pub const XF86XK_Music: c_uint = 0x1008FF92;
pub const XF86XK_Battery: c_uint = 0x1008FF93;
pub const XF86XK_Bluetooth: c_uint = 0x1008FF94;
pub const XF86XK_WLAN: c_uint = 0x1008FF95;
pub const XF86XK_UWB: c_uint = 0x1008FF96;
pub const XF86XK_AudioForward: c_uint = 0x1008FF97;
pub const XF86XK_AudioRepeat: c_uint = 0x1008FF98;
pub const XF86XK_AudioRandomPlay: c_uint = 0x1008FF99;
pub const XF86XK_Subtitle: c_uint = 0x1008FF9A;
pub const XF86XK_AudioCycleTrack: c_uint = 0x1008FF9B;
pub const XF86XK_CycleAngle: c_uint = 0x1008FF9C;
pub const XF86XK_FrameBack: c_uint = 0x1008FF9D;
pub const XF86XK_FrameForward: c_uint = 0x1008FF9E;
pub const XF86XK_Time: c_uint = 0x1008FF9F;
pub const XF86XK_Select: c_uint = 0x1008FFA0;
pub const XF86XK_View: c_uint = 0x1008FFA1;
pub const XF86XK_TopMenu: c_uint = 0x1008FFA2;
pub const XF86XK_Red: c_uint = 0x1008FFA3;
pub const XF86XK_Green: c_uint = 0x1008FFA4;
pub const XF86XK_Yellow: c_uint = 0x1008FFA5;
pub const XF86XK_Blue: c_uint = 0x1008FFA6;
pub const XF86XK_Suspend: c_uint = 0x1008FFA7;
pub const XF86XK_Hibernate: c_uint = 0x1008FFA8;
pub const XF86XK_TouchpadToggle: c_uint = 0x1008FFA9;
pub const XF86XK_TouchpadOn: c_uint = 0x1008FFB0;
pub const XF86XK_TouchpadOff: c_uint = 0x1008FFB1;
pub const XF86XK_AudioMicMute: c_uint = 0x1008FFB2;
pub const XF86XK_Switch_VT_1: c_uint = 0x1008FE01;
pub const XF86XK_Switch_VT_2: c_uint = 0x1008FE02;
pub const XF86XK_Switch_VT_3: c_uint = 0x1008FE03;
pub const XF86XK_Switch_VT_4: c_uint = 0x1008FE04;
pub const XF86XK_Switch_VT_5: c_uint = 0x1008FE05;
pub const XF86XK_Switch_VT_6: c_uint = 0x1008FE06;
pub const XF86XK_Switch_VT_7: c_uint = 0x1008FE07;
pub const XF86XK_Switch_VT_8: c_uint = 0x1008FE08;
pub const XF86XK_Switch_VT_9: c_uint = 0x1008FE09;
pub const XF86XK_Switch_VT_10: c_uint = 0x1008FE0A;
pub const XF86XK_Switch_VT_11: c_uint = 0x1008FE0B;
pub const XF86XK_Switch_VT_12: c_uint = 0x1008FE0C;
pub const XF86XK_Ungrab: c_uint = 0x1008FE20;
pub const XF86XK_ClearGrab: c_uint = 0x1008FE21;
pub const XF86XK_Next_VMode: c_uint = 0x1008FE22;
pub const XF86XK_Prev_VMode: c_uint = 0x1008FE23;
pub const XF86XK_LogWindowTree: c_uint = 0x1008FE24;
pub const XF86XK_LogGrabInfo: c_uint = 0x1008FE25;

pub const XK_ISO_Lock: c_uint = 0xfe01;
pub const XK_ISO_Level2_Latch: c_uint = 0xfe02;
pub const XK_ISO_Level3_Shift: c_uint = 0xfe03;
pub const XK_ISO_Level3_Latch: c_uint = 0xfe04;
pub const XK_ISO_Level3_Lock: c_uint = 0xfe05;
pub const XK_ISO_Level5_Shift: c_uint = 0xfe11;
pub const XK_ISO_Level5_Latch: c_uint = 0xfe12;
pub const XK_ISO_Level5_Lock: c_uint = 0xfe13;
pub const XK_ISO_Group_Shift: c_uint = 0xff7e;
pub const XK_ISO_Group_Latch: c_uint = 0xfe06;
pub const XK_ISO_Group_Lock: c_uint = 0xfe07;
pub const XK_ISO_Next_Group: c_uint = 0xfe08;
pub const XK_ISO_Next_Group_Lock: c_uint = 0xfe09;
pub const XK_ISO_Prev_Group: c_uint = 0xfe0a;
pub const XK_ISO_Prev_Group_Lock: c_uint = 0xfe0b;
pub const XK_ISO_First_Group: c_uint = 0xfe0c;
pub const XK_ISO_First_Group_Lock: c_uint = 0xfe0d;
pub const XK_ISO_Last_Group: c_uint = 0xfe0e;
pub const XK_ISO_Last_Group_Lock: c_uint = 0xfe0f;

pub const XK_ISO_Left_Tab: c_uint = 0xfe20;
pub const XK_ISO_Move_Line_Up: c_uint = 0xfe21;
pub const XK_ISO_Move_Line_Down: c_uint = 0xfe22;
pub const XK_ISO_Partial_Line_Up: c_uint = 0xfe23;
pub const XK_ISO_Partial_Line_Down: c_uint = 0xfe24;
pub const XK_ISO_Partial_Space_Left: c_uint = 0xfe25;
pub const XK_ISO_Partial_Space_Right: c_uint = 0xfe26;
pub const XK_ISO_Set_Margin_Left: c_uint = 0xfe27;
pub const XK_ISO_Set_Margin_Right: c_uint = 0xfe28;
pub const XK_ISO_Release_Margin_Left: c_uint = 0xfe29;
pub const XK_ISO_Release_Margin_Right: c_uint = 0xfe2a;
pub const XK_ISO_Release_Both_Margins: c_uint = 0xfe2b;
pub const XK_ISO_Fast_Cursor_Left: c_uint = 0xfe2c;
pub const XK_ISO_Fast_Cursor_Right: c_uint = 0xfe2d;
pub const XK_ISO_Fast_Cursor_Up: c_uint = 0xfe2e;
pub const XK_ISO_Fast_Cursor_Down: c_uint = 0xfe2f;
pub const XK_ISO_Continuous_Underline: c_uint = 0xfe30;
pub const XK_ISO_Discontinuous_Underline: c_uint = 0xfe31;
pub const XK_ISO_Emphasize: c_uint = 0xfe32;
pub const XK_ISO_Center_Object: c_uint = 0xfe33;
pub const XK_ISO_Enter: c_uint = 0xfe34;

pub const XK_dead_grave: c_uint = 0xfe50;
pub const XK_dead_acute: c_uint = 0xfe51;
pub const XK_dead_circumflex: c_uint = 0xfe52;
pub const XK_dead_tilde: c_uint = 0xfe53;
pub const XK_dead_perispomeni: c_uint = 0xfe53;
pub const XK_dead_macron: c_uint = 0xfe54;
pub const XK_dead_breve: c_uint = 0xfe55;
pub const XK_dead_abovedot: c_uint = 0xfe56;
pub const XK_dead_diaeresis: c_uint = 0xfe57;
pub const XK_dead_abovering: c_uint = 0xfe58;
pub const XK_dead_doubleacute: c_uint = 0xfe59;
pub const XK_dead_caron: c_uint = 0xfe5a;
pub const XK_dead_cedilla: c_uint = 0xfe5b;
pub const XK_dead_ogonek: c_uint = 0xfe5c;
pub const XK_dead_iota: c_uint = 0xfe5d;
pub const XK_dead_voiced_sound: c_uint = 0xfe5e;
pub const XK_dead_semivoiced_sound: c_uint = 0xfe5f;
pub const XK_dead_belowdot: c_uint = 0xfe60;
pub const XK_dead_hook: c_uint = 0xfe61;
pub const XK_dead_horn: c_uint = 0xfe62;
pub const XK_dead_stroke: c_uint = 0xfe63;
pub const XK_dead_abovecomma: c_uint = 0xfe64;
pub const XK_dead_psili: c_uint = 0xfe64;
pub const XK_dead_abovereversedcomma: c_uint = 0xfe65;
pub const XK_dead_dasia: c_uint = 0xfe65;
pub const XK_dead_doublegrave: c_uint = 0xfe66;
pub const XK_dead_belowring: c_uint = 0xfe67;
pub const XK_dead_belowmacron: c_uint = 0xfe68;
pub const XK_dead_belowcircumflex: c_uint = 0xfe69;
pub const XK_dead_belowtilde: c_uint = 0xfe6a;
pub const XK_dead_belowbreve: c_uint = 0xfe6b;
pub const XK_dead_belowdiaeresis: c_uint = 0xfe6c;
pub const XK_dead_invertedbreve: c_uint = 0xfe6d;
pub const XK_dead_belowcomma: c_uint = 0xfe6e;
pub const XK_dead_currency: c_uint = 0xfe6f;

pub const XK_dead_lowline: c_uint = 0xfe90;
pub const XK_dead_aboveverticalline: c_uint = 0xfe91;
pub const XK_dead_belowverticalline: c_uint = 0xfe92;
pub const XK_dead_longsolidusoverlay: c_uint = 0xfe93;

pub const XK_dead_a: c_uint = 0xfe80;
pub const XK_dead_A: c_uint = 0xfe81;
pub const XK_dead_e: c_uint = 0xfe82;
pub const XK_dead_E: c_uint = 0xfe83;
pub const XK_dead_i: c_uint = 0xfe84;
pub const XK_dead_I: c_uint = 0xfe85;
pub const XK_dead_o: c_uint = 0xfe86;
pub const XK_dead_O: c_uint = 0xfe87;
pub const XK_dead_u: c_uint = 0xfe88;
pub const XK_dead_U: c_uint = 0xfe89;
pub const XK_dead_small_schwa: c_uint = 0xfe8a;
pub const XK_dead_capital_schwa: c_uint = 0xfe8b;

pub const XK_dead_greek: c_uint = 0xfe8c;

pub const XK_First_Virtual_Screen: c_uint = 0xfed0;
pub const XK_Prev_Virtual_Screen: c_uint = 0xfed1;
pub const XK_Next_Virtual_Screen: c_uint = 0xfed2;
pub const XK_Last_Virtual_Screen: c_uint = 0xfed4;
pub const XK_Terminate_Server: c_uint = 0xfed5;

pub const XK_AccessX_Enable: c_uint = 0xfe70;
pub const XK_AccessX_Feedback_Enable: c_uint = 0xfe71;
pub const XK_RepeatKeys_Enable: c_uint = 0xfe72;
pub const XK_SlowKeys_Enable: c_uint = 0xfe73;
pub const XK_BounceKeys_Enable: c_uint = 0xfe74;
pub const XK_StickyKeys_Enable: c_uint = 0xfe75;
pub const XK_MouseKeys_Enable: c_uint = 0xfe76;
pub const XK_MouseKeys_Accel_Enable: c_uint = 0xfe77;
pub const XK_Overlay1_Enable: c_uint = 0xfe78;
pub const XK_Overlay2_Enable: c_uint = 0xfe79;
pub const XK_AudibleBell_Enable: c_uint = 0xfe7a;

pub const XK_Pointer_Left: c_uint = 0xfee0;
pub const XK_Pointer_Right: c_uint = 0xfee1;
pub const XK_Pointer_Up: c_uint = 0xfee2;
pub const XK_Pointer_Down: c_uint = 0xfee3;
pub const XK_Pointer_UpLeft: c_uint = 0xfee4;
pub const XK_Pointer_UpRight: c_uint = 0xfee5;
pub const XK_Pointer_DownLeft: c_uint = 0xfee6;
pub const XK_Pointer_DownRight: c_uint = 0xfee7;
pub const XK_Pointer_Button_Dflt: c_uint = 0xfee8;
pub const XK_Pointer_Button1: c_uint = 0xfee9;
pub const XK_Pointer_Button2: c_uint = 0xfeea;
pub const XK_Pointer_Button3: c_uint = 0xfeeb;
pub const XK_Pointer_Button4: c_uint = 0xfeec;
pub const XK_Pointer_Button5: c_uint = 0xfeed;
pub const XK_Pointer_DblClick_Dflt: c_uint = 0xfeee;
pub const XK_Pointer_DblClick1: c_uint = 0xfeef;
pub const XK_Pointer_DblClick2: c_uint = 0xfef0;
pub const XK_Pointer_DblClick3: c_uint = 0xfef1;
pub const XK_Pointer_DblClick4: c_uint = 0xfef2;
pub const XK_Pointer_DblClick5: c_uint = 0xfef3;
pub const XK_Pointer_Drag_Dflt: c_uint = 0xfef4;
pub const XK_Pointer_Drag1: c_uint = 0xfef5;
pub const XK_Pointer_Drag2: c_uint = 0xfef6;
pub const XK_Pointer_Drag3: c_uint = 0xfef7;
pub const XK_Pointer_Drag4: c_uint = 0xfef8;
pub const XK_Pointer_Drag5: c_uint = 0xfefd;

pub const XK_Pointer_EnableKeys: c_uint = 0xfef9;
pub const XK_Pointer_Accelerate: c_uint = 0xfefa;
pub const XK_Pointer_DfltBtnNext: c_uint = 0xfefb;
pub const XK_Pointer_DfltBtnPrev: c_uint = 0xfefc;

pub const XK_ch: c_uint = 0xfea0;
pub const XK_Ch: c_uint = 0xfea1;
pub const XK_CH: c_uint = 0xfea2;
pub const XK_c_h: c_uint = 0xfea3;
pub const XK_C_h: c_uint = 0xfea4;
pub const XK_C_H: c_uint = 0xfea5;
